/*
 * Decompiled with CFR 0.152.
 */
package com.github.dcysteine.neicustomdiagram.generators.gregtech5.lenses;

import com.github.dcysteine.neicustomdiagram.api.diagram.Diagram;
import com.github.dcysteine.neicustomdiagram.api.diagram.component.Component;
import com.github.dcysteine.neicustomdiagram.api.diagram.component.DisplayComponent;
import com.github.dcysteine.neicustomdiagram.api.diagram.interactable.Interactable;
import com.github.dcysteine.neicustomdiagram.api.diagram.layout.Layout;
import com.github.dcysteine.neicustomdiagram.api.diagram.matcher.ComponentDiagramMatcher;
import com.github.dcysteine.neicustomdiagram.api.diagram.tooltip.Tooltip;
import com.github.dcysteine.neicustomdiagram.generators.gregtech5.lenses.LayoutHandler;
import com.github.dcysteine.neicustomdiagram.generators.gregtech5.lenses.RecipeHandler;
import com.github.dcysteine.neicustomdiagram.main.Lang;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;

class DiagramFactory {
    private final LayoutHandler layoutHandler;
    private final RecipeHandler recipeHandler;

    DiagramFactory(LayoutHandler layoutHandler, RecipeHandler recipeHandler) {
        this.layoutHandler = layoutHandler;
        this.recipeHandler = recipeHandler;
    }

    void buildDiagrams(RecipeHandler.Lens lens, ComponentDiagramMatcher.Builder matcherBuilder) {
        ArrayList recipes = Lists.newArrayList(this.recipeHandler.recipes(lens));
        Comparator<RecipeHandler.Recipe> recipeComparator = Comparator.comparing(recipe -> this.recipeHandler.isColourRecipe(lens.colour(), (RecipeHandler.Recipe)recipe)).thenComparing(Comparator.naturalOrder());
        recipes.sort(recipeComparator);
        List partitionedRecipes = Lists.partition((List)recipes, (int)24);
        partitionedRecipes.forEach(partition -> this.buildDiagram(lens, matcherBuilder, (List<RecipeHandler.Recipe>)partition));
    }

    void buildDiagram(RecipeHandler.Lens lens, ComponentDiagramMatcher.Builder matcherBuilder, List<RecipeHandler.Recipe> recipes) {
        Diagram.Builder diagramBuilder = Diagram.builder().addAllLayouts((Iterable<Layout>)this.layoutHandler.requiredLayouts()).addAllOptionalLayouts((Iterable<Layout>)this.layoutHandler.optionalLayouts()).addInteractable(lens.colour().buildLabel());
        HashSet craftingComponents = Sets.newHashSet((Object[])new Component[]{lens.itemComponent()});
        HashSet usageComponents = Sets.newHashSet((Object[])new Component[]{lens.itemComponent()});
        Diagram.Builder.SlotGroupAutoSubBuilder slotGroupSubBuilder = diagramBuilder.autoInsertIntoSlotGroup(LayoutHandler.SlotGroupKeys.SAME_COLOUR_LENSES);
        for (RecipeHandler.Lens sameColourLens : this.recipeHandler.lenses(lens.colour())) {
            DisplayComponent.Builder displayComponentBuilder = DisplayComponent.builder(sameColourLens.itemComponent());
            if (sameColourLens.equals(lens)) {
                displayComponentBuilder.setAdditionalInfo("*").setAdditionalTooltip(Tooltip.create(Lang.GREGTECH_5_LENSES.trans("currentlenslabel"), Tooltip.INFO_FORMATTING));
            }
            slotGroupSubBuilder.insertIntoNextSlot(displayComponentBuilder.build());
        }
        for (int i = 0; i < recipes.size(); ++i) {
            RecipeHandler.Recipe recipe = recipes.get(i);
            DisplayComponent.Builder inputBuilder = DisplayComponent.builder(recipe.input());
            if (this.recipeHandler.isColourRecipe(lens.colour(), recipe)) {
                inputBuilder.setAdditionalTooltip(Tooltip.create(Lang.GREGTECH_5_LENSES.transf("colourrecipelabel", lens.colour().translateColour()), Tooltip.INFO_FORMATTING));
            } else {
                inputBuilder.setAdditionalInfo("*").setAdditionalTooltip(Tooltip.create(Lang.GREGTECH_5_LENSES.trans("specificrecipelabel"), Tooltip.INFO_FORMATTING));
            }
            diagramBuilder.insertIntoSlot((Layout.SlotKey)LayoutHandler.SLOT_RECIPE_INPUTS.get(i), inputBuilder.build());
            diagramBuilder.insertIntoSlot((Layout.SlotKey)LayoutHandler.SLOT_RECIPE_OUTPUTS.get(i), recipe.output());
            craftingComponents.add(recipe.output().component());
            usageComponents.add(recipe.input());
        }
        matcherBuilder.addDiagram(diagramBuilder.build()).addAllComponents(Interactable.RecipeType.CRAFTING, craftingComponents).addAllComponents(Interactable.RecipeType.USAGE, usageComponents);
    }
}

