/*
 * Decompiled with CFR 0.152.
 */
package com.github.dcysteine.neicustomdiagram.api.diagram.interactable;

import codechicken.nei.recipe.GuiCraftingRecipe;
import codechicken.nei.recipe.GuiUsageRecipe;
import com.github.dcysteine.neicustomdiagram.api.diagram.DiagramState;
import com.github.dcysteine.neicustomdiagram.api.diagram.interactable.Interactable;
import com.github.dcysteine.neicustomdiagram.api.diagram.tooltip.Tooltip;
import com.github.dcysteine.neicustomdiagram.api.draw.BoundedDrawable;
import com.github.dcysteine.neicustomdiagram.api.draw.Dimension;
import com.github.dcysteine.neicustomdiagram.api.draw.Point;
import java.util.function.Consumer;

public class CustomInteractable
implements Interactable {
    protected final BoundedDrawable drawable;
    protected final Tooltip tooltip;
    protected final Consumer<Interactable.RecipeType> interact;
    protected final Consumer<Point> drawBackground;
    protected final Consumer<Point> drawForeground;
    protected final Consumer<Point> drawOverlay;

    protected CustomInteractable(BoundedDrawable drawable, Tooltip tooltip, Consumer<Interactable.RecipeType> interact, Consumer<Point> drawBackground, Consumer<Point> drawForeground, Consumer<Point> drawOverlay) {
        this.drawable = drawable;
        this.tooltip = tooltip;
        this.interact = interact;
        this.drawBackground = drawBackground;
        this.drawForeground = drawForeground;
        this.drawOverlay = drawOverlay;
    }

    public BoundedDrawable drawable() {
        return this.drawable;
    }

    public Tooltip tooltip() {
        return this.tooltip;
    }

    @Override
    public Point position() {
        return this.drawable.position();
    }

    @Override
    public Dimension dimension() {
        return this.drawable.dimension();
    }

    @Override
    public void interact(DiagramState diagramState, Interactable.RecipeType recipeType) {
        this.interact.accept(recipeType);
    }

    @Override
    public void draw(DiagramState diagramState) {
        this.drawBackground.accept(this.position());
        this.drawable.draw(diagramState);
        this.drawForeground.accept(this.position());
    }

    @Override
    public void drawOverlay(DiagramState diagramState) {
        this.drawOverlay.accept(this.position());
    }

    @Override
    public void drawTooltip(DiagramState diagramState, Point mousePos) {
        this.tooltip.draw(mousePos);
    }

    protected static Consumer<Interactable.RecipeType> buildInteractionLambda(String id) {
        return recipeType -> {
            switch (recipeType) {
                case CRAFTING: {
                    GuiUsageRecipe.openRecipeGui((String)id, (Object[])new Object[0]);
                    break;
                }
                case USAGE: {
                    GuiCraftingRecipe.openRecipeGui((String)id, (Object[])new Object[0]);
                }
            }
        };
    }

    public static Builder builder(BoundedDrawable drawable) {
        return new Builder(drawable);
    }

    public static final class Builder {
        private final BoundedDrawable drawable;
        private Tooltip tooltip;
        private Consumer<Interactable.RecipeType> interact;
        private Consumer<Point> drawBackground;
        private Consumer<Point> drawForeground;
        private Consumer<Point> drawOverlay;

        private Builder(BoundedDrawable drawable) {
            this.drawable = drawable;
            this.tooltip = Tooltip.EMPTY_TOOLTIP;
            this.interact = recipeType -> {};
            this.drawBackground = position -> {};
            this.drawForeground = position -> {};
            this.drawOverlay = position -> {};
        }

        public Builder setTooltip(Tooltip tooltip) {
            this.tooltip = tooltip;
            return this;
        }

        public Builder setInteract(String id) {
            this.interact = CustomInteractable.buildInteractionLambda(id);
            return this;
        }

        public Builder setInteract(Consumer<Interactable.RecipeType> interact) {
            this.interact = interact;
            return this;
        }

        public Builder setDrawBackground(Consumer<Point> drawBackground) {
            this.drawBackground = drawBackground;
            return this;
        }

        public Builder setDrawForeground(Consumer<Point> drawForeground) {
            this.drawForeground = drawForeground;
            return this;
        }

        public Builder setDrawOverlay(Consumer<Point> drawOverlay) {
            this.drawOverlay = drawOverlay;
            return this;
        }

        public CustomInteractable build() {
            return new CustomInteractable(this.drawable, this.tooltip, this.interact, this.drawBackground, this.drawForeground, this.drawOverlay);
        }
    }
}

