/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.xmod.gregtech.api.items;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import gregtech.api.GregTechAPI;
import gregtech.api.enums.GTValues;
import gregtech.api.enums.Materials;
import gregtech.api.enums.Mods;
import gregtech.api.enums.SubTag;
import gregtech.api.enums.TCAspects;
import gregtech.api.interfaces.IFoodStat;
import gregtech.api.interfaces.IIconContainer;
import gregtech.api.interfaces.IItemContainer;
import gregtech.api.objects.ItemData;
import gregtech.api.util.GTLanguageManager;
import gregtech.api.util.GTOreDictUnificator;
import gregtech.api.util.GTUtility;
import gtPlusPlus.core.creative.AddToCreativeTab;
import gtPlusPlus.xmod.gregtech.api.interfaces.internal.IItemBehaviour;
import gtPlusPlus.xmod.gregtech.api.items.GTMetaItemBase;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.HashMap;
import java.util.List;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumAction;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.world.World;

public abstract class GTMetaItem
extends GTMetaItemBase {
    public static final HashMap<String, GTMetaItem> sInstances = new HashMap();
    public final short mOffset;
    public final short mItemAmount;
    public final BitSet mEnabledItems;
    public final BitSet mVisibleItems;
    public final IIcon[][] mIconList;
    public final HashMap<Short, IFoodStat> mFoodStats = new HashMap();
    public final HashMap<Short, Long[]> mElectricStats = new HashMap();
    public final HashMap<Short, Long[]> mFluidContainerStats = new HashMap();
    public final HashMap<Short, Short> mBurnValues = new HashMap();

    public GTMetaItem(String aUnlocalized, short aOffset, short aItemAmount) {
        super(aUnlocalized);
        this.func_77637_a(AddToCreativeTab.tabMachines);
        this.func_77627_a(true);
        this.func_77656_e(0);
        this.mEnabledItems = new BitSet(aItemAmount);
        this.mVisibleItems = new BitSet(aItemAmount);
        this.mOffset = (short)Math.min(32766, aOffset);
        this.mItemAmount = (short)Math.min(aItemAmount, 32766 - this.mOffset);
        this.mIconList = new IIcon[aItemAmount][1];
        sInstances.put(this.func_77658_a(), this);
    }

    public final ItemStack addItem(int aID, String aEnglish, String aToolTip, Object ... aRandomData) {
        if (aToolTip == null) {
            aToolTip = "";
        }
        if (aID >= 0 && aID < this.mItemAmount) {
            ItemStack rStack = new ItemStack((Item)this, 1, this.mOffset + aID);
            this.mEnabledItems.set(aID);
            this.mVisibleItems.set(aID);
            GTLanguageManager.addStringLocalization(this.func_77667_c(rStack) + ".name", aEnglish);
            GTLanguageManager.addStringLocalization(this.func_77667_c(rStack) + ".tooltip", aToolTip);
            ArrayList<TCAspects.TC_AspectStack> tAspects = new ArrayList<TCAspects.TC_AspectStack>();
            for (Object tRandomData : aRandomData) {
                if (!(tRandomData instanceof SubTag)) continue;
                if (tRandomData == SubTag.INVISIBLE) {
                    this.mVisibleItems.set(aID, false);
                    continue;
                }
                if (tRandomData != SubTag.NO_UNIFICATION) continue;
                GTOreDictUnificator.addToBlacklist(rStack);
            }
            for (Object tRandomData : aRandomData) {
                if (tRandomData == null) continue;
                boolean tUseOreDict = true;
                if (tRandomData instanceof IItemBehaviour) {
                    this.addItemBehavior(this.mOffset + aID, (IItemBehaviour)tRandomData);
                    tUseOreDict = false;
                }
                if (tRandomData instanceof IItemContainer) {
                    ((IItemContainer)tRandomData).set(rStack);
                    tUseOreDict = false;
                }
                if (tRandomData instanceof SubTag) continue;
                if (tRandomData instanceof TCAspects.TC_AspectStack) {
                    ((TCAspects.TC_AspectStack)tRandomData).addToAspectList(tAspects);
                    continue;
                }
                if (tRandomData instanceof ItemData) {
                    if (GTUtility.isStringValid(tRandomData)) {
                        GTOreDictUnificator.registerOre(tRandomData, rStack);
                        continue;
                    }
                    GTOreDictUnificator.addItemData(rStack, (ItemData)tRandomData);
                    continue;
                }
                if (!tUseOreDict) continue;
                GTOreDictUnificator.registerOre(tRandomData, rStack);
            }
            if (GregTechAPI.sThaumcraftCompat != null) {
                GregTechAPI.sThaumcraftCompat.registerThaumcraftAspectsToItem(rStack, tAspects, false);
            }
            return rStack;
        }
        return null;
    }

    public final GTMetaItem setBurnValue(int aMetaValue, int aValue) {
        if (aMetaValue < 0 || aMetaValue >= this.mOffset + this.mEnabledItems.length() || aValue < 0) {
            return this;
        }
        if (aValue == 0) {
            this.mBurnValues.remove((short)aMetaValue);
        } else {
            this.mBurnValues.put((short)aMetaValue, (short)(aValue > Short.MAX_VALUE ? Short.MAX_VALUE : (short)aValue));
        }
        return this;
    }

    public final GTMetaItem setElectricStats(int aMetaValue, long aMaxCharge, long aTransferLimit, long aTier, long aSpecialData, boolean aUseAnimations) {
        if (aMetaValue < 0 || aMetaValue >= this.mOffset + this.mEnabledItems.length()) {
            return this;
        }
        if (aMaxCharge == 0L) {
            this.mElectricStats.remove((short)aMetaValue);
        } else {
            this.mElectricStats.put((short)aMetaValue, new Long[]{aMaxCharge, Math.max(0L, aTransferLimit), Math.max(-1L, aTier), aSpecialData});
            if (aMetaValue >= this.mOffset && aUseAnimations) {
                this.mIconList[aMetaValue - this.mOffset] = Arrays.copyOf(this.mIconList[aMetaValue - this.mOffset], Math.max(9, this.mIconList[aMetaValue - this.mOffset].length));
            }
        }
        return this;
    }

    public final GTMetaItem setFluidContainerStats(int aMetaValue, long aCapacity, long aStacksize) {
        if (aMetaValue < 0 || aMetaValue >= this.mOffset + this.mEnabledItems.length()) {
            return this;
        }
        if (aCapacity < 0L) {
            this.mElectricStats.remove((short)aMetaValue);
        } else {
            this.mFluidContainerStats.put((short)aMetaValue, new Long[]{aCapacity, Math.max(1L, aStacksize)});
        }
        return this;
    }

    public boolean useStandardMetaItemRenderer() {
        return true;
    }

    public short[] getRGBa(ItemStack aStack) {
        return Materials._NULL.getRGBA();
    }

    public IIconContainer getIconContainer(int aMetaData) {
        return null;
    }

    @Override
    public ItemStack func_77659_a(ItemStack aStack, World aWorld, EntityPlayer aPlayer) {
        return super.func_77659_a(aStack, aWorld, aPlayer);
    }

    public int func_77626_a(ItemStack aStack) {
        return this.mFoodStats.get((short)this.getDamage(aStack)) == null ? 0 : 32;
    }

    public EnumAction func_77661_b(ItemStack aStack) {
        return EnumAction.none;
    }

    public final ItemStack func_77654_b(ItemStack aStack, World aWorld, EntityPlayer aPlayer) {
        IFoodStat tStat = this.mFoodStats.get((short)this.getDamage(aStack));
        if (tStat != null) {
            // empty if block
        }
        return aStack;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(Item var1, CreativeTabs aCreativeTab, List aList) {
        int j = this.mEnabledItems.length();
        for (int i = 0; i < j; ++i) {
            ItemStack tStack;
            if (!this.mVisibleItems.get(i) && (!GTValues.D1 || !this.mEnabledItems.get(i))) continue;
            Long[] tStats = this.mElectricStats.get((short)(this.mOffset + i));
            if (tStats != null && tStats[3] < 0L) {
                tStack = new ItemStack((Item)this, 1, this.mOffset + i);
                this.setCharge(tStack, Math.abs(tStats[0]));
                this.isItemStackUsable(tStack);
                aList.add(tStack);
            }
            if (tStats != null && tStats[3] == -2L) continue;
            tStack = new ItemStack((Item)this, 1, this.mOffset + i);
            this.isItemStackUsable(tStack);
            aList.add(tStack);
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public final void func_94581_a(IIconRegister aIconRegister) {
        short j = (short)this.mEnabledItems.length();
        for (short i = 0; i < j; i = (short)(i + 1)) {
            if (!this.mEnabledItems.get(i)) continue;
            for (int k = 1; k < this.mIconList[i].length; k = (int)((byte)(k + 1))) {
                this.mIconList[i][k] = aIconRegister.func_94245_a(Mods.GTPlusPlus.ID + ":" + this.func_77658_a() + "/" + i + "/" + k);
            }
            this.mIconList[i][0] = aIconRegister.func_94245_a(Mods.GTPlusPlus.ID + ":" + this.func_77658_a() + "/" + i);
        }
    }

    @Override
    public final Long[] getElectricStats(ItemStack aStack) {
        return this.mElectricStats.get((short)aStack.func_77960_j());
    }

    @Override
    public final Long[] getFluidContainerStats(ItemStack aStack) {
        return this.mFluidContainerStats.get((short)aStack.func_77960_j());
    }

    @Override
    public int func_77619_b() {
        return 0;
    }

    @Override
    public boolean isBookEnchantable(ItemStack aStack, ItemStack aBook) {
        return false;
    }

    @Override
    public boolean func_82789_a(ItemStack aStack, ItemStack aMaterial) {
        return false;
    }

    @Override
    public int func_82790_a(ItemStack stack, int HEX_OxFFFFFF) {
        HEX_OxFFFFFF = stack.func_82833_r().contains("LuV") ? 0xFFFFCC : (stack.func_82833_r().contains("ZPM") ? 11331072 : (stack.func_82833_r().contains("UV") ? 0xFFFF00 : (stack.func_82833_r().contains("MAX") ? 0xFF0000 : 0xFFFFFF)));
        return HEX_OxFFFFFF;
    }
}

