/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.tileentities.storage;

import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.common.tileentities.storage.MTEDigitalChestBase;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;

public class MTEQuantumChest
extends MTEDigitalChestBase {
    public int mItemCount = 0;
    public ItemStack mItemStack = null;
    NBTTagList mInvData = null;

    public MTEQuantumChest(int aID, String aName, String aNameRegional, int aTier) {
        super(aID, aName, aNameRegional, aTier);
    }

    public MTEQuantumChest(String aName, int aTier, String aDescription, ITexture[][][] aTextures) {
        super(aName, aTier, aDescription, aTextures);
    }

    public MTEQuantumChest(String aName, int aTier, String[] aDescription, ITexture[][][] aTextures) {
        super(aName, aTier, aDescription, aTextures);
    }

    @Override
    public MetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new MTEQuantumChest(this.mName, (int)this.mTier, this.mDescriptionArray, this.mTextures);
    }

    @Override
    public void setItemNBT(NBTTagCompound aNBT) {
        this.mInvData = new NBTTagList();
        boolean hasInvData = false;
        for (int i = 0; i < 3; ++i) {
            if (this.mInventory[i] == null) continue;
            NBTTagCompound tNBT = new NBTTagCompound();
            tNBT.func_74774_a("Count", (byte)this.mInventory[i].field_77994_a);
            tNBT.func_74777_a("Damage", (short)this.mInventory[i].func_77960_j());
            tNBT.func_74777_a("id", (short)Item.func_150891_b((Item)this.mInventory[i].func_77973_b()));
            tNBT.func_74768_a("IntSlot", i);
            if (this.mInventory[i].func_77942_o()) {
                tNBT.func_74782_a("tag", (NBTBase)this.mInventory[i].func_77978_p());
            }
            this.mInvData.func_74742_a((NBTBase)tNBT);
            hasInvData = true;
        }
        if (this.mItemStack != null) {
            aNBT.func_74782_a("mItemStack", (NBTBase)this.getItemStack().func_77955_b(new NBTTagCompound()));
        }
        if (hasInvData) {
            aNBT.func_74782_a("Inventory", (NBTBase)this.mInvData);
        }
        if (this.getItemCount() > 0) {
            aNBT.func_74768_a("mItemCount", this.getItemCount());
        }
        if (this.mVoidOverflow) {
            aNBT.func_74757_a("mVoidOverflow", true);
        }
        super.setItemNBT(aNBT);
    }

    @Override
    protected String chestName() {
        return "Quantum Chest";
    }

    @Override
    protected int getItemCount() {
        return this.mItemCount;
    }

    @Override
    public void setItemCount(int aCount) {
        this.mItemCount = aCount;
    }

    @Override
    protected ItemStack getItemStack() {
        return this.mItemStack;
    }

    @Override
    protected void setItemStack(ItemStack s) {
        this.mItemStack = s;
    }

    @Override
    @Nullable
    public List<ItemStack> getItemsForHoloGlasses() {
        ArrayList<ItemStack> ret = new ArrayList<ItemStack>();
        ret.add(this.func_70301_a(0));
        ret.add(this.func_70301_a(1));
        if (this.mItemStack != null) {
            ItemStack copy = this.mItemStack.func_77946_l();
            copy.field_77994_a = this.mItemCount;
            ret.add(copy);
        }
        return ret;
    }
}

