/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.task.tasks;

import gregtech.api.interfaces.tileentity.IMachineProgress;
import gregtech.api.task.TaskHost;
import gregtech.api.task.TickableTask;
import gregtech.common.pollution.Pollution;
import javax.annotation.Nonnull;
import net.minecraft.tileentity.TileEntity;

public class PollutionTask<T extends TaskHost & IMachineProgress>
extends TickableTask<T> {
    private int pollutionPerSecond;
    private static final int POLLUTION_TICK = 20;

    public PollutionTask(@Nonnull T taskHost) {
        super(taskHost);
    }

    public PollutionTask<T> setPollutionPerSecond(int pollutionPerSecond) {
        this.pollutionPerSecond = pollutionPerSecond;
        return this;
    }

    public int getPollutionPerSecond() {
        return this.pollutionPerSecond;
    }

    @Override
    @Nonnull
    public String getName() {
        return "pollution";
    }

    @Override
    public void update(long tick, boolean isServerSide) {
        TaskHost taskHost;
        if (isServerSide && tick % 20L == 0L && ((IMachineProgress)((Object)this.taskHost)).hasThingsToDo() && (taskHost = this.taskHost) instanceof TileEntity) {
            TileEntity entity = (TileEntity)taskHost;
            Pollution.addPollution(entity, this.getPollutionPerSecond());
        }
    }
}

