/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.objects;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import gregtech.api.enums.Dimensions;
import gregtech.api.enums.UndergroundFluidNames;
import gregtech.api.objects.GTUODimension;
import java.util.Arrays;
import java.util.Map;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.common.config.ConfigCategory;
import net.minecraftforge.common.config.Configuration;

public class GTUODimensionList {
    private Configuration fConfig;
    private String fCategory;
    private final BiMap<String, GTUODimension> fDimensionList;
    public int[] blackList = new int[0];

    public GTUODimensionList() {
        this.fDimensionList = HashBiMap.create();
    }

    public void save() {
        this.fConfig.save();
    }

    public GTUODimension GetDimension(int aDimension) {
        if (this.CheckBlackList(aDimension)) {
            return null;
        }
        if (this.fDimensionList.containsKey((Object)Integer.toString(aDimension))) {
            return (GTUODimension)this.fDimensionList.get((Object)Integer.toString(aDimension));
        }
        for (Map.Entry dl : this.fDimensionList.entrySet()) {
            if (!DimensionManager.getProvider((int)aDimension).getClass().getName().contains(((GTUODimension)dl.getValue()).Dimension)) continue;
            return (GTUODimension)dl.getValue();
        }
        return (GTUODimension)this.fDimensionList.get((Object)"Default");
    }

    private boolean CheckBlackList(int aDimensionId) {
        try {
            return Arrays.binarySearch(this.blackList, aDimensionId) >= 0;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public void SetConfigValues(String aDimensionName, String aDimension, String aName, String aRegistry, int aMinAmount, int aMaxAmount, int aChance, int aDecreasePerOperationAmount) {
        String Category2 = this.fCategory + "." + aDimensionName;
        this.fConfig.get(Category2, "Dimension", aDimension).getString();
        Category2 = Category2 + "." + aName;
        this.fConfig.get(Category2, "Registry", aRegistry).getString();
        this.fConfig.get(Category2, "MinAmount", aMinAmount).getInt(aMinAmount);
        this.fConfig.get(Category2, "MaxAmount", aMaxAmount).getInt(aMaxAmount);
        this.fConfig.get(Category2, "Chance", aChance).getInt(aChance);
        this.fConfig.get(Category2, "DecreasePerOperationAmount", aDecreasePerOperationAmount).getInt(aDecreasePerOperationAmount);
    }

    private void setOverworldValues() {
        new ConfigSetter().dimension(Dimensions.Overworld).fluid(UndergroundFluidNames.naturalGas).chance(20).decreaseAmount(5).maxAmount(350).minAmount(10).writeToConfig();
        new ConfigSetter().dimension(Dimensions.Overworld).fluid(UndergroundFluidNames.lightOil).chance(20).decreaseAmount(5).maxAmount(350).minAmount(10).writeToConfig();
        new ConfigSetter().dimension(Dimensions.Overworld).fluid(UndergroundFluidNames.mediumOil).chance(20).decreaseAmount(5).maxAmount(625).minAmount(0).writeToConfig();
        new ConfigSetter().dimension(Dimensions.Overworld).fluid(UndergroundFluidNames.heavyOil).chance(20).decreaseAmount(5).maxAmount(625).minAmount(0).writeToConfig();
        new ConfigSetter().dimension(Dimensions.Overworld).fluid(UndergroundFluidNames.oil).chance(20).decreaseAmount(5).maxAmount(625).minAmount(0).writeToConfig();
    }

    private void setMoonValues() {
        new ConfigSetter().dimension(Dimensions.Moon).fluid(UndergroundFluidNames.helium3).chance(100).decreaseAmount(5).maxAmount(425).minAmount(0).writeToConfig();
        new ConfigSetter().dimension(Dimensions.Moon).fluid(UndergroundFluidNames.saltWater).chance(20).decreaseAmount(5).maxAmount(200).minAmount(0).writeToConfig();
    }

    private void setMercuryValues() {
        new ConfigSetter().dimension(Dimensions.Mercury).fluid(UndergroundFluidNames.helium3).chance(100).decreaseAmount(5).maxAmount(800).minAmount(0).writeToConfig();
        new ConfigSetter().dimension(Dimensions.Mercury).fluid(UndergroundFluidNames.moltenIron).chance(30).decreaseAmount(5).maxAmount(400).minAmount(0).writeToConfig();
    }

    private void setVenusValues() {
        new ConfigSetter().dimension(Dimensions.Venus).fluid(UndergroundFluidNames.moltenLead).chance(100).decreaseAmount(5).maxAmount(1600).minAmount(0).writeToConfig();
        new ConfigSetter().dimension(Dimensions.Venus).fluid(UndergroundFluidNames.sulfuricAcid).chance(100).decreaseAmount(5).maxAmount(250).minAmount(0).writeToConfig();
        new ConfigSetter().dimension(Dimensions.Venus).fluid(UndergroundFluidNames.carbonDioxide).chance(100).decreaseAmount(5).maxAmount(1500).minAmount(0).writeToConfig();
    }

    private void setMarsValues() {
        new ConfigSetter().dimension(Dimensions.Mars).fluid(UndergroundFluidNames.saltWater).chance(100).decreaseAmount(5).maxAmount(400).minAmount(0).writeToConfig();
        new ConfigSetter().dimension(Dimensions.Mars).fluid(UndergroundFluidNames.chlorobenzene).chance(100).decreaseAmount(5).maxAmount(400).minAmount(0).writeToConfig();
    }

    private void setIoValues() {
        new ConfigSetter().dimension(Dimensions.Io).fluid(UndergroundFluidNames.moltenLead).chance(20).decreaseAmount(5).maxAmount(650).minAmount(0).writeToConfig();
        new ConfigSetter().dimension(Dimensions.Io).fluid(UndergroundFluidNames.sulfuricAcid).chance(80).decreaseAmount(5).maxAmount(350).minAmount(0).writeToConfig();
        new ConfigSetter().dimension(Dimensions.Io).fluid(UndergroundFluidNames.carbonDioxide).chance(80).decreaseAmount(5).maxAmount(750).minAmount(0).writeToConfig();
    }

    private void setEuropaValues() {
        new ConfigSetter().dimension(Dimensions.Europa).fluid(UndergroundFluidNames.saltWater).chance(100).decreaseAmount(5).maxAmount(800).minAmount(0).writeToConfig();
        new ConfigSetter().dimension(Dimensions.Europa).fluid(UndergroundFluidNames.veryHeavyOil).chance(20).decreaseAmount(5).maxAmount(200).minAmount(0).writeToConfig();
        new ConfigSetter().dimension(Dimensions.Europa).fluid(UndergroundFluidNames.distilledWater).chance(80).decreaseAmount(5).maxAmount(3500).minAmount(0).writeToConfig();
    }

    private void setCallistoValues() {
        new ConfigSetter().dimension(Dimensions.Callisto).fluid(UndergroundFluidNames.oxygen).chance(100).decreaseAmount(5).maxAmount(200).minAmount(0).writeToConfig();
        new ConfigSetter().dimension(Dimensions.Callisto).fluid(UndergroundFluidNames.liquidAir).chance(100).decreaseAmount(5).maxAmount(200).minAmount(0).writeToConfig();
    }

    private void setTitanValues() {
        new ConfigSetter().dimension(Dimensions.Titan).fluid(UndergroundFluidNames.methane).chance(100).decreaseAmount(5).maxAmount(800).minAmount(0).writeToConfig();
        new ConfigSetter().dimension(Dimensions.Titan).fluid(UndergroundFluidNames.ethane).chance(100).decreaseAmount(5).maxAmount(200).minAmount(0).writeToConfig();
    }

    private void setMirandaValues() {
        new ConfigSetter().dimension(Dimensions.Miranda).fluid(UndergroundFluidNames.hydrogenSulfide).chance(100).decreaseAmount(5).maxAmount(900).minAmount(0).writeToConfig();
    }

    private void setOberonValues() {
        new ConfigSetter().dimension(Dimensions.Oberon).fluid(UndergroundFluidNames.carbonMonoxide).chance(100).decreaseAmount(5).maxAmount(2000).minAmount(0).writeToConfig();
    }

    private void setTritonValues() {
        new ConfigSetter().dimension(Dimensions.Triton).fluid(UndergroundFluidNames.nitrogen).chance(100).decreaseAmount(5).maxAmount(800).minAmount(0).writeToConfig();
        new ConfigSetter().dimension(Dimensions.Triton).fluid(UndergroundFluidNames.ethylene).chance(100).decreaseAmount(5).maxAmount(800).minAmount(0).writeToConfig();
    }

    private void setProteusValues() {
        new ConfigSetter().dimension(Dimensions.Proteus).fluid(UndergroundFluidNames.deuterium).chance(100).decreaseAmount(5).maxAmount(700).minAmount(0).writeToConfig();
    }

    private void setPlutoValues() {
        new ConfigSetter().dimension(Dimensions.Pluto).fluid(UndergroundFluidNames.nitrogen).chance(100).decreaseAmount(5).maxAmount(800).minAmount(0).writeToConfig();
        new ConfigSetter().dimension(Dimensions.Pluto).fluid(UndergroundFluidNames.oxygen).chance(100).decreaseAmount(5).maxAmount(800).minAmount(0).writeToConfig();
        new ConfigSetter().dimension(Dimensions.Pluto).fluid(UndergroundFluidNames.liquidAir).chance(40).decreaseAmount(5).maxAmount(300).minAmount(4).writeToConfig();
        new ConfigSetter().dimension(Dimensions.Pluto).fluid(UndergroundFluidNames.fluorine).chance(80).decreaseAmount(5).maxAmount(800).minAmount(4).writeToConfig();
    }

    private void setMakeMakeValues() {
        new ConfigSetter().dimension(Dimensions.Makemake).fluid(UndergroundFluidNames.hydrofluoricAcid).chance(80).decreaseAmount(5).maxAmount(300).minAmount(0).writeToConfig();
    }

    private void setAlphaCentauriBBValues() {
        new ConfigSetter().dimension(Dimensions.AlphaCentauriBb).fluid(UndergroundFluidNames.moltenCopper).chance(10).decreaseAmount(5).maxAmount(300).minAmount(0).writeToConfig();
    }

    private void setBarnardaCValues() {
        new ConfigSetter().dimension(Dimensions.BarnardaC).fluid(UndergroundFluidNames.veryHeavyOil).chance(100).decreaseAmount(5).maxAmount(800).minAmount(0).writeToConfig();
        new ConfigSetter().dimension(Dimensions.BarnardaC).fluid(UndergroundFluidNames.unknownWater).chance(100).decreaseAmount(5).maxAmount(300).minAmount(0).writeToConfig();
    }

    private void setBarnardaEValues() {
        new ConfigSetter().dimension(Dimensions.BarnardaE).fluid(UndergroundFluidNames.liquidAir).chance(20).decreaseAmount(5).maxAmount(400).minAmount(0).writeToConfig();
    }

    private void setBarnardaFValues() {
        new ConfigSetter().dimension(Dimensions.BarnardaF).fluid(UndergroundFluidNames.moltenTin).chance(15).decreaseAmount(5).maxAmount(400).minAmount(0).writeToConfig();
    }

    private void setTcetiEValues() {
        new ConfigSetter().dimension(Dimensions.TCetiE).fluid(UndergroundFluidNames.veryHeavyOil).chance(100).decreaseAmount(5).maxAmount(200).minAmount(0).writeToConfig();
        new ConfigSetter().dimension(Dimensions.TCetiE).fluid(UndergroundFluidNames.hydrogen).chance(50).decreaseAmount(5).maxAmount(700).minAmount(0).writeToConfig();
        new ConfigSetter().dimension(Dimensions.TCetiE).fluid(UndergroundFluidNames.distilledWater).chance(100).decreaseAmount(5).maxAmount(10000).minAmount(0).writeToConfig();
    }

    private void setRoss128bValues() {
        new ConfigSetter().dimension(Dimensions.Ross128b).fluid(UndergroundFluidNames.veryHeavyOil).chance(40).decreaseAmount(5).maxAmount(625).minAmount(0).writeToConfig();
        new ConfigSetter().dimension(Dimensions.Ross128b).fluid(UndergroundFluidNames.lava).chance(5).decreaseAmount(5).maxAmount(820).minAmount(0).writeToConfig();
        new ConfigSetter().dimension(Dimensions.Ross128b).fluid(UndergroundFluidNames.naturalGas).chance(65).decreaseAmount(5).maxAmount(625).minAmount(0).writeToConfig();
        new ConfigSetter().dimension(Dimensions.Ross128b).fluid(UndergroundFluidNames.distilledWater).chance(100).decreaseAmount(5).maxAmount(5000).minAmount(0).writeToConfig();
    }

    private void setRoss128baValues() {
        new ConfigSetter().dimension(Dimensions.Ross128ba).fluid(UndergroundFluidNames.saltWater).chance(40).decreaseAmount(5).maxAmount(1250).minAmount(0).writeToConfig();
        new ConfigSetter().dimension(Dimensions.Ross128ba).fluid(UndergroundFluidNames.helium3).chance(60).decreaseAmount(5).maxAmount(1250).minAmount(0).writeToConfig();
    }

    public void setDefaultValues() {
        this.setOverworldValues();
        this.setMoonValues();
        this.setMercuryValues();
        this.setVenusValues();
        this.setMarsValues();
        this.setIoValues();
        this.setEuropaValues();
        this.setCallistoValues();
        this.setTitanValues();
        this.setMirandaValues();
        this.setOberonValues();
        this.setTritonValues();
        this.setProteusValues();
        this.setPlutoValues();
        this.setMakeMakeValues();
        this.setAlphaCentauriBBValues();
        this.setBarnardaCValues();
        this.setBarnardaEValues();
        this.setBarnardaFValues();
        this.setTcetiEValues();
        this.setRoss128bValues();
        this.setRoss128baValues();
    }

    public void getConfig(Configuration aConfig, String aCategory) {
        this.fCategory = aCategory;
        this.fConfig = aConfig;
        if (!this.fConfig.hasCategory(this.fCategory)) {
            this.setDefaultValues();
        }
        this.blackList = new int[]{-1, 1};
        this.blackList = aConfig.get(this.fCategory, "DimBlackList", this.blackList, "Dimension IDs Black List").getIntList();
        Arrays.sort(this.blackList);
        for (int i = 0; i < this.fConfig.getCategory(this.fCategory).getChildren().size(); ++i) {
            GTUODimension Dimension2 = new GTUODimension((ConfigCategory)this.fConfig.getCategory(this.fCategory).getChildren().toArray()[i]);
            this.fDimensionList.put((Object)Dimension2.Dimension, (Object)Dimension2);
        }
        this.save();
    }

    public class ConfigSetter {
        private int chance;
        private int decreaseAmount;
        private int maxAmount;
        private int minAmount;
        private UndergroundFluidNames fluid;
        private Dimensions dim;

        public ConfigSetter chance(int chance) {
            this.chance = chance;
            return this;
        }

        public ConfigSetter decreaseAmount(int decreaseAmount) {
            this.decreaseAmount = decreaseAmount;
            return this;
        }

        public ConfigSetter maxAmount(int maxAmount) {
            this.maxAmount = maxAmount;
            return this;
        }

        public ConfigSetter minAmount(int minAmount) {
            this.minAmount = minAmount;
            return this;
        }

        public ConfigSetter fluid(UndergroundFluidNames fluid) {
            this.fluid = fluid;
            return this;
        }

        public ConfigSetter dimension(Dimensions dim) {
            this.dim = dim;
            return this;
        }

        public void writeToConfig() {
            GTUODimensionList.this.SetConfigValues(this.dim.toString(), this.dim.id, this.fluid.toString(), this.fluid.name, this.minAmount, this.maxAmount, this.chance, this.decreaseAmount);
        }
    }
}

