/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.net.data;

import gregtech.api.multitileentity.MultiTileEntityBlock;
import gregtech.api.multitileentity.interfaces.IMultiTileEntity;
import gregtech.api.net.data.Process;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.world.IBlockAccess;

public class MultiTileEntityProcess
extends Process {
    @Nonnull
    private final IBlockAccess world;
    private ChunkCoordinates coords;
    private int registryId;
    private int metaId;
    private byte redstone;
    private byte color;
    private byte commonData;

    public MultiTileEntityProcess(@Nonnull IBlockAccess world) {
        this.world = world;
    }

    @Override
    public void process() {
        if (this.coords == null) {
            return;
        }
        Block block = this.world.func_147439_a(this.coords.field_71574_a, this.coords.field_71572_b, this.coords.field_71573_c);
        if (!(block instanceof MultiTileEntityBlock)) {
            return;
        }
        MultiTileEntityBlock muteBlock = (MultiTileEntityBlock)block;
        IMultiTileEntity mute = muteBlock.receiveMultiTileEntityData(this.world, this.coords.field_71574_a, this.coords.field_71572_b, this.coords.field_71573_c, this.registryId, this.metaId);
        if (mute == null) {
            return;
        }
        mute.setColorization(this.color);
    }

    public void giveCoordinates(@Nonnull ChunkCoordinates coords) {
        this.coords = coords;
    }

    public void giveMultiTileEntityData(int registryId, int metaId) {
        this.registryId = registryId;
        this.metaId = metaId;
    }

    public void giveCommonData(byte redstone, byte color, byte commonData) {
        this.redstone = redstone;
        this.color = color;
        this.commonData = commonData;
    }
}

