/*
 * Decompiled with CFR 0.152.
 */
package bartworks.system.material.gtenhancement;

import bartworks.API.SideReference;
import bartworks.client.textures.PrefixTextureLinker;
import bartworks.system.material.BWMetaGeneratedItems;
import bartworks.system.material.Werkstoff;
import bartworks.system.material.gtenhancement.GTMetaItemEnhancer;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import gregtech.api.enums.Materials;
import gregtech.api.enums.OrePrefixes;
import gregtech.api.enums.TextureSet;
import gregtech.api.enums.Textures;
import gregtech.api.interfaces.IIconContainer;
import gregtech.api.util.GTOreDictUnificator;
import gregtech.common.render.items.GeneratedMaterialRenderer;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.world.World;
import net.minecraftforge.oredict.OreDictionary;

public class BWGTMetaItems
extends BWMetaGeneratedItems {
    private boolean hasList;
    private final Set<Integer> hiddenThings = new HashSet<Integer>();

    public BWGTMetaItems(OrePrefixes orePrefixes, List<Materials> noSubIDMaterials) {
        super(orePrefixes, null);
        ItemStack tStack;
        int i;
        for (i = 0; i < Materials.values().length; ++i) {
            tStack = new ItemStack((Item)this, 1, i);
            Materials material = Materials.values()[i];
            if (material.getMolten(1L) == null && orePrefixes == OrePrefixes.capsuleMolten || material.getFluid(1L) == null && material.getGas(1L) == null && (orePrefixes == OrePrefixes.capsule || orePrefixes == OrePrefixes.bottle)) continue;
            if (OreDictionary.doesOreNameExist((String)(this.orePrefixes.name() + material.mDefaultLocalName.replace(" ", "")))) {
                this.hiddenThings.add(i);
                continue;
            }
            GTOreDictUnificator.registerOre(this.orePrefixes.name() + material.mDefaultLocalName.replace(" ", ""), tStack);
        }
        if (noSubIDMaterials != null) {
            this.hasList = true;
            for (i = 0; i < noSubIDMaterials.size(); ++i) {
                tStack = new ItemStack((Item)this, 1, i + 1001);
                Materials w = noSubIDMaterials.get(i);
                if (w.getMolten(1L) == null && orePrefixes == OrePrefixes.capsuleMolten || w.getFluid(1L) == null && w.getGas(1L) == null && (orePrefixes == OrePrefixes.capsule || orePrefixes == OrePrefixes.bottle)) continue;
                if (OreDictionary.doesOreNameExist((String)(this.orePrefixes.name() + w.mDefaultLocalName.replace(" ", "")))) {
                    this.hiddenThings.add(i);
                    continue;
                }
                GTOreDictUnificator.registerOre(this.orePrefixes.name() + w.mDefaultLocalName.replace(" ", ""), tStack);
            }
        }
    }

    private Materials getMaterial(ItemStack is) {
        if (is == null || is.func_77973_b() != this) {
            return null;
        }
        int meta = is.func_77960_j();
        return this.getMaterialFromMeta(meta);
    }

    @Override
    public String func_77653_i(ItemStack aStack) {
        Materials material = this.getMaterial(aStack);
        if (material == null) {
            material = Materials._NULL;
        }
        return material.getLocalizedNameForItem(this.itemTypeLocalizedName);
    }

    @Override
    protected void addAdditionalToolTips(List<String> aList, ItemStack aStack, EntityPlayer aPlayer) {
        String tooltip;
        Materials material = this.getMaterial(aStack);
        if (material != null && (tooltip = material.getToolTip()) != null && !tooltip.isEmpty()) {
            aList.add(tooltip);
        }
    }

    @Override
    public IIconContainer getIconContainer(int aMetaData) {
        if (this.orePrefixes.mTextureIndex == -1) {
            return this.getIconContainerBartWorks(aMetaData);
        }
        Materials material = this.getMaterialFromMeta(aMetaData);
        if (material != null) {
            return material.mIconSet.mTextures[this.orePrefixes.mTextureIndex];
        }
        return null;
    }

    @Override
    protected IIconContainer getIconContainerBartWorks(int aMetaData) {
        if (SideReference.Side.Server || PrefixTextureLinker.texMap == null) {
            return null;
        }
        HashMap<TextureSet, Textures.ItemIcons.CustomIcon> iconLink = PrefixTextureLinker.texMap.get((Object)this.orePrefixes);
        if (iconLink == null) {
            return null;
        }
        Materials material = this.getMaterialFromMeta(aMetaData);
        if (material == null || material.mIconSet == null) {
            return null;
        }
        return iconLink.getOrDefault(material.mIconSet, iconLink.get(TextureSet.SET_DULL));
    }

    @Override
    public IIcon func_77617_a(int aMetaData) {
        return this.getIcon(aMetaData, 0);
    }

    @Override
    public GeneratedMaterialRenderer getMaterialRenderer(int aMetaData) {
        return this.getMaterialFromMeta((int)aMetaData).renderer;
    }

    public Materials getMaterialFromMeta(int aMetaData) {
        if (aMetaData > 1000 && this.hasList) {
            return GTMetaItemEnhancer.NoMetaValue.get(aMetaData - 1001);
        }
        if (aMetaData < 0 || aMetaData >= Materials.values().length) {
            return null;
        }
        return Materials.values()[aMetaData];
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(Item var1, CreativeTabs aCreativeTab, List<ItemStack> aList) {
        Materials w;
        int i;
        for (i = 0; i < Materials.values().length; ++i) {
            w = Materials.values()[i];
            if (w == null || (w.mTypes & Werkstoff.GenerationFeatures.getPrefixDataRaw(this.orePrefixes)) == 0 && Werkstoff.GenerationFeatures.getPrefixDataRaw(this.orePrefixes) != 0 || w.getMolten(1L) == null && this.orePrefixes == OrePrefixes.capsuleMolten || w.getFluid(1L) == null && w.getGas(1L) == null && (this.orePrefixes == OrePrefixes.capsule || this.orePrefixes == OrePrefixes.bottle) || this.hiddenThings.contains(i)) continue;
            aList.add(new ItemStack((Item)this, 1, i));
        }
        if (this.hasList) {
            for (i = 0; i < GTMetaItemEnhancer.NoMetaValue.size(); ++i) {
                w = GTMetaItemEnhancer.NoMetaValue.get(i);
                if (w == null || (w.mTypes & Werkstoff.GenerationFeatures.getPrefixDataRaw(this.orePrefixes)) == 0 && Werkstoff.GenerationFeatures.getPrefixDataRaw(this.orePrefixes) != 0 || w.getMolten(1L) == null && this.orePrefixes == OrePrefixes.capsuleMolten || w.getFluid(1L) == null && w.getGas(1L) == null && (this.orePrefixes == OrePrefixes.capsule || this.orePrefixes == OrePrefixes.bottle) || this.hiddenThings.contains(i)) continue;
                aList.add(new ItemStack((Item)this, 1, i + 1001));
            }
        }
    }

    @Override
    public short[] getColorForGUI(ItemStack aStack) {
        return this.getMaterial((ItemStack)aStack).mRGBa;
    }

    @Override
    public String getNameForGUI(ItemStack aStack) {
        return this.getMaterial((ItemStack)aStack).mDefaultLocalName;
    }

    @Override
    public void func_77663_a(ItemStack aStack, World aWorld, Entity aPlayer, int aTimer, boolean aIsInHand) {
    }

    @Override
    public short[] getRGBa(ItemStack aStack) {
        return this.getMaterial((ItemStack)aStack).mRGBa;
    }

    @Override
    public boolean onEntityItemUpdate(EntityItem aItemEntity) {
        return false;
    }
}

