/*
 * Decompiled with CFR 0.152.
 */
package bartworks.common.tileentities.tiered;

import bartworks.API.modularUI.BWUITextures;
import bartworks.API.recipe.BartWorksRecipeMaps;
import bartworks.util.BWColorUtil;
import bartworks.util.BWTooltipReference;
import bartworks.util.MathUtils;
import com.gtnewhorizons.modularui.api.ModularUITextures;
import com.gtnewhorizons.modularui.api.drawable.IDrawable;
import com.gtnewhorizons.modularui.api.drawable.ItemDrawable;
import com.gtnewhorizons.modularui.api.drawable.UITexture;
import com.gtnewhorizons.modularui.api.drawable.shapes.Rectangle;
import com.gtnewhorizons.modularui.api.math.Alignment;
import com.gtnewhorizons.modularui.api.math.Color;
import com.gtnewhorizons.modularui.api.math.Pos2d;
import com.gtnewhorizons.modularui.api.math.Size;
import com.gtnewhorizons.modularui.api.screen.ModularWindow;
import com.gtnewhorizons.modularui.api.screen.UIBuildContext;
import com.gtnewhorizons.modularui.api.widget.IWidgetBuilder;
import com.gtnewhorizons.modularui.api.widget.Widget;
import com.gtnewhorizons.modularui.common.widget.ButtonWidget;
import com.gtnewhorizons.modularui.common.widget.DrawableWidget;
import com.gtnewhorizons.modularui.common.widget.FakeSyncWidget;
import com.gtnewhorizons.modularui.common.widget.ProgressBar;
import com.gtnewhorizons.modularui.common.widget.TextWidget;
import com.gtnewhorizons.modularui.common.widget.textfield.NumericWidget;
import gregtech.api.enums.GTValues;
import gregtech.api.enums.Materials;
import gregtech.api.enums.Textures;
import gregtech.api.gui.modularui.GTUIInfos;
import gregtech.api.gui.modularui.GTUITextures;
import gregtech.api.gui.modularui.GUITextureSet;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.modularui.IAddGregtechLogo;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.interfaces.tileentity.RecipeMapWorkable;
import gregtech.api.metatileentity.BaseMetaTileEntity;
import gregtech.api.metatileentity.implementations.MTEHatch;
import gregtech.api.objects.ItemData;
import gregtech.api.recipe.RecipeMap;
import gregtech.api.render.TextureFactory;
import gregtech.api.util.GTOreDictUnificator;
import gregtech.api.util.GTRecipe;
import gregtech.api.util.GTUtility;
import gregtech.common.items.IDMetaTool01;
import gregtech.common.items.MetaGeneratedTool01;
import java.util.Collections;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.StatCollector;
import net.minecraftforge.common.util.ForgeDirection;

public class GT_MetaTileEntity_RadioHatch
extends MTEHatch
implements RecipeMapWorkable,
IAddGregtechLogo {
    private final int cap;
    public int sievert;
    private long timer = 1L;
    private long decayTime = 1L;
    private short[] colorForGUI = new short[]{2, 2, 2};
    private byte mass;
    private String material;
    private byte coverage;
    private ItemStack lastUsedItem = null;
    private boolean lastFail = false;
    private GTRecipe lastRecipe = null;
    private static final int RADIATION_SHUTTER_WINDOW_ID = 999;

    public GT_MetaTileEntity_RadioHatch(int aID, String aName, String aNameRegional, int aTier) {
        super(aID, aName, aNameRegional, aTier, 1, new String[]{StatCollector.func_74838_a((String)"tooltip.tile.radhatch.0.name"), StatCollector.func_74838_a((String)"tooltip.tile.tiereddsc.3.name") + " " + (aTier - 2) + " " + (aTier - 2 >= 2 ? StatCollector.func_74838_a((String)"tooltip.bw.kg.1.name") : StatCollector.func_74838_a((String)"tooltip.bw.kg.0.name")), StatCollector.func_74838_a((String)"tooltip.tile.radhatch.1.name"), BWTooltipReference.ADDED_BY_BARTIMAEUSNEK_VIA_BARTWORKS.get()}, new ITexture[0]);
        this.cap = aTier - 2;
    }

    public GT_MetaTileEntity_RadioHatch(String aName, int aTier, String[] aDescription, ITexture[][][] aTextures) {
        super(aName, aTier, 1, aDescription, aTextures);
        this.cap = aTier - 2;
    }

    public int getSievert() {
        return this.sievert - MathUtils.ceilInt((float)this.sievert / 100.0f * (float)this.coverage);
    }

    public short[] getColorForGUI() {
        if (this.colorForGUI != null) {
            return this.colorForGUI;
        }
        this.colorForGUI = new short[]{250, 250, 255};
        return this.colorForGUI;
    }

    public byte getMass() {
        return this.mass;
    }

    public byte getCoverage() {
        return this.coverage;
    }

    public void setCoverage(short coverage) {
        int nu = coverage > 100 ? 100 : (coverage < 0 ? 0 : (int)((byte)coverage));
        this.coverage = (byte)nu;
    }

    @Override
    public ITexture[] getTexturesActive(ITexture aBaseTexture) {
        return new ITexture[]{aBaseTexture, TextureFactory.of(Textures.BlockIcons.OVERLAY_PIPE_IN)};
    }

    @Override
    public ITexture[] getTexturesInactive(ITexture aBaseTexture) {
        return new ITexture[]{aBaseTexture, TextureFactory.of(Textures.BlockIcons.OVERLAY_PIPE_IN)};
    }

    @Override
    public IMetaTileEntity newMetaEntity(IGregTechTileEntity iGregTechTileEntity) {
        return new GT_MetaTileEntity_RadioHatch(this.mName, this.mTier, this.mDescriptionArray, this.mTextures);
    }

    @Override
    public boolean onRightclick(IGregTechTileEntity aBaseMetaTileEntity, EntityPlayer aPlayer) {
        GTUIInfos.openGTTileEntityUI(aBaseMetaTileEntity, aPlayer);
        return true;
    }

    public void updateSlots() {
        if (this.mInventory[0] != null && this.mInventory[0].field_77994_a <= 0) {
            this.mInventory[0] = null;
        }
    }

    @Override
    public void onPostTick(IGregTechTileEntity aBaseMetaTileEntity, long aTimer) {
        BaseMetaTileEntity myMetaTileEntity = (BaseMetaTileEntity)this.getBaseMetaTileEntity();
        if (myMetaTileEntity.isServerSide()) {
            if (this.mass > 0) {
                ++this.timer;
            }
            if (this.mass > 0 && (this.decayTime == 0L || this.decayTime > 0L && this.timer % this.decayTime == 0L)) {
                this.mass = (byte)(this.mass - 1);
                if (this.mass == 0) {
                    this.material = StatCollector.func_74838_a((String)"tooltip.bw.empty.name");
                    this.sievert = 0;
                }
                this.timer = 1L;
            }
            if (myMetaTileEntity.mTickTimer > myMetaTileEntity.mLastSoundTick + (long)GTValues.ticksBetweenSounds && this.sievert > 0) {
                this.sendLoopStart((byte)1);
                myMetaTileEntity.mLastSoundTick = myMetaTileEntity.mTickTimer;
            }
            if (this.mass == 0) {
                ItemStack lStack = this.mInventory[0];
                if (lStack == null) {
                    this.colorForGUI = new short[]{55, 55, 55};
                    return;
                }
                ItemData itemData = GTOreDictUnificator.getAssociation(lStack);
                if (itemData != null) {
                    Materials mat = itemData.mMaterial.mMaterial;
                    this.colorForGUI = new short[]{mat.getRGBA()[0], mat.getRGBA()[1], mat.getRGBA()[2]};
                } else {
                    this.colorForGUI = new short[]{55, 55, 55};
                }
                if (this.lastFail && GTUtility.areStacksEqual(this.lastUsedItem, lStack, true)) {
                    return;
                }
                if (!this.lastFail && this.lastUsedItem != null && this.lastRecipe != null) {
                    if (GTUtility.areStacksEqual(this.lastUsedItem, lStack, true)) {
                        this.mass = (byte)this.lastRecipe.mDuration;
                        this.decayTime = this.lastRecipe.mSpecialValue;
                        this.sievert = this.lastRecipe.mEUt;
                        this.material = this.lastUsedItem.func_82833_r();
                        --lStack.field_77994_a;
                        this.updateSlots();
                    } else {
                        this.lastRecipe = null;
                    }
                }
                if (this.lastRecipe == null || this.lastFail) {
                    this.lastRecipe = BartWorksRecipeMaps.radioHatchRecipes.findRecipeQuery().items(this.mInventory[0]).find();
                    if (this.lastRecipe == null) {
                        this.lastFail = true;
                        this.lastUsedItem = this.mInventory[0] == null ? null : this.mInventory[0].func_77946_l();
                    } else {
                        if (this.lastRecipe.mDuration > this.cap) {
                            this.lastFail = true;
                            this.lastUsedItem = this.mInventory[0].func_77946_l();
                            return;
                        }
                        this.lastFail = false;
                        this.lastUsedItem = this.mInventory[0].func_77946_l();
                        this.mass = (byte)this.lastRecipe.mDuration;
                        this.decayTime = this.lastRecipe.mSpecialValue;
                        this.sievert = this.lastRecipe.mEUt;
                        this.material = lStack.func_82833_r();
                        --lStack.field_77994_a;
                        this.updateSlots();
                    }
                }
            }
        }
    }

    @Override
    public boolean isGivingInformation() {
        return true;
    }

    @Override
    public String[] getInfoData() {
        if (this.sievert != 0) {
            return new String[]{StatCollector.func_74838_a((String)"tooltip.tile.radhatch.2.name") + " " + StatCollector.func_74838_a((String)this.material), StatCollector.func_74838_a((String)"tooltip.tile.radhatch.3.name") + " " + this.sievert, StatCollector.func_74838_a((String)"tooltip.tile.radhatch.4.name") + " " + this.mass, StatCollector.func_74838_a((String)"tooltip.tile.radhatch.5.name") + " " + (this.decayTime - this.timer % (this.decayTime * 60L)) + StatCollector.func_74838_a((String)"tooltip.tile.radhatch.6.name") + "/" + (this.decayTime - this.timer % this.decayTime) / 20L + StatCollector.func_74838_a((String)"tooltip.tile.radhatch.7.name") + "/" + (this.decayTime - this.timer % this.decayTime) / 20L / 60L + StatCollector.func_74838_a((String)"tooltip.tile.radhatch.8.name") + "/" + (this.decayTime - this.timer % this.decayTime) / 20L / 60L / 60L + StatCollector.func_74838_a((String)"tooltip.tile.radhatch.9.name")};
        }
        return new String[]{StatCollector.func_74838_a((String)"tooltip.tile.radhatch.2.name") + " " + StatCollector.func_74838_a((String)"tooltip.bw.empty.name"), StatCollector.func_74838_a((String)"tooltip.tile.radhatch.3.name") + " 0", StatCollector.func_74838_a((String)"tooltip.tile.radhatch.4.name") + " 0"};
    }

    @Override
    public boolean isSimpleMachine() {
        return true;
    }

    @Override
    public boolean isFacingValid(ForgeDirection facing) {
        return true;
    }

    @Override
    public boolean isAccessAllowed(EntityPlayer aPlayer) {
        return true;
    }

    @Override
    public boolean isValidSlot(int aIndex) {
        return true;
    }

    @Override
    public boolean allowPullStack(IGregTechTileEntity aBaseMetaTileEntity, int aIndex, ForgeDirection side, ItemStack aStack) {
        return false;
    }

    @Override
    public boolean allowPutStack(IGregTechTileEntity aBaseMetaTileEntity, int aIndex, ForgeDirection side, ItemStack aStack) {
        return side == this.getBaseMetaTileEntity().getFrontFacing() && BartWorksRecipeMaps.radioHatchRecipes.containsInput(aStack);
    }

    @Override
    public void saveNBTData(NBTTagCompound aNBT) {
        aNBT.func_74774_a("mMass", this.mass);
        aNBT.func_74774_a("mSv", (byte)(this.sievert - 100));
        aNBT.func_74774_a("mCoverage", this.coverage);
        aNBT.func_74768_a("mTextColor", BWColorUtil.getColorFromRGBArray(this.getColorForGUI()));
        if (this.material != null && !this.material.isEmpty()) {
            aNBT.func_74778_a("mMaterial", this.material);
        }
        aNBT.func_74772_a("timer", this.timer);
        aNBT.func_74772_a("decay", this.decayTime);
        super.saveNBTData(aNBT);
    }

    @Override
    public void loadNBTData(NBTTagCompound aNBT) {
        this.timer = aNBT.func_74763_f("timer");
        this.mass = aNBT.func_74771_c("mMass");
        this.sievert = aNBT.func_74771_c("mSv") + 100;
        this.coverage = aNBT.func_74771_c("mCoverage");
        this.colorForGUI = BWColorUtil.splitColorToRBGArray(aNBT.func_74762_e("mTextColor"));
        this.material = aNBT.func_74779_i("mMaterial");
        this.decayTime = aNBT.func_74763_f("decay");
        super.loadNBTData(aNBT);
    }

    @Override
    public void startSoundLoop(byte aIndex, double aX, double aY, double aZ) {
        super.startSoundLoop(aIndex, aX, aY, aZ);
        ResourceLocation rl = new ResourceLocation("bartworks", "hatch.RadOn");
        if (aIndex == 1) {
            GTUtility.doSoundAtClient(rl, 10, 1.0f, aX, aY, aZ);
        }
    }

    @Override
    public RecipeMap<?> getRecipeMap() {
        return BartWorksRecipeMaps.radioHatchRecipes;
    }

    @Override
    public void addUIWidgets(ModularWindow.Builder builder, UIBuildContext buildContext) {
        buildContext.addSyncedWindow(999, this::createShutterWindow);
        this.getBaseMetaTileEntity().add1by1Slot(builder, new IDrawable[0]);
        ((ModularWindow.Builder)((ModularWindow.Builder)((ModularWindow.Builder)((ModularWindow.Builder)((ModularWindow.Builder)((ModularWindow.Builder)((ModularWindow.Builder)((ModularWindow.Builder)((ModularWindow.Builder)((ModularWindow.Builder)((ModularWindow.Builder)((ModularWindow.Builder)((ModularWindow.Builder)builder.widget(new DrawableWidget().setBackground(new IDrawable[]{BWUITextures.PICTURE_SIEVERT_CONTAINER}).setPos(61, 9).setSize(56, 24))).widget(new ProgressBar().setProgress(() -> Float.valueOf((float)this.getSievert() / 148.0f)).setDirection(ProgressBar.Direction.RIGHT).setTexture(BWUITextures.PROGRESSBAR_SIEVERT, 24).setPos(65, 13).setSize(48, 16))).widget(new DrawableWidget().setBackground(new IDrawable[]{BWUITextures.PICTURE_DECAY_TIME_INSIDE}).setPos(124, 18).setSize(16, 48))).widget(new DrawableWidget(){

            public void draw(float partialTicks) {
                if (GT_MetaTileEntity_RadioHatch.this.decayTime > 0L) {
                    int height = MathUtils.ceilInt(48.0f * ((float)(GT_MetaTileEntity_RadioHatch.this.decayTime - GT_MetaTileEntity_RadioHatch.this.timer % GT_MetaTileEntity_RadioHatch.this.decayTime) / (float)GT_MetaTileEntity_RadioHatch.this.decayTime));
                    new Rectangle().setColor(Color.argb((int)GT_MetaTileEntity_RadioHatch.this.colorForGUI[0], (int)GT_MetaTileEntity_RadioHatch.this.colorForGUI[1], (int)GT_MetaTileEntity_RadioHatch.this.colorForGUI[2], (int)255)).draw(new Pos2d(0, 48 - height), new Size(16, height), partialTicks);
                }
            }
        }.dynamicTooltip(() -> Collections.singletonList(StatCollector.func_74837_a((String)"tooltip.tile.radhatch.10.name", (Object[])new Object[]{this.timer <= 1L ? 0L : (this.decayTime - this.timer) / 20L, this.timer <= 1L ? 0L : this.decayTime / 20L}))).setPos(124, 18).setSize(16, 48).attachSyncer((FakeSyncWidget)new FakeSyncWidget.LongSyncer(() -> this.decayTime, val -> {
            this.decayTime = val;
        }), (IWidgetBuilder)builder, (widget, val) -> widget.notifyTooltipChange()).attachSyncer((FakeSyncWidget)new FakeSyncWidget.LongSyncer(() -> this.timer, val -> {
            this.timer = val;
        }), (IWidgetBuilder)builder, (widget, val) -> widget.notifyTooltipChange()))).widget((Widget)new FakeSyncWidget.ShortSyncer(() -> this.colorForGUI[0], val -> {
            this.colorForGUI[0] = val;
        }))).widget((Widget)new FakeSyncWidget.ShortSyncer(() -> this.colorForGUI[1], val -> {
            this.colorForGUI[1] = val;
        }))).widget((Widget)new FakeSyncWidget.ShortSyncer(() -> this.colorForGUI[2], val -> {
            this.colorForGUI[2] = val;
        }))).widget(new DrawableWidget().setBackground(new IDrawable[]{BWUITextures.PICTURE_DECAY_TIME_CONTAINER}).setPos(120, 14).setSize(24, 56))).widget(new TextWidget().setStringSupplier(() -> StatCollector.func_74837_a((String)"BW.NEI.display.radhatch.1", (Object[])new Object[]{this.mass})).setTextAlignment(Alignment.Center).setPos(65, 62))).widget((Widget)new FakeSyncWidget.ByteSyncer(() -> this.mass, val -> {
            this.mass = val;
        }))).widget(new TextWidget().setStringSupplier(() -> StatCollector.func_74837_a((String)"BW.NEI.display.radhatch.0", (Object[])new Object[]{this.getSievert()})).setTextAlignment(Alignment.Center).setPos(60, 72))).widget((Widget)new FakeSyncWidget.IntegerSyncer(() -> this.sievert, val -> {
            this.sievert = val;
        }))).widget(new ButtonWidget().setOnClick((clickData, widget) -> {
            if (!widget.isClient()) {
                widget.getContext().openSyncedWindow(999);
            }
        }).addTooltip("Radiation Shutter").setBackground(new IDrawable[]{GTUITextures.BUTTON_STANDARD}).setPos(153, 5).setSize(18, 18))).widget(new ItemDrawable(MetaGeneratedTool01.INSTANCE.getToolWithStats(IDMetaTool01.SCREWDRIVER.ID, 1, null, null, null)).asWidget().setPos(154, 6));
    }

    private ModularWindow createShutterWindow(EntityPlayer player) {
        ModularWindow.Builder builder = ModularWindow.builder((int)176, (int)107);
        builder.setBackground(new IDrawable[]{ModularUITextures.VANILLA_BACKGROUND});
        builder.setGuiTint(this.getGUIColorization());
        ((ModularWindow.Builder)((ModularWindow.Builder)((ModularWindow.Builder)((ModularWindow.Builder)builder.widget(new TextWidget("Radiation Shutter Control").setDefaultColor(((Integer)this.COLOR_TITLE.get()).intValue()).setPos(10, 9))).widget(new DrawableWidget().setDrawable((IDrawable)BWUITextures.PICTURE_RADIATION_SHUTTER_FRAME).setPos(14, 27).setSize(55, 54))).widget(new DrawableWidget().setDrawable(() -> this.coverage < 100 ? BWUITextures.PICTURE_RADIATION_SHUTTER_INSIDE : null).setPos(16, 29).setSize(51, 50).attachSyncer((FakeSyncWidget)new FakeSyncWidget.ByteSyncer(this::getCoverage, this::setCoverage), (IWidgetBuilder)builder, (widget, val) -> widget.setPos(16, 29 + this.coverage / 2).setSize(51, 50 - this.coverage / 2)))).widget(new NumericWidget().setSetter(val -> {
            this.coverage = (byte)val;
        }).setGetter(() -> this.coverage).setBounds(0.0, 100.0).setScrollValues(1.0, 5.0, 50.0).setTextColor(Color.WHITE.dark(1)).setTextAlignment(Alignment.CenterLeft).setBackground(new IDrawable[]{GTUITextures.BACKGROUND_TEXT_FIELD.withOffset(-1.0f, -1.0f, 2.0f, 2.0f)}).setPos(86, 27).setSize(30, 12))).widget(ButtonWidget.closeWindowButton((boolean)true).setPos(161, 3));
        return builder.build();
    }

    @Override
    public void addGregTechLogo(ModularWindow.Builder builder) {
        builder.widget(new DrawableWidget().setDrawable((IDrawable)BWUITextures.PICTURE_BW_LOGO_47X21).setSize(47, 21).setPos(10, 53));
    }

    @Override
    public GUITextureSet getGUITextureSet() {
        return new GUITextureSet().setMainBackground((UITexture)GTUITextures.BACKGROUND_SINGLEBLOCK_DEFAULT).setGregTechLogo(GTUITextures.PICTURE_GT_LOGO_17x17_TRANSPARENT);
    }
}

