/*
 * Decompiled with CFR 0.152.
 */
package com.kuba6000.mobsinfo.api.helper;

import alexiil.mods.load.ProgressDisplayer;
import com.kuba6000.mobsinfo.api.LoaderReference;
import com.kuba6000.mobsinfo.api.utils.ModUtils;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.ProgressManager;
import java.io.IOException;

public class ProgressBarWrapper {
    ProgressManager.ProgressBar internalFMLBar;
    boolean isFMLBar;
    String name;
    int maxSteps;
    int steps = 0;

    public ProgressBarWrapper(String name, int steps) {
        if (!ModUtils.isClientSided) {
            return;
        }
        this.maxSteps = steps;
        this.name = name;
        if (!LoaderReference.BetterLoadingScreen.isLoaded) {
            this.internalFMLBar = ProgressManager.push((String)name, (int)steps);
            this.isFMLBar = true;
            return;
        }
        this.isFMLBar = false;
    }

    public void step(String message) {
        if (!ModUtils.isClientSided) {
            return;
        }
        if (this.isFMLBar) {
            this.internalFMLBar.step(message);
        } else {
            ++this.steps;
            try {
                ProgressDisplayer.displayProgress((String)("MobsInfo: " + this.name + " -> " + message), (float)((float)this.steps / (float)this.maxSteps));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            FMLCommonHandler.instance().processWindowMessages();
        }
    }

    public void end() {
        if (!ModUtils.isClientSided) {
            return;
        }
        if (this.isFMLBar) {
            ProgressManager.pop((ProgressManager.ProgressBar)this.internalFMLBar);
        }
    }
}

