/*
 * Decompiled with CFR 0.152.
 */
package fox.spiteful.avaritia.items.tools;

import fox.spiteful.avaritia.items.ItemMatterCluster;
import fox.spiteful.avaritia.items.ItemStackWrapper;
import fox.spiteful.avaritia.items.LudicrousItems;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class ToolHelper {
    public static Material[] materialsPick = new Material[]{Material.field_151576_e, Material.field_151573_f, Material.field_151588_w, Material.field_151592_s, Material.field_76233_E, Material.field_151574_g};
    public static Material[] materialsShovel = new Material[]{Material.field_151577_b, Material.field_151578_c, Material.field_151595_p, Material.field_151597_y, Material.field_151596_z, Material.field_151571_B};
    public static Material[] materialsAxe = new Material[]{Material.field_151589_v, Material.field_151584_j, Material.field_151585_k, Material.field_151575_d, Material.field_151582_l};
    public static Set<EntityPlayer> hammering = new HashSet<EntityPlayer>();
    public static Map<EntityPlayer, List<ItemStack>> hammerdrops = new WeakHashMap<EntityPlayer, List<ItemStack>>();

    public static void removeBlocksInIteration(EntityPlayer player, ItemStack stack, World world, int x, int y, int z, int xs, int ys, int zs, int xe, int ye, int ze, Block block, Material[] materialsListing, boolean silk, int fortune, boolean dispose) {
        float blockHardness;
        float f = blockHardness = block == null ? 1.0f : block.func_149712_f(world, x, y, z);
        if (!hammerdrops.containsKey(player) || hammerdrops.get(player) == null) {
            hammerdrops.put(player, new ArrayList());
        }
        if (!hammering.contains(player)) {
            hammering.add(player);
        }
        for (int x1 = xs; x1 < xe; ++x1) {
            for (int y1 = ys; y1 < ye; ++y1) {
                for (int z1 = zs; z1 < ze; ++z1) {
                    ToolHelper.removeBlockWithDrops(player, stack, world, x1 + x, y1 + y, z1 + z, block, materialsListing, silk, fortune, blockHardness, dispose);
                }
            }
        }
        int meta = world.func_72805_g(x, y, z);
        if (!world.field_72995_K) {
            world.func_72926_e(2001, x, y, z, Block.func_149682_b((Block)block) + (meta << 12));
        }
        if (hammering.contains(player)) {
            hammering.remove(player);
        }
        if (!world.field_72995_K) {
            List<ItemStack> clusters = ItemMatterCluster.makeClusters(hammerdrops.get(player));
            for (ItemStack cluster : clusters) {
                EntityItem ent = new EntityItem(world, (double)x, (double)y, (double)z, cluster);
                world.func_72838_d((Entity)ent);
            }
        }
        hammerdrops.put(player, null);
    }

    public static boolean isRightMaterial(Material material, Material[] materialsListing) {
        for (Material mat : materialsListing) {
            if (material != mat) continue;
            return true;
        }
        return false;
    }

    public static void removeBlockWithDrops(EntityPlayer player, ItemStack stack, World world, int x, int y, int z, Block block, Material[] materialsListing, boolean silk, int fortune, float blockHardness, boolean dispose) {
        if (!world.func_72899_e(x, y, z)) {
            return;
        }
        Block blk = world.func_147439_a(x, y, z);
        int meta = world.func_72805_g(x, y, z);
        if (block != null && blk != block) {
            return;
        }
        Material mat = world.func_147439_a(x, y, z).func_149688_o();
        if (!world.field_72995_K && blk != null && !blk.isAir((IBlockAccess)world, x, y, z)) {
            if (blk == Blocks.field_150349_c && stack.func_77973_b() == LudicrousItems.infinity_axe) {
                world.func_147449_b(x, y, z, Blocks.field_150346_d);
            }
            if (!blk.canHarvestBlock(player, meta) || !ToolHelper.isRightMaterial(mat, materialsListing)) {
                return;
            }
            if (!player.field_71075_bZ.field_75098_d) {
                int localMeta = world.func_72805_g(x, y, z);
                blk.func_149681_a(world, x, y, z, localMeta, player);
                if (blk.removedByPlayer(world, player, x, y, z, true)) {
                    blk.func_149664_b(world, x, y, z, localMeta);
                    if (!dispose) {
                        if (blk.func_149737_a(player, world, x, y, z) < 0.0f && blk.func_149745_a(world.field_73012_v) == 0) {
                            ItemStack drop = blk.getPickBlock(ToolHelper.raytraceFromEntity(world, (Entity)player, true, 10.0), world, x, y, z, player);
                            if (drop == null) {
                                drop = new ItemStack(blk, 1, meta);
                            }
                            ToolHelper.dropItem(drop, world, x, y, z);
                        }
                        blk.func_149636_a(world, player, x, y, z, localMeta);
                    }
                }
            } else {
                world.func_147468_f(x, y, z);
            }
        }
    }

    public static MovingObjectPosition raytraceFromEntity(World world, Entity player, boolean wut, double range) {
        float f = 1.0f;
        float f1 = player.field_70127_C + (player.field_70125_A - player.field_70127_C) * f;
        float f2 = player.field_70126_B + (player.field_70177_z - player.field_70126_B) * f;
        double d0 = player.field_70169_q + (player.field_70165_t - player.field_70169_q) * (double)f;
        double d1 = player.field_70167_r + (player.field_70163_u - player.field_70167_r) * (double)f;
        if (!world.field_72995_K && player instanceof EntityPlayer) {
            d1 += 1.62;
        }
        double d2 = player.field_70166_s + (player.field_70161_v - player.field_70166_s) * (double)f;
        Vec3 vec3 = Vec3.func_72443_a((double)d0, (double)d1, (double)d2);
        float f3 = MathHelper.func_76134_b((float)(-f2 * ((float)Math.PI / 180) - (float)Math.PI));
        float f4 = MathHelper.func_76126_a((float)(-f2 * ((float)Math.PI / 180) - (float)Math.PI));
        float f5 = -MathHelper.func_76134_b((float)(-f1 * ((float)Math.PI / 180)));
        float f6 = MathHelper.func_76126_a((float)(-f1 * ((float)Math.PI / 180)));
        float f7 = f4 * f5;
        float f8 = f3 * f5;
        double d3 = range;
        Vec3 vec31 = vec3.func_72441_c((double)f7 * d3, (double)f6 * d3, (double)f8 * d3);
        return world.func_72901_a(vec3, vec31, wut);
    }

    public static void dropItem(ItemStack drop, World world, int x, int y, int z) {
        float f = 0.7f;
        double d0 = (double)(world.field_73012_v.nextFloat() * f) + (double)(1.0f - f) * 0.5;
        double d1 = (double)(world.field_73012_v.nextFloat() * f) + (double)(1.0f - f) * 0.5;
        double d2 = (double)(world.field_73012_v.nextFloat() * f) + (double)(1.0f - f) * 0.5;
        EntityItem entityitem = new EntityItem(world, (double)x + d0, (double)y + d1, (double)z + d2, drop);
        entityitem.field_145804_b = 10;
        world.func_72838_d((Entity)entityitem);
    }

    public static List<ItemStack> collateDropList(List<ItemStack> input) {
        return ToolHelper.collateMatterClusterContents(ToolHelper.collateMatterCluster(input));
    }

    public static List<ItemStack> collateMatterClusterContents(Map<ItemStackWrapper, Integer> input) {
        ArrayList<ItemStack> collated = new ArrayList<ItemStack>();
        if (input == null) {
            return collated;
        }
        for (Map.Entry<ItemStackWrapper, Integer> e : input.entrySet()) {
            int count = e.getValue();
            ItemStackWrapper wrap = e.getKey();
            int size = wrap.stack.func_77976_d();
            int fullstacks = (int)Math.floor(count / size);
            for (int i = 0; i < fullstacks; ++i) {
                count -= size;
                ItemStack stack = wrap.stack.func_77946_l();
                stack.field_77994_a = size;
                collated.add(stack);
            }
            if (count <= 0) continue;
            ItemStack stack = wrap.stack.func_77946_l();
            stack.field_77994_a = count;
            collated.add(stack);
        }
        return collated;
    }

    public static Map<ItemStackWrapper, Integer> collateMatterCluster(List<ItemStack> input) {
        HashMap<ItemStackWrapper, Integer> counts = new HashMap<ItemStackWrapper, Integer>();
        if (input != null) {
            for (ItemStack stack : input) {
                ItemStackWrapper wrap = new ItemStackWrapper(stack);
                if (!counts.containsKey(wrap)) {
                    counts.put(wrap, 0);
                }
                counts.put(wrap, (Integer)counts.get(wrap) + stack.field_77994_a);
            }
        }
        return counts;
    }
}

