/*
 * Decompiled with CFR 0.152.
 */
package emt.item.focus;

import emt.item.focus.ItemBaseFocus;
import emt.util.EMTConfigHandler;
import ic2.api.item.ElectricItem;
import java.util.Map;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.aspects.AspectList;
import thaumcraft.api.wands.FocusUpgradeType;
import thaumcraft.common.items.wands.ItemWandCasting;

public class ItemWandChargingFocus
extends ItemBaseFocus {
    AspectList visCost = new AspectList().add(Aspect.FIRE, 10).add(Aspect.WATER, 10).add(Aspect.AIR, 10).add(Aspect.EARTH, 10).add(Aspect.ORDER, 10).add(Aspect.ENTROPY, 10);

    public ItemWandChargingFocus() {
        super("chargeWand");
    }

    @Override
    public int getFocusColor(ItemStack stack) {
        return 268432464;
    }

    @Override
    public String getSortingHelper(ItemStack itemstack) {
        return "ELECTRICCHARGING";
    }

    public boolean isVisCostPerTick(ItemStack focusstack) {
        return true;
    }

    @Override
    public AspectList getVisCost(ItemStack stack) {
        AspectList actualCost = new AspectList();
        for (Map.Entry e : this.visCost.aspects.entrySet()) {
            actualCost.add((Aspect)e.getKey(), (int)((double)((Integer)e.getValue()).intValue() * Math.pow(1.1, this.getUpgradeLevel(stack, FocusUpgradeType.potency))));
        }
        return this.visCost;
    }

    public FocusUpgradeType[] getPossibleUpgradesByRank(ItemStack focusstack, int rank) {
        return new FocusUpgradeType[]{FocusUpgradeType.potency, FocusUpgradeType.frugal};
    }

    public boolean canApplyUpgrade(ItemStack focusstack, EntityPlayer player, FocusUpgradeType type, int rank) {
        return true;
    }

    @Override
    public void onUsingFocusTick(ItemStack itemstack, EntityPlayer player, int integer) {
        if (!player.field_70170_p.field_72995_K) {
            ItemWandCasting wandItem = (ItemWandCasting)itemstack.func_77973_b();
            ItemStack armor = player.field_71071_by.field_70460_b[1];
            if (armor != null && ElectricItem.manager.use(armor, (double)(EMTConfigHandler.wandChargeFocusCost / 4), (EntityLivingBase)player) && ElectricItem.manager.use(armor, (double)(EMTConfigHandler.wandChargeFocusCost / 4), (EntityLivingBase)player) && ElectricItem.manager.use(armor, (double)(EMTConfigHandler.wandChargeFocusCost / 4), (EntityLivingBase)player) && ElectricItem.manager.use(armor, (double)(EMTConfigHandler.wandChargeFocusCost / 4), (EntityLivingBase)player)) {
                int amount = (int)(100.0 * Math.pow(1.1, this.getUpgradeLevel(itemstack, FocusUpgradeType.potency)));
                wandItem.addRealVis(itemstack, Aspect.ORDER, amount, true);
                wandItem.addRealVis(itemstack, Aspect.FIRE, amount, true);
                wandItem.addRealVis(itemstack, Aspect.ENTROPY, amount, true);
                wandItem.addRealVis(itemstack, Aspect.WATER, amount, true);
                wandItem.addRealVis(itemstack, Aspect.EARTH, amount, true);
                wandItem.addRealVis(itemstack, Aspect.AIR, amount, true);
            }
        }
    }
}

