/*
 * Decompiled with CFR 0.152.
 */
package journeymap.server.oldservercode.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.File;
import java.util.UUID;
import journeymap.common.Journeymap;
import journeymap.server.oldservercode.config.Configuration;
import journeymap.server.oldservercode.reference.Controller;
import journeymap.server.oldservercode.util.FileManager;

public class ConfigHandler {
    private static final float CONFIG_VERSION = 1.12f;
    private static File configPath;

    public static void init(File configPath) {
        ConfigHandler.configPath = configPath;
    }

    public static Configuration getConfigByWorldName(String worldName) {
        Configuration config = ConfigHandler.loadConfig(worldName = ConfigHandler.parseWorldName(worldName));
        if (config != null) {
            ConfigHandler.validateConfigVersion(config, worldName);
            return config;
        }
        return ConfigHandler.addNewWorldConfig(worldName);
    }

    private static Configuration addNewWorldConfig(String worldName) {
        worldName = ConfigHandler.parseWorldName(worldName);
        Journeymap.getLogger().info("Attempting to create new config file for: " + worldName);
        Configuration config = ConfigHandler.generateDefaultConfig();
        ConfigHandler.saveWorld(config, worldName);
        return config;
    }

    private static Configuration generateDefaultConfig() {
        Configuration config = new Configuration();
        config.setConfigVersion(1.12f);
        config.setWorldID(UUID.randomUUID().toString());
        config.getRadar().setOpRadar(true);
        config.getRadar().setPlayerRadar(true);
        config.getRadar().setWhiteListRadar("");
        config.getCaveMapping().setOpCaveMapping(true);
        config.getCaveMapping().setPlayerCaveMapping(true);
        config.getCaveMapping().setWhiteListCaveMapping("");
        if (Controller.FORGE.equals((Object)Controller.getController())) {
            config.setUsingWorldID(false);
        } else {
            config.setUsingWorldID(true);
        }
        return config;
    }

    private static void validateConfigVersion(Configuration config, String worldName) {
        worldName = ConfigHandler.parseWorldName(worldName);
        float version = config.getConfigVersion();
        if (version != 1.12f) {
            if (version < 1.1f) {
                config.setSaveInWorldFolder(false);
            }
            if (version <= 1.11f && Controller.FORGE.equals((Object)Controller.getController())) {
                config.setUsingWorldID(false);
            }
            if (version <= 1.12f && Controller.FORGE.equals((Object)Controller.getController()) && !config.isSaveInWorldFolder()) {
                config.setUsingWorldID(true);
                config.setWorldID(config.getWorldID());
            }
            if (version < 1.12f) {
                config.setConfigVersion(1.12f);
            }
        } else {
            return;
        }
        ConfigHandler.saveWorld(config, worldName);
    }

    public static boolean saveWorld(Configuration configuration, String worldName) {
        worldName = ConfigHandler.parseWorldName(worldName);
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        String gsonFile = gson.toJson((Object)configuration);
        File config = new File(configPath, String.format("%s.cfg", worldName));
        if (!configPath.exists() || !configPath.isDirectory()) {
            configPath.mkdirs();
        }
        return FileManager.writeFile(config, gsonFile);
    }

    private static Configuration loadConfig(String worldName) {
        Configuration config;
        worldName = ConfigHandler.parseWorldName(worldName);
        File configFile = new File(configPath, String.format("%s.cfg", worldName));
        try {
            Gson gson = new Gson();
            config = (Configuration)gson.fromJson(FileManager.readFile(configFile), Configuration.class);
        }
        catch (NoClassDefFoundError nce) {
            Gson gson = new Gson();
            config = (Configuration)gson.fromJson(FileManager.readFile(configFile), Configuration.class);
        }
        return config;
    }

    private static String parseWorldName(String worldName) {
        String[] name = worldName.split("/");
        return name[name.length - 1];
    }
}

