/*
 * Decompiled with CFR 0.152.
 */
package com.jamesswafford.chess4j.search;

import com.jamesswafford.chess4j.board.Board;
import com.jamesswafford.chess4j.board.Move;
import com.jamesswafford.chess4j.pieces.Bishop;
import com.jamesswafford.chess4j.pieces.King;
import com.jamesswafford.chess4j.pieces.Knight;
import com.jamesswafford.chess4j.pieces.Pawn;
import com.jamesswafford.chess4j.pieces.Queen;
import com.jamesswafford.chess4j.pieces.Rook;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;

public class MVVLVA
implements Comparator<Move> {
    private static Map<Class<?>, Integer> pieceMap = new HashMap();
    private Board board;

    public MVVLVA(Board board) {
        this.board = board;
    }

    public static int score(Board b, Move m) {
        int score = 0;
        if (m.promotion() != null) {
            score = MVVLVA.scorePromotion(m);
        }
        if (m.captured() != null) {
            score += MVVLVA.scoreCapture(b, m);
        }
        return score;
    }

    private static int scorePromotion(Move m) {
        int promoVal = pieceMap.get(m.promotion().getClass());
        return 10000 + promoVal;
    }

    private static int scoreCapture(Board b, Move m) {
        int capturedVal = pieceMap.get(m.captured().getClass());
        int moverVal = pieceMap.get(b.getPiece(m.from()).getClass());
        return 1000 + capturedVal * 10 - moverVal;
    }

    @Override
    public int compare(Move m1, Move m2) {
        int score1 = MVVLVA.score(this.board, m1);
        int score2 = MVVLVA.score(this.board, m2);
        int retVal = 0;
        if (score1 > score2) {
            retVal = -1;
        } else if (score1 < score2) {
            retVal = 1;
        }
        return retVal;
    }

    static {
        pieceMap.put(King.class, 6);
        pieceMap.put(Queen.class, 5);
        pieceMap.put(Rook.class, 4);
        pieceMap.put(Bishop.class, 3);
        pieceMap.put(Knight.class, 2);
        pieceMap.put(Pawn.class, 1);
    }
}

