/*
 * Decompiled with CFR 0.152.
 */
package com.jamesswafford.chess4j.io;

import com.jamesswafford.chess4j.board.Move;
import eu.usrv.yamcore.auxiliary.LogHelper;
import java.util.List;

public class PrintLine {
    private static LogHelper mLog = new LogHelper("LootGames - ChessEngine");

    public static void printLine(List<Move> moves) {
        PrintLine.printLine(moves, false);
    }

    public static void printLine(List<Move> moves, boolean debug) {
        String ms = PrintLine.getMoveString(moves);
        if (debug) {
            mLog.debug((Object)(ms + "\n"));
        } else {
            mLog.info((Object)(ms + "\n"));
        }
    }

    public static void printLine(List<Move> moves, int depth, int score, long startTime, long nodes) {
        long timeInCentis = (System.currentTimeMillis() - startTime) / 10L;
        String line = PrintLine.getMoveString(moves);
        String output = String.format("%2d %5d %5d %7d %s", depth, score, timeInCentis, nodes, line);
        mLog.info((Object)output);
    }

    public static String getMoveString(List<Move> moves) {
        String s = "";
        for (Move m : moves) {
            s = s + m.toString() + " ";
        }
        return s;
    }
}

