/*
 * Decompiled with CFR 0.152.
 */
package com.jamesswafford.chess4j.book;

import com.jamesswafford.chess4j.board.Move;

public class BookMove {
    private Move move;
    private int frequency = 1;
    private int wins;
    private int losses;
    private int draws;

    public BookMove(Move move) {
        this(move, 1);
    }

    public BookMove(Move move, int frequency) {
        this(move, frequency, 0, 0, 0);
    }

    public BookMove(Move move, int frequency, int wins, int losses, int draws) {
        this.move = move;
        this.frequency = frequency;
        this.wins = wins;
        this.losses = losses;
        this.draws = draws;
    }

    public int getFrequency() {
        return this.frequency;
    }

    public void setFrequency(int frequency) {
        this.frequency = frequency;
    }

    public Move getMove() {
        return this.move;
    }

    public String toString() {
        return "BookMove [move=" + this.getMove() + ", frequency=" + this.getFrequency() + ", wins=" + this.getWins() + ", losses=" + this.getLosses() + ", draws=" + this.getDraws() + "]";
    }

    public int hashCode() {
        int hc = this.move.hashCode();
        hc = hc * 31 + this.frequency;
        hc = hc * 17 + this.wins;
        hc = hc * 23 + this.losses;
        hc = hc * 37 + this.draws;
        return hc;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof BookMove)) {
            return false;
        }
        BookMove that = (BookMove)obj;
        if (!this.getMove().equals(that.getMove())) {
            return false;
        }
        if (this.getFrequency() != that.getFrequency()) {
            return false;
        }
        if (this.getWins() != that.getWins()) {
            return false;
        }
        if (this.getLosses() != that.getLosses()) {
            return false;
        }
        return this.getDraws() == that.getDraws();
    }

    public int getWins() {
        return this.wins;
    }

    public void setWins(int wins) {
        this.wins = wins;
    }

    public int getLosses() {
        return this.losses;
    }

    public void setLosses(int losses) {
        this.losses = losses;
    }

    public int getDraws() {
        return this.draws;
    }

    public void setDraws(int draws) {
        this.draws = draws;
    }
}

