/*
 * Decompiled with CFR 0.152.
 */
package serverutils.ranks;

import com.mojang.authlib.GameProfile;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.relauncher.Side;
import java.util.Collection;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.server.MinecraftServer;
import serverutils.lib.config.ConfigNull;
import serverutils.lib.config.ConfigValue;
import serverutils.lib.config.DefaultRankConfigHandler;
import serverutils.lib.config.IRankConfigHandler;
import serverutils.lib.config.RankConfigValueInfo;
import serverutils.lib.util.permission.DefaultPermissionHandler;
import serverutils.lib.util.permission.DefaultPermissionLevel;
import serverutils.lib.util.permission.IPermissionHandler;
import serverutils.lib.util.permission.context.IContext;
import serverutils.ranks.Ranks;

public enum ServerUtilitiesPermissionHandler implements IPermissionHandler,
IRankConfigHandler
{
    INSTANCE;


    @Override
    public void registerNode(String node, DefaultPermissionLevel level, String desc) {
        DefaultPermissionHandler.INSTANCE.registerNode(node, level, desc);
    }

    @Override
    public Collection<String> getRegisteredNodes() {
        return DefaultPermissionHandler.INSTANCE.getRegisteredNodes();
    }

    @Override
    public boolean hasPermission(GameProfile profile, String node, @Nullable IContext context) {
        boolean bl;
        if (context != null && context.getWorld() != null ? context.getWorld().field_72995_K : FMLCommonHandler.instance().getEffectiveSide() == Side.CLIENT) {
            return DefaultPermissionHandler.INSTANCE.getDefaultPermissionLevel(node) == DefaultPermissionLevel.ALL;
        }
        if (profile.getId() == null) {
            if (profile.getName() == null) {
                return false;
            }
            profile = new GameProfile(EntityPlayer.func_146094_a((GameProfile)profile), profile.getName());
        }
        switch (Ranks.INSTANCE.getPermissionResult(profile, node, true)) {
            case ALLOW: {
                bl = true;
                break;
            }
            case DENY: {
                bl = false;
                break;
            }
            default: {
                bl = DefaultPermissionHandler.INSTANCE.hasPermission(profile, node, context);
            }
        }
        return bl;
    }

    @Override
    public String getNodeDescription(String node) {
        return DefaultPermissionHandler.INSTANCE.getNodeDescription(node);
    }

    @Override
    public void registerRankConfig(RankConfigValueInfo info) {
        DefaultRankConfigHandler.INSTANCE.registerRankConfig(info);
    }

    @Override
    public Collection<RankConfigValueInfo> getRegisteredConfigs() {
        return DefaultRankConfigHandler.INSTANCE.getRegisteredConfigs();
    }

    @Override
    public ConfigValue getConfigValue(MinecraftServer server, GameProfile profile, String node) {
        ConfigValue value = ConfigNull.INSTANCE;
        if (Ranks.isActive()) {
            value = Ranks.INSTANCE.getPermission(profile, node, true);
        }
        return ((ConfigValue)value).isNull() ? DefaultRankConfigHandler.INSTANCE.getConfigValue(server, profile, node) : value;
    }

    @Override
    @Nullable
    public RankConfigValueInfo getInfo(String node) {
        return DefaultRankConfigHandler.INSTANCE.getInfo(node);
    }
}

