/*
 * Decompiled with CFR 0.152.
 */
package openblocks.common.item;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.IIcon;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import openblocks.OpenBlocks;
import openblocks.api.IPaintableBlock;
import openblocks.common.block.BlockCanvas;
import openmods.infobook.BookDocumentation;
import openmods.utils.ColorUtils;
import openmods.utils.ItemUtils;
import openmods.utils.render.PaintUtils;

@BookDocumentation(customName="paintbrush", hasVideo=true)
public class ItemPaintBrush
extends Item {
    private static final int SINGLE_COLOR_THRESHOLD = 16;
    private static final String TAG_COLOR = "color";
    public static final int MAX_USES = 24;
    public IIcon paintIcon;

    public ItemPaintBrush() {
        this.func_77637_a(OpenBlocks.tabOpenBlocks);
        this.func_77625_d(1);
        this.func_77656_e(24);
        this.setNoRepair();
    }

    public void func_77624_a(ItemStack itemStack, EntityPlayer player, List list, boolean par4) {
        Integer color = ItemPaintBrush.getColorFromStack(itemStack);
        if (color != null) {
            list.add(String.format("#%06X", color));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_77623_v() {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister registry) {
        super.func_94581_a(registry);
        this.paintIcon = registry.func_94245_a("openblocks:paintbrush_paint");
    }

    public void func_150895_a(Item item, CreativeTabs par2CreativeTabs, List list) {
        list.add(new ItemStack((Item)this));
        for (ColorUtils.ColorMeta color : ColorUtils.getAllColors()) {
            list.add(ItemPaintBrush.createStackWithColor(color.rgb));
        }
    }

    public static ItemStack createStackWithColor(int color) {
        ItemStack stack = new ItemStack((Item)OpenBlocks.Items.paintBrush);
        NBTTagCompound tag = ItemUtils.getItemTag((ItemStack)stack);
        tag.func_74768_a(TAG_COLOR, color);
        return stack;
    }

    public boolean func_77648_a(ItemStack stack, EntityPlayer player, World world, int x, int y, int z, int side, float hitX, float hitY, float hitZ) {
        boolean changed;
        Integer color = ItemPaintBrush.getColorFromStack(stack);
        if (stack.func_77960_j() > this.func_77612_l() || color == null) {
            return true;
        }
        if (PaintUtils.instance.isAllowedToReplace(world, x, y, z)) {
            BlockCanvas.replaceBlock(world, x, y, z);
        }
        if (changed = player.func_70093_af() ? ItemPaintBrush.tryRecolorBlock(world, x, y, z, color, ForgeDirection.VALID_DIRECTIONS) : ItemPaintBrush.tryRecolorBlock(world, x, y, z, color, ForgeDirection.getOrientation((int)side))) {
            world.func_72956_a((Entity)player, "mob.slime.small", 0.1f, 0.8f);
            if (!player.field_71075_bZ.field_75098_d && stack.func_96631_a(1, player.func_70681_au())) {
                NBTTagCompound tag = ItemUtils.getItemTag((ItemStack)stack);
                tag.func_82580_o(TAG_COLOR);
                stack.func_77964_b(0);
            }
        }
        return true;
    }

    private static boolean tryRecolorBlock(World world, int x, int y, int z, int rgb, ForgeDirection ... sides) {
        Block block = world.func_147439_a(x, y, z);
        if (block instanceof IPaintableBlock) {
            IPaintableBlock canvas = (IPaintableBlock)block;
            boolean result = false;
            for (ForgeDirection dir : sides) {
                result |= canvas.recolourBlockRGB(world, x, y, z, dir, rgb);
            }
            return result;
        }
        ColorUtils.ColorMeta nearest = ColorUtils.findNearestColor((ColorUtils.RGB)new ColorUtils.RGB(rgb), (int)16);
        if (nearest != null) {
            int vanillaColorId = nearest.vanillaBlockId;
            boolean result = false;
            for (ForgeDirection dir : sides) {
                result |= block.recolourBlock(world, x, y, z, dir, vanillaColorId);
            }
            return result;
        }
        return false;
    }

    public boolean onBlockStartBreak(ItemStack itemstack, int X, int Y, int Z, EntityPlayer player) {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public int func_82790_a(ItemStack itemStack, int pass) {
        Integer color;
        if (pass == 1 && (color = ItemPaintBrush.getColorFromStack(itemStack)) != null) {
            return color;
        }
        return 0xFFFFFF;
    }

    public IIcon func_77618_c(int dmg, int pass) {
        return pass == 1 ? this.paintIcon : this.func_77617_a(dmg);
    }

    public static Integer getColorFromStack(ItemStack stack) {
        NBTTagCompound tag;
        if (stack.func_77942_o() && (tag = stack.func_77978_p()).func_74764_b(TAG_COLOR)) {
            return tag.func_74762_e(TAG_COLOR);
        }
        return null;
    }

    public static void setColor(ItemStack stack, int color) {
        NBTTagCompound tag = ItemUtils.getItemTag((ItemStack)stack);
        tag.func_74768_a(TAG_COLOR, color);
    }
}

