/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.storagedrawers.packs.forestry.core;

import com.jaquadro.minecraft.storagedrawers.api.pack.BlockConfiguration;
import com.jaquadro.minecraft.storagedrawers.api.pack.BlockType;
import com.jaquadro.minecraft.storagedrawers.api.pack.ExtendedDataResolver;
import com.jaquadro.minecraft.storagedrawers.packs.forestry.core.ModBlocks;
import com.jaquadro.minecraft.storagedrawers.packs.forestry.core.ModCreativeTabs;
import com.jaquadro.minecraft.storagedrawers.packs.forestry.core.RefinedRelocation;
import cpw.mods.fml.common.registry.GameRegistry;
import net.minecraft.block.Block;
import net.minecraft.creativetab.CreativeTabs;

public class DataResolver
extends ExtendedDataResolver {
    public static String[][] textureBank = new String[][]{{"larch", "teak", "acacia", "lime", "chestnut", "wenge", "baobab", "sequoia", "kapok", "ebony", "mahogany", "balsa", "willow", "walnut", "greenheart", "cherry"}, {"mahoe", "poplar", "palm", "papaya", "pine", "plum", "maple", "citrus", "giganteum", "ipe", "padauk", "cocobolo", "zebrawood"}};
    private int bank;

    public DataResolver(String modID, int bankNumber) {
        super(modID, textureBank[bankNumber]);
        this.bank = bankNumber;
    }

    @Override
    public CreativeTabs getCreativeTabs(BlockType type) {
        return ModCreativeTabs.getTabStorageDrawers();
    }

    @Override
    public Block getBlock(BlockConfiguration blockConfig) {
        switch (blockConfig.getBlockType()) {
            case Drawers: {
                if (blockConfig.getDrawerCount() == 1 && ModBlocks.fullDrawers1 != null) {
                    return ModBlocks.fullDrawers1[this.bank];
                }
                if (blockConfig.getDrawerCount() == 2 && !blockConfig.isHalfDepth() && ModBlocks.fullDrawers2 != null) {
                    return ModBlocks.fullDrawers2[this.bank];
                }
                if (blockConfig.getDrawerCount() == 4 && !blockConfig.isHalfDepth() && ModBlocks.fullDrawers4 != null) {
                    return ModBlocks.fullDrawers4[this.bank];
                }
                if (blockConfig.getDrawerCount() == 2 && blockConfig.isHalfDepth() && ModBlocks.halfDrawers2 != null) {
                    return ModBlocks.halfDrawers2[this.bank];
                }
                if (blockConfig.getDrawerCount() != 4 || !blockConfig.isHalfDepth() || ModBlocks.halfDrawers4 == null) break;
                return ModBlocks.halfDrawers4[this.bank];
            }
            case DrawersSorting: {
                if (blockConfig.getDrawerCount() == 1 && RefinedRelocation.fullDrawers1 != null) {
                    return RefinedRelocation.fullDrawers1[this.bank];
                }
                if (blockConfig.getDrawerCount() == 2 && !blockConfig.isHalfDepth() && RefinedRelocation.fullDrawers2 != null) {
                    return RefinedRelocation.fullDrawers2[this.bank];
                }
                if (blockConfig.getDrawerCount() == 4 && !blockConfig.isHalfDepth() && RefinedRelocation.fullDrawers4 != null) {
                    return RefinedRelocation.fullDrawers4[this.bank];
                }
                if (blockConfig.getDrawerCount() == 2 && blockConfig.isHalfDepth() && RefinedRelocation.halfDrawers2 != null) {
                    return RefinedRelocation.halfDrawers2[this.bank];
                }
                if (blockConfig.getDrawerCount() != 4 || !blockConfig.isHalfDepth() || RefinedRelocation.halfDrawers4 == null) break;
                return RefinedRelocation.halfDrawers4[this.bank];
            }
            case Trim: {
                if (ModBlocks.trim == null) break;
                return ModBlocks.trim[this.bank];
            }
            case TrimSorting: {
                if (RefinedRelocation.trim == null) break;
                return RefinedRelocation.trim[this.bank];
            }
        }
        return null;
    }

    @Override
    public void init() {
        int startingOffset = 0;
        if (this.bank == 1) {
            startingOffset = textureBank[0].length;
        }
        int meta = 0;
        int plankMeta = startingOffset;
        while (meta < textureBank[this.bank].length) {
            this.setPlankSlab(meta, GameRegistry.findBlock((String)"Forestry", (String)"planks"), plankMeta, GameRegistry.findBlock((String)"Forestry", (String)"slabs"), plankMeta);
            ++meta;
            ++plankMeta;
        }
    }
}

