/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.storagedrawers.item;

import com.jaquadro.minecraft.storagedrawers.block.tile.TileEntityTrim;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;

public class ItemCustomTrim
extends ItemBlock {
    public ItemCustomTrim(Block block) {
        super(block);
    }

    public boolean placeBlockAt(ItemStack stack, EntityPlayer player, World world, int x, int y, int z, int side, float hitX, float hitY, float hitZ, int metadata) {
        if (!super.placeBlockAt(stack, player, world, x, y, z, side, hitX, hitY, hitZ, metadata)) {
            return false;
        }
        TileEntityTrim tile = (TileEntityTrim)world.func_147438_o(x, y, z);
        if (tile != null && stack.func_77942_o() && !stack.func_77978_p().func_74764_b("tile")) {
            if (stack.func_77978_p().func_74764_b("MatS")) {
                tile.setMaterialSide(ItemStack.func_77949_a((NBTTagCompound)stack.func_77978_p().func_74775_l("MatS")));
            }
            if (stack.func_77978_p().func_74764_b("MatT")) {
                tile.setMaterialTrim(ItemStack.func_77949_a((NBTTagCompound)stack.func_77978_p().func_74775_l("MatT")));
            }
        }
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack itemStack, EntityPlayer player, List list, boolean par4) {
        if (itemStack.func_77942_o()) {
            NBTTagCompound tag = itemStack.func_77978_p();
            this.addMaterialsInformation(tag, list);
        } else {
            list.add(StatCollector.func_74838_a((String)"storageDrawers.drawers.sealed.materialList"));
            list.add("  " + EnumChatFormatting.DARK_GRAY + StatCollector.func_74838_a((String)"storageDrawers.drawers.sealed.materialNone"));
        }
    }

    private void addMaterialsInformation(NBTTagCompound tag, List list) {
        ItemStack materialSide = null;
        ItemStack materialFront = null;
        ItemStack materialTrim = null;
        boolean hasMaterials = false;
        if (tag.func_74764_b("MatS")) {
            materialSide = ItemStack.func_77949_a((NBTTagCompound)tag.func_74775_l("MatS"));
            hasMaterials = true;
        }
        if (tag.func_74764_b("MatF")) {
            materialFront = ItemStack.func_77949_a((NBTTagCompound)tag.func_74775_l("MatF"));
            hasMaterials = true;
        }
        if (tag.func_74764_b("MatT")) {
            materialTrim = ItemStack.func_77949_a((NBTTagCompound)tag.func_74775_l("MatT"));
            hasMaterials = true;
        }
        list.add(EnumChatFormatting.GRAY + StatCollector.func_74838_a((String)"storageDrawers.drawers.sealed.materialList"));
        if (hasMaterials) {
            list.add("  " + EnumChatFormatting.YELLOW + StatCollector.func_74838_a((String)"storageDrawers.drawers.sealed.materialSide") + " " + this.getMaterialDisplayName(materialSide));
            list.add("  " + EnumChatFormatting.YELLOW + StatCollector.func_74838_a((String)"storageDrawers.drawers.sealed.materialTrim") + " " + this.getMaterialDisplayName(materialTrim));
            list.add("  " + EnumChatFormatting.YELLOW + StatCollector.func_74838_a((String)"storageDrawers.drawers.sealed.materialFront") + " " + this.getMaterialDisplayName(materialFront));
        } else {
            list.add("  " + EnumChatFormatting.DARK_GRAY + StatCollector.func_74838_a((String)"storageDrawers.drawers.sealed.materialNone"));
        }
    }

    private String getMaterialDisplayName(ItemStack stack) {
        if (stack != null) {
            if (stack.func_82837_s()) {
                return EnumChatFormatting.ITALIC.toString() + stack.func_77953_t().field_77937_e + stack.func_82833_r();
            }
            return stack.func_77953_t().field_77937_e.toString() + stack.func_82833_r();
        }
        return EnumChatFormatting.DARK_GRAY + StatCollector.func_74838_a((String)"storageDrawers.drawers.sealed.materialNone");
    }

    public static ItemStack makeItemStack(Block block, int count, ItemStack matSide, ItemStack matTrim) {
        Item item = Item.func_150898_a((Block)block);
        if (!(item instanceof ItemCustomTrim)) {
            return null;
        }
        NBTTagCompound tag = new NBTTagCompound();
        if (matSide != null) {
            tag.func_74782_a("MatS", (NBTBase)ItemCustomTrim.getMaterialTag(matSide));
        }
        if (matTrim != null) {
            tag.func_74782_a("MatT", (NBTBase)ItemCustomTrim.getMaterialTag(matTrim));
        }
        ItemStack stack = new ItemStack(item, count, 0);
        if (!tag.func_82582_d()) {
            stack.func_77982_d(tag);
        }
        return stack;
    }

    private static NBTTagCompound getMaterialTag(ItemStack mat) {
        mat = mat.func_77946_l();
        mat.field_77994_a = 1;
        NBTTagCompound itag = new NBTTagCompound();
        mat.func_77955_b(itag);
        return itag;
    }
}

