/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.storagedrawers.integration;

import com.jaquadro.minecraft.storagedrawers.StorageDrawers;
import com.jaquadro.minecraft.storagedrawers.api.pack.IPackDataResolver;
import com.jaquadro.minecraft.storagedrawers.block.pack.BlockDrawersPack;
import com.jaquadro.minecraft.storagedrawers.block.pack.BlockSortingDrawersPack;
import com.jaquadro.minecraft.storagedrawers.block.pack.BlockSortingTrimPack;
import com.jaquadro.minecraft.storagedrawers.block.pack.BlockTrimPack;
import com.jaquadro.minecraft.storagedrawers.config.ConfigManager;
import com.jaquadro.minecraft.storagedrawers.core.ModBlocks;
import com.jaquadro.minecraft.storagedrawers.integration.IntegrationModule;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.event.FMLInterModComms;
import cpw.mods.fml.common.registry.GameRegistry;
import net.minecraft.block.Block;
import net.minecraft.block.BlockWood;

public class ChiselIntegrationModule
extends IntegrationModule {
    private static final String chiselModID = "chisel";
    private static final String addVariation = "variation:add";
    private static final boolean chiselEnabled = Loader.isModLoaded((String)"chisel") && StorageDrawers.config.integrationConfig.isChiselEnabled();

    public static boolean isEnabled() {
        return chiselEnabled;
    }

    public static void registerPackBlock(Block block) {
        String blockGroupName;
        IPackDataResolver resolver;
        if (!chiselEnabled) {
            return;
        }
        if (block instanceof BlockDrawersPack) {
            resolver = ((BlockDrawersPack)block).getDataResolver();
            blockGroupName = ((BlockDrawersPack)block).halfDepth ? "basicHalf" + ((BlockDrawersPack)block).drawerCount : "basicFull" + ((BlockDrawersPack)block).drawerCount;
        } else if (block instanceof BlockSortingDrawersPack) {
            resolver = ((BlockSortingDrawersPack)block).getDataResolver();
            blockGroupName = ((BlockSortingDrawersPack)block).halfDepth ? "sortingHalf" + ((BlockSortingDrawersPack)block).drawerCount : "sortingFull" + ((BlockSortingDrawersPack)block).drawerCount;
        } else {
            blockGroupName = "trim";
            if (block instanceof BlockTrimPack) {
                resolver = ((BlockTrimPack)block).getDataResolver();
            } else if (block instanceof BlockSortingTrimPack) {
                resolver = ((BlockSortingTrimPack)block).getDataResolver();
            } else {
                return;
            }
        }
        if (resolver == null) {
            return;
        }
        for (int meta = 0; meta <= 16; ++meta) {
            if (!resolver.isValidMetaValue(meta)) continue;
            ChiselIntegrationModule.registerBlock(block, meta, blockGroupName);
        }
    }

    public static void registerBlock(Block block, int meta, String blockGroupName) {
        FMLInterModComms.sendMessage((String)chiselModID, (String)addVariation, (String)String.join((CharSequence)"|", "StorageDrawers_" + blockGroupName, GameRegistry.findUniqueIdentifierFor((Block)block).toString(), Integer.toString(meta)));
    }

    @Override
    public String getModID() {
        return chiselModID;
    }

    @Override
    public void init() throws Throwable {
        ConfigManager config = StorageDrawers.config;
        for (int meta = 0; meta < BlockWood.field_150096_a.length; ++meta) {
            if (config.isBlockEnabled("fulldrawers1")) {
                ChiselIntegrationModule.registerBlock((Block)ModBlocks.fullDrawers1, meta, "basicFull1");
            }
            if (config.isBlockEnabled("fulldrawers2")) {
                ChiselIntegrationModule.registerBlock((Block)ModBlocks.fullDrawers2, meta, "basicFull2");
            }
            if (config.isBlockEnabled("fulldrawers4")) {
                ChiselIntegrationModule.registerBlock((Block)ModBlocks.fullDrawers4, meta, "basicFull4");
            }
            if (config.isBlockEnabled("halfdrawers2")) {
                ChiselIntegrationModule.registerBlock((Block)ModBlocks.halfDrawers2, meta, "basicHalf2");
            }
            if (config.isBlockEnabled("halfdrawers4")) {
                ChiselIntegrationModule.registerBlock((Block)ModBlocks.halfDrawers4, meta, "basicHalf4");
            }
            if (!config.isBlockEnabled("trim")) continue;
            ChiselIntegrationModule.registerBlock(ModBlocks.trim, meta, "trim");
        }
    }

    @Override
    public void postInit() {
    }
}

