/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizons.postea.compat;

import com.falsepattern.endlessids.mixin.helpers.SubChunkBlockHook;
import com.gtnewhorizons.neid.mixins.interfaces.IExtendedBlockStorageMixin;
import com.gtnewhorizons.postea.compat.SubChunkAccess;
import net.minecraft.launchwrapper.Launch;
import net.minecraft.world.chunk.NibbleArray;
import net.minecraft.world.chunk.storage.ExtendedBlockStorage;

public class Compat {
    private static Boolean chunkapi = null;
    private static Boolean endlessids = null;
    private static Boolean neid = null;

    public static boolean chunkapiPresent() {
        if (chunkapi == null) {
            boolean present = false;
            try {
                present = Launch.classLoader.getClassBytes("com.falsepattern.chunk.internal.core.CoreLoadingPlugin") != null;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            chunkapi = present;
        }
        return chunkapi;
    }

    public static boolean endlessidsPresent() {
        if (endlessids == null) {
            boolean present = false;
            try {
                present = Launch.classLoader.getClassBytes("com.falsepattern.endlessids.asm.EndlessIDsCore") != null;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            endlessids = present;
        }
        return endlessids;
    }

    public static boolean neidPresent() {
        if (neid == null) {
            boolean present = false;
            try {
                present = Launch.classLoader.getClassBytes("com.gtnewhorizons.neid.core.NEIDCore") != null;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            neid = present;
        }
        return neid;
    }

    public static SubChunkAccess getSubChunkAccess(ExtendedBlockStorage subChunk) {
        if (Compat.endlessidsPresent()) {
            return EndlessIDSCompat.getSubChunkAccess(subChunk);
        }
        if (Compat.neidPresent()) {
            return NEIDCompat.getSubChunkAccess(subChunk);
        }
        return VanillaCompat.getSubChunkAccess(subChunk);
    }

    private static int toIndex(int x, int y, int z) {
        return y << 8 | z << 4 | x;
    }

    private static class EndlessIDSCompat {
        private EndlessIDSCompat() {
        }

        public static SubChunkAccess getSubChunkAccess(ExtendedBlockStorage subChunk) {
            final SubChunkBlockHook bh = (SubChunkBlockHook)subChunk;
            return new SubChunkAccess(){

                @Override
                public int getBlockId(int x, int y, int z) {
                    return bh.eid$getID(x, y, z);
                }

                @Override
                public void setBlockId(int x, int y, int z, int id) {
                    bh.eid$setID(x, y, z, id);
                }

                @Override
                public int getMeta(int x, int y, int z) {
                    return bh.eid$getMetadata(x, y, z);
                }

                @Override
                public void setMeta(int x, int y, int z, int meta) {
                    bh.eid$setMetadata(x, y, z, meta);
                }
            };
        }
    }

    private static class NEIDCompat {
        private NEIDCompat() {
        }

        public static SubChunkAccess getSubChunkAccess(ExtendedBlockStorage subChunk) {
            IExtendedBlockStorageMixin bh = (IExtendedBlockStorageMixin)subChunk;
            final short[] blockArray = bh.getBlock16BArray();
            final short[] metaArray = bh.getBlock16BMetaArray();
            return new SubChunkAccess(){

                @Override
                public int getBlockId(int x, int y, int z) {
                    return blockArray[Compat.toIndex(x, y, z)];
                }

                @Override
                public void setBlockId(int x, int y, int z, int id) {
                    blockArray[Compat.toIndex((int)x, (int)y, (int)z)] = (short)id;
                }

                @Override
                public int getMeta(int x, int y, int z) {
                    return metaArray[Compat.toIndex(x, y, z)];
                }

                @Override
                public void setMeta(int x, int y, int z, int meta) {
                    metaArray[Compat.toIndex((int)x, (int)y, (int)z)] = (short)meta;
                }
            };
        }
    }

    private static class VanillaCompat {
        private VanillaCompat() {
        }

        public static SubChunkAccess getSubChunkAccess(final ExtendedBlockStorage subChunk) {
            final byte[] lsb = subChunk.func_76658_g();
            return new SubChunkAccess(){
                private NibbleArray msb;
                {
                    this.msb = subChunk.func_76660_i();
                }

                @Override
                public int getBlockId(int x, int y, int z) {
                    int i = Compat.toIndex(x, y, z);
                    int id = lsb[i] & 0xFF;
                    if (this.msb != null) {
                        id |= this.msb.func_76582_a(x, y, z) << 8;
                    }
                    return id;
                }

                @Override
                public void setBlockId(int x, int y, int z, int id) {
                    int i = Compat.toIndex(x, y, z);
                    int l = id & 0xFF;
                    int h = id >>> 8 & 0xF;
                    lsb[i] = (byte)l;
                    if (h == 0 && this.msb == null) {
                        return;
                    }
                    if (this.msb == null) {
                        this.msb = new NibbleArray(lsb.length, 4);
                        subChunk.func_76673_a(this.msb);
                    }
                    this.msb.func_76581_a(x, y, z, h);
                }

                @Override
                public int getMeta(int x, int y, int z) {
                    return subChunk.func_76665_b(x, y, z);
                }

                @Override
                public void setMeta(int x, int y, int z, int meta) {
                    subChunk.func_76654_b(x, y, z, meta);
                }
            };
        }
    }
}

