/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.modularui.drawable.text;

import com.cleanroommc.modularui.api.drawable.IKey;
import com.cleanroommc.modularui.drawable.text.FontRenderHelper;
import com.cleanroommc.modularui.drawable.text.FormattingState;
import net.minecraft.util.EnumChatFormatting;
import org.apache.commons.lang3.NotImplementedException;
import org.jetbrains.annotations.Nullable;

public abstract class BaseKey
implements IKey {
    private FormattingState formatting;

    @Override
    public String getFormatted(@Nullable FormattingState parentFormatting) {
        return FontRenderHelper.format(this.formatting, parentFormatting, this.get());
    }

    @Override
    public BaseKey style(@Nullable EnumChatFormatting formatting) {
        if (this.formatting == null) {
            this.formatting = new FormattingState();
        }
        if (formatting == null) {
            this.formatting.forceDefaultColor();
        } else {
            this.formatting.add(formatting, false);
        }
        return this;
    }

    @Override
    public IKey removeStyle() {
        if (this.formatting != null) {
            this.formatting.reset();
        }
        return this;
    }

    @Override
    @Nullable
    public FormattingState getFormatting() {
        return this.formatting;
    }

    public String toString() {
        return this.getFormatted();
    }

    public int hashCode() {
        throw new NotImplementedException("Implement hashCode() in subclasses");
    }
}

