/*
 * Decompiled with CFR 0.152.
 */
package dev.rndmorris.salisarcana.common.commands;

import dev.rndmorris.salisarcana.common.commands.ArcanaCommandBase;
import dev.rndmorris.salisarcana.common.commands.arguments.ArgumentProcessor;
import dev.rndmorris.salisarcana.common.commands.arguments.CoordinateArgument;
import dev.rndmorris.salisarcana.common.commands.arguments.NodeModifierArgument;
import dev.rndmorris.salisarcana.common.commands.arguments.NodeTypeArgument;
import dev.rndmorris.salisarcana.common.commands.arguments.QuantitativeAspectArgument;
import dev.rndmorris.salisarcana.common.commands.arguments.annotations.NamedArg;
import dev.rndmorris.salisarcana.common.commands.arguments.annotations.PositionalArg;
import dev.rndmorris.salisarcana.common.commands.arguments.handlers.IArgumentHandler;
import dev.rndmorris.salisarcana.common.commands.arguments.handlers.named.AspectHandler;
import dev.rndmorris.salisarcana.common.commands.arguments.handlers.named.NodeModifierHandler;
import dev.rndmorris.salisarcana.common.commands.arguments.handlers.named.NodeTypeHandler;
import dev.rndmorris.salisarcana.common.commands.arguments.handlers.named.QuantitativeAspectHandler;
import dev.rndmorris.salisarcana.common.commands.arguments.handlers.positional.CoordinateHandler;
import dev.rndmorris.salisarcana.config.SalisConfig;
import java.util.ArrayList;
import javax.annotation.Nonnull;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.common.tiles.TileNode;

public class UpdateNodeCommand
extends ArcanaCommandBase<Arguments> {
    public UpdateNodeCommand() {
        super(SalisConfig.commands.updateNode);
    }

    @Override
    protected void process(ICommandSender sender, Arguments arguments, String[] args) {
        CoordinateArgument pos = arguments.updateAt;
        World world = sender.func_130014_f_();
        TileEntity tile = world.func_147438_o(pos.x, pos.y, pos.z);
        if (!(tile instanceof TileNode)) {
            throw new CommandException("salisarcana:command.update-node.not_found", new Object[]{pos.x, pos.y, pos.z});
        }
        TileNode node = (TileNode)tile;
        if (arguments.nodeModifier != null) {
            node.setNodeModifier(arguments.nodeModifier.modifier);
        }
        if (arguments.nodeType != null) {
            node.setNodeType(arguments.nodeType.nodeType);
        }
        if (!arguments.removeAspects.isEmpty()) {
            for (Aspect aspect : arguments.removeAspects) {
                node.getAspectsBase().remove(aspect);
                node.getAspects().remove(aspect);
            }
        }
        if (!arguments.addAspects.isEmpty()) {
            for (QuantitativeAspectArgument quantitativeAspectArgument : arguments.addAspects) {
                node.getAspectsBase().remove(quantitativeAspectArgument.aspect);
                node.getAspects().remove(quantitativeAspectArgument.aspect);
                node.getAspectsBase().add(quantitativeAspectArgument.aspect, quantitativeAspectArgument.amount);
                node.getAspects().add(quantitativeAspectArgument.aspect, quantitativeAspectArgument.amount);
            }
        }
        if (node.getAspects().visSize() <= 0) {
            world.func_147468_f(pos.x, pos.y, pos.z);
            return;
        }
        node.func_70296_d();
        world.func_147471_g(pos.x, pos.y, pos.z);
    }

    @Override
    @Nonnull
    protected ArgumentProcessor<Arguments> initializeProcessor() {
        return new ArgumentProcessor<Arguments>(Arguments.class, Arguments::new, new IArgumentHandler[]{CoordinateHandler.INSTANCE, NodeTypeHandler.INSTANCE, NodeModifierHandler.INSTANCE, QuantitativeAspectHandler.INSTANCE, AspectHandler.INSTANCE});
    }

    @Override
    protected int minimumRequiredArgs() {
        return 3;
    }

    public static class Arguments {
        @PositionalArg(index=0, handler=CoordinateHandler.class, descLangKey="coord")
        public CoordinateArgument updateAt;
        @NamedArg(name="-t", handler=NodeTypeHandler.class, descLangKey="type")
        public NodeTypeArgument nodeType;
        @NamedArg(name="-m", handler=NodeModifierHandler.class, descLangKey="modifier")
        public NodeModifierArgument nodeModifier;
        @NamedArg(name="--set", handler=QuantitativeAspectHandler.class, descLangKey="set")
        public ArrayList<QuantitativeAspectArgument> addAspects = new ArrayList();
        @NamedArg(name="--rem", handler=AspectHandler.class, descLangKey="rem")
        public ArrayList<Aspect> removeAspects = new ArrayList();
    }
}

