/*
 * Decompiled with CFR 0.152.
 */
package com.github.vfyjxf.nee.processor;

import codechicken.nei.PositionedStack;
import codechicken.nei.recipe.IRecipeHandler;
import com.github.vfyjxf.nee.processor.IRecipeProcessor;
import com.github.vfyjxf.nee.utils.GuiUtils;
import com.glodblock.github.client.gui.GuiFluidPatternTerminalEx;
import gregtech.api.enums.ItemList;
import gregtech.api.recipe.RecipeCategory;
import gregtech.nei.GTNEIDefaultHandler;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;

public class GregTech5RecipeProcessor
implements IRecipeProcessor {
    private static final Class<?> gtDefaultClz;
    private static final Class<?> gtAssLineClz;
    private final boolean isNH;

    public GregTech5RecipeProcessor(boolean isNH) {
        this.isNH = isNH;
    }

    public static FluidStack getFluidFromDisplayStack(ItemStack aDisplayStack) {
        if (!GregTech5RecipeProcessor.isStackValid(aDisplayStack) || aDisplayStack.func_77973_b() != ItemList.Display_Fluid.getItem() || !aDisplayStack.func_77942_o()) {
            return null;
        }
        Fluid tFluid = FluidRegistry.getFluid((int)ItemList.Display_Fluid.getItem().getDamage(aDisplayStack));
        return new FluidStack(tFluid, (int)aDisplayStack.func_77978_p().func_74763_f("mFluidDisplayAmount"));
    }

    public static boolean isStackValid(Object aStack) {
        return aStack instanceof ItemStack && ((ItemStack)aStack).func_77973_b() != null && ((ItemStack)aStack).field_77994_a >= 0;
    }

    @Override
    @Nonnull
    public Set<String> getAllOverlayIdentifier() {
        if (this.isNH) {
            return RecipeCategory.ALL_RECIPE_CATEGORIES.values().stream().filter(category -> category.recipeMap.getFrontend().getNEIProperties().registerNEI).map(category -> category.unlocalizedName).collect(Collectors.toSet());
        }
        try {
            HashSet<String> identifiers = new HashSet<String>();
            Class<?> recipeMapClazz = Class.forName("gregtech.api.util.GT_Recipe$GT_Recipe_Map");
            Collection sMappings = (Collection)recipeMapClazz.getDeclaredField("sMappings").get(null);
            for (Object tMap : sMappings) {
                boolean mNEIAllowed = recipeMapClazz.getDeclaredField("mNEIAllowed").getBoolean(tMap);
                if (!mNEIAllowed) continue;
                String mNEIName = (String)recipeMapClazz.getDeclaredField("mNEIName").get(tMap);
                identifiers.add(mNEIName);
            }
            identifiers.add("gt.recipe.fakeAssemblylineProcess");
            return identifiers;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    @Nonnull
    public String getRecipeProcessorId() {
        return "GregTech5";
    }

    @Override
    @Nonnull
    public List<PositionedStack> getRecipeInput(IRecipeHandler recipe, int recipeIndex, String identifier) {
        ArrayList<PositionedStack> recipeInputs = new ArrayList<PositionedStack>();
        if (this.canProcessRecipe(recipe)) {
            ItemStack specialItem;
            if (GuiUtils.isFluidCraftPatternTermEx(Minecraft.func_71410_x().field_71462_r)) {
                boolean priority = ((GuiFluidPatternTerminalEx)Minecraft.func_71410_x().field_71462_r).container.prioritize;
                if (priority) {
                    for (PositionedStack ps : recipe.getIngredientStacks(recipeIndex)) {
                        if (ps == null || GregTech5RecipeProcessor.getFluidFromDisplayStack(ps.item) == null) continue;
                        recipeInputs.add(ps);
                    }
                    for (PositionedStack ps : recipe.getIngredientStacks(recipeIndex)) {
                        if (ps == null || GregTech5RecipeProcessor.getFluidFromDisplayStack(ps.item) != null) continue;
                        recipeInputs.add(ps);
                    }
                } else {
                    recipeInputs.addAll(recipe.getIngredientStacks(recipeIndex));
                }
            } else {
                recipeInputs.addAll(recipe.getIngredientStacks(recipeIndex));
                recipeInputs.removeIf(positionedStack -> GregTech5RecipeProcessor.getFluidFromDisplayStack(positionedStack.items[0]) != null || positionedStack.item.field_77994_a == 0);
            }
            if (!recipeInputs.isEmpty() && ((specialItem = ((PositionedStack)recipeInputs.get((int)(recipeInputs.size() - 1))).items[0]).func_77969_a(ItemList.Tool_DataStick.get(1L, new Object[0])) || specialItem.func_77969_a(ItemList.Tool_DataOrb.get(1L, new Object[0])) && (recipe.getRecipeName().equals("gt.recipe.scanner") || recipe.getRecipeName().equals("gt.recipe.fakeAssemblylineProcess")))) {
                recipeInputs.remove(recipeInputs.size() - 1);
            }
            return recipeInputs;
        }
        return recipeInputs;
    }

    @Override
    @Nonnull
    public List<PositionedStack> getRecipeOutput(IRecipeHandler recipe, int recipeIndex, String identifier) {
        ArrayList<PositionedStack> recipeOutputs = new ArrayList<PositionedStack>();
        if (this.canProcessRecipe(recipe)) {
            recipeOutputs.addAll(recipe.getOtherStacks(recipeIndex));
            recipeOutputs.removeIf(positionedStack -> GregTech5RecipeProcessor.getFluidFromDisplayStack(positionedStack.items[0]) != null);
            recipeOutputs.removeIf(stack -> stack instanceof GTNEIDefaultHandler.FixedPositionedStack && ((GTNEIDefaultHandler.FixedPositionedStack)stack).mChance != 10000 && ((GTNEIDefaultHandler.FixedPositionedStack)stack).mChance > 0);
            return recipeOutputs;
        }
        return recipeOutputs;
    }

    @Override
    public boolean mergeStacks(IRecipeHandler recipe, int recipeIndex, String identifier) {
        return !"gt.recipe.fakeAssemblylineProcess".equals(identifier);
    }

    private boolean canProcessRecipe(IRecipeHandler recipe) {
        return gtDefaultClz != null && gtDefaultClz.isInstance(recipe) || gtAssLineClz != null && gtAssLineClz.isInstance(recipe);
    }

    static {
        Class<?> gtDH = null;
        Class<?> gtAL = null;
        try {
            gtDH = Class.forName("gregtech.nei.GTNEIDefaultHandler");
            gtAL = Class.forName("gregtech.nei.GT_NEI_AssLineHandler");
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        gtDefaultClz = gtDH;
        gtAssLineClz = gtAL;
    }
}

