/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.computronics.tape;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import pl.asie.computronics.Computronics;
import pl.asie.computronics.api.tape.ITapeStorage;

public class TapeStorage
implements ITapeStorage {
    private String uniqueId;
    private File file;
    private int size;
    private byte[] data;
    private int position;
    private boolean modified = false;

    protected TapeStorage(String uniqueId, File file, int size, int position) {
        this.uniqueId = uniqueId;
        this.file = file;
        this.size = size;
        this.data = new byte[size];
        this.position = position;
        if (!file.exists()) {
            try {
                file.createNewFile();
                this.writeFile();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            try {
                this.readFile();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public String getUniqueId() {
        return this.uniqueId;
    }

    @Override
    public String getName() {
        return "Tape";
    }

    @Override
    public int getPosition() {
        return this.position;
    }

    @Override
    public int getSize() {
        return this.size;
    }

    @Override
    public int setPosition(int newPosition) {
        if (newPosition < 0) {
            newPosition = 0;
        }
        if (newPosition >= this.size) {
            newPosition = this.size - 1;
        }
        this.position = newPosition;
        return newPosition;
    }

    public int trySeek(int dir) {
        int oldPosition = this.position;
        int newPosition = this.position + dir;
        if (newPosition < 0) {
            newPosition = 0;
        }
        if (newPosition >= this.size) {
            newPosition = this.size - 1;
        }
        return newPosition - oldPosition;
    }

    @Override
    public int seek(int dir) {
        int seek = this.trySeek(dir);
        this.position += seek;
        this.modified = true;
        return seek;
    }

    @Override
    public int read(boolean simulate) {
        if (this.position >= this.size) {
            return 0;
        }
        if (simulate) {
            return this.data[this.position] & 0xFF;
        }
        this.modified = true;
        return this.data[this.position++] & 0xFF;
    }

    public int read(byte[] v, int offset, boolean simulate) {
        int len = Math.min(this.size - (this.position + offset) - 1, v.length);
        System.arraycopy(this.data, this.position + offset, v, 0, len);
        if (!simulate) {
            this.position += len;
            this.modified = true;
        }
        return len;
    }

    @Override
    public int read(byte[] v, boolean simulate) {
        return this.read(v, 0, simulate);
    }

    @Override
    public void write(byte v) {
        if (this.position >= this.size) {
            return;
        }
        this.modified = true;
        this.data[this.position++] = v;
    }

    @Override
    public int write(byte[] v) {
        int len = Math.min(this.size - this.position - 1, v.length);
        if (len == 0) {
            return 0;
        }
        System.arraycopy(v, 0, this.data, this.position, len);
        this.position += len;
        this.modified = true;
        return len;
    }

    public void readFile() throws IOException {
        FileInputStream fileStream = new FileInputStream(this.file);
        GZIPInputStream stream = new GZIPInputStream(fileStream);
        int version = stream.read();
        if (version >= 1) {
            int b1 = stream.read() & 0xFF;
            int b2 = stream.read() & 0xFF;
            int b3 = stream.read() & 0xFF;
            int b4 = stream.read() & 0xFF;
            this.position = b1 | b2 << 8 | b3 << 16 | b4 << 24;
        }
        this.data = new byte[this.size];
        for (int position = 0; position < this.data.length; position += stream.read(this.data, position, this.data.length - position)) {
        }
        stream.close();
        fileStream.close();
    }

    public void writeFile() throws IOException {
        FileOutputStream fileStream = new FileOutputStream(this.file);
        GZIPOutputStream stream = new GZIPOutputStream(fileStream);
        stream.write(1);
        stream.write(this.position & 0xFF);
        stream.write(this.position >>> 8 & 0xFF);
        stream.write(this.position >>> 16 & 0xFF);
        stream.write(this.position >>> 24 & 0xFF);
        stream.write(this.data);
        stream.finish();
        stream.flush();
        stream.close();
        fileStream.close();
        this.modified = false;
    }

    public void writeFileIfModified() throws IOException {
        if (this.modified) {
            this.writeFile();
        }
    }

    @Override
    public void onStorageUnload() {
        try {
            this.writeFileIfModified();
        }
        catch (Exception e) {
            Computronics.log.error("Tape ID " + this.getUniqueId() + " was NOT saved!");
            e.printStackTrace();
        }
    }
}

