/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.computronics.integration.railcraft.tile;

import cpw.mods.fml.common.Optional;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import dan200.computercraft.api.peripheral.IComputerAccess;
import dan200.computercraft.api.peripheral.IPeripheral;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import li.cil.oc.api.Network;
import li.cil.oc.api.driver.DeviceInfo;
import li.cil.oc.api.network.BlacklistedPeripheral;
import li.cil.oc.api.network.Environment;
import li.cil.oc.api.network.Message;
import li.cil.oc.api.network.Node;
import li.cil.oc.api.network.SidedEnvironment;
import li.cil.oc.api.network.Visibility;
import mods.railcraft.common.blocks.signals.TileBoxBase;
import net.minecraft.block.Block;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.util.ForgeDirection;
import pl.asie.computronics.api.multiperipheral.IMultiPeripheral;
import pl.asie.computronics.cc.ISidedPeripheral;
import pl.asie.computronics.reference.Mods;
import pl.asie.computronics.util.OCUtils;
import pl.asie.computronics.util.internal.IComputronicsPeripheral;

@Optional.InterfaceList(value={@Optional.Interface(iface="li.cil.oc.api.network.Environment", modid="OpenComputers"), @Optional.Interface(iface="li.cil.oc.api.network.SidedEnvironment", modid="OpenComputers"), @Optional.Interface(iface="li.cil.oc.api.driver.DeviceInfo", modid="OpenComputers"), @Optional.Interface(iface="li.cil.oc.api.network.BlacklistedPeripheral", modid="OpenComputers"), @Optional.Interface(iface="pl.asie.computronics.api.multiperipheral.IMultiPeripheral", modid="ComputerCraft")})
public abstract class TileDigitalBoxBase
extends TileBoxBase
implements Environment,
SidedEnvironment,
DeviceInfo,
IMultiPeripheral,
IComputronicsPeripheral,
ISidedPeripheral,
BlacklistedPeripheral {
    protected String peripheralName;
    protected Object node;
    protected CopyOnWriteArrayList<IComputerAccess> attachedComputersCC;
    protected boolean addedToNetwork = false;
    protected Map<String, String> deviceInfo;

    public TileDigitalBoxBase(String name) {
        this.peripheralName = name;
        if (Mods.isLoaded("OpenComputers")) {
            this.initOC();
        }
    }

    public TileDigitalBoxBase(String name, double bufferSize) {
        this.peripheralName = name;
        if (Mods.isLoaded("OpenComputers")) {
            this.initOC(bufferSize);
        }
    }

    public void func_145845_h() {
        super.func_145845_h();
        if (!this.addedToNetwork && Mods.isLoaded("OpenComputers")) {
            this.addedToNetwork = true;
            Network.joinOrCreateNetwork((TileEntity)this);
        }
    }

    public Block func_145838_q() {
        if (this.field_145854_h == null) {
            this.field_145854_h = this.field_145850_b.func_147439_a(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }
        return this.field_145854_h;
    }

    public boolean isSideSolid(IBlockAccess world, int i, int j, int k, ForgeDirection side) {
        return side == ForgeDirection.UP;
    }

    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity pkt) {
        NBTTagCompound tag = pkt.func_148857_g();
        if (tag != null) {
            this.func_145839_a(tag);
        }
    }

    public void func_145841_b(NBTTagCompound data) {
        super.func_145841_b(data);
        if (Mods.isLoaded("OpenComputers")) {
            this.writeToNBT_OC(data);
        }
    }

    public void func_145839_a(NBTTagCompound data) {
        super.func_145839_a(data);
        if (Mods.isLoaded("OpenComputers")) {
            this.readFromNBT_OC(data);
        }
    }

    public void onChunkUnload() {
        super.onChunkUnload();
        if (Mods.isLoaded("OpenComputers")) {
            this.onChunkUnload_OC();
        }
    }

    public void func_145843_s() {
        super.func_145843_s();
        if (Mods.isLoaded("OpenComputers")) {
            this.invalidate_OC();
        }
    }

    @Optional.Method(modid="OpenComputers")
    public boolean isPeripheralBlacklisted() {
        return true;
    }

    @Optional.Method(modid="OpenComputers")
    public Node node() {
        return (Node)this.node;
    }

    @Optional.Method(modid="OpenComputers")
    public void onConnect(Node node) {
    }

    @Optional.Method(modid="OpenComputers")
    public void onDisconnect(Node node) {
    }

    @Optional.Method(modid="OpenComputers")
    public void onMessage(Message message) {
    }

    @Optional.Method(modid="OpenComputers")
    public Map<String, String> getDeviceInfo() {
        OCUtils.Device device;
        if (this.deviceInfo == null && (device = this.deviceInfo()) != null) {
            this.deviceInfo = device.deviceInfo();
            return this.deviceInfo;
        }
        return this.deviceInfo;
    }

    @Optional.Method(modid="OpenComputers")
    protected abstract OCUtils.Device deviceInfo();

    @Optional.Method(modid="OpenComputers")
    public Node sidedNode(ForgeDirection forgeDirection) {
        return forgeDirection == ForgeDirection.DOWN || forgeDirection == ForgeDirection.UP ? this.node() : null;
    }

    @Optional.Method(modid="OpenComputers")
    @SideOnly(value=Side.CLIENT)
    public boolean canConnect(ForgeDirection forgeDirection) {
        return forgeDirection == ForgeDirection.DOWN || forgeDirection == ForgeDirection.UP;
    }

    @Optional.Method(modid="ComputerCraft")
    public String getType() {
        return this.peripheralName;
    }

    @Optional.Method(modid="OpenComputers")
    private void initOC(double s) {
        this.node = Network.newNode((Environment)this, (Visibility)Visibility.Network).withComponent(this.peripheralName, Visibility.Network).withConnector(s).create();
    }

    @Optional.Method(modid="OpenComputers")
    private void initOC() {
        this.node = Network.newNode((Environment)this, (Visibility)Visibility.Network).withComponent(this.peripheralName, Visibility.Network).create();
    }

    @Optional.Method(modid="OpenComputers")
    public void readFromNBT_OC(NBTTagCompound nbt) {
        if (this.node() != null && this.node().host() == this) {
            this.node().load(nbt.func_74775_l("oc:node"));
        }
    }

    @Optional.Method(modid="OpenComputers")
    public void writeToNBT_OC(NBTTagCompound nbt) {
        if (this.node() != null && this.node().host() == this) {
            NBTTagCompound nodeNbt = new NBTTagCompound();
            this.node().save(nodeNbt);
            nbt.func_74782_a("oc:node", (NBTBase)nodeNbt);
        }
    }

    @Optional.Method(modid="OpenComputers")
    protected void onChunkUnload_OC() {
        if (this.node() != null) {
            this.node().remove();
        }
    }

    @Optional.Method(modid="OpenComputers")
    protected void invalidate_OC() {
        if (this.node() != null) {
            this.node().remove();
        }
    }

    @Optional.Method(modid="ComputerCraft")
    public void attach(IComputerAccess computer) {
        if (this.attachedComputersCC == null) {
            this.attachedComputersCC = new CopyOnWriteArrayList();
        }
        this.attachedComputersCC.add(computer);
    }

    @Optional.Method(modid="ComputerCraft")
    public void detach(IComputerAccess computer) {
        if (this.attachedComputersCC != null) {
            this.attachedComputersCC.remove(computer);
        }
    }

    @Optional.Method(modid="ComputerCraft")
    public boolean equals(IPeripheral other) {
        if (other == null) {
            return false;
        }
        if (this == other) {
            return true;
        }
        if (other instanceof TileEntity) {
            TileEntity tother = (TileEntity)other;
            if (!tother.func_145831_w().equals(this.field_145850_b)) {
                return false;
            }
            if (tother.field_145851_c != this.field_145851_c || tother.field_145848_d != this.field_145848_d || tother.field_145849_e != this.field_145849_e) {
                return false;
            }
        }
        return true;
    }

    @Override
    @Optional.Method(modid="ComputerCraft")
    public int peripheralPriority() {
        return 5;
    }

    @Override
    public boolean canConnectPeripheralOnSide(int side) {
        ForgeDirection forgeDirection = ForgeDirection.getOrientation((int)side);
        return forgeDirection == ForgeDirection.DOWN || forgeDirection == ForgeDirection.UP;
    }
}

