/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.doors.door.block;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import java.util.Random;
import net.malisis.core.block.BoundingBoxType;
import net.malisis.core.util.ComplexAxisAlignedBoundingBox;
import net.malisis.doors.door.block.BigDoor;
import net.malisis.doors.door.tileentity.BigDoorTileEntity;
import net.malisis.doors.door.tileentity.MultiTile;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.material.Material;
import net.minecraft.client.particle.EffectRenderer;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.IIcon;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class CollisionHelperBlock
extends BlockContainer
implements ITileEntityProvider {
    public BigDoor.Type type;
    private IIcon[] fakeIcons;

    public CollisionHelperBlock(BigDoor.Type type) {
        super(Material.field_151575_d);
        this.func_149711_c(1.0f);
        this.func_149672_a(Block.field_149766_f);
        this.func_149658_d(type.name + "_collisionHelper");
        this.type = type;
        this.func_149663_c(type.name + "_collisionHelper");
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister register) {
        this.fakeIcons = new IIcon[2];
        this.fakeIcons[0] = register.func_94245_a("malisisdoors:" + (Object)((Object)BigDoor.Type.CARRIAGE));
        this.fakeIcons[1] = register.func_94245_a("malisisdoors:" + (Object)((Object)BigDoor.Type.MEDIEVAL));
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149691_a(int side, int meta) {
        IIcon iIcon;
        switch (meta) {
            case 0: {
                iIcon = this.fakeIcons[0];
                break;
            }
            case 1: {
                iIcon = this.fakeIcons[1];
                break;
            }
            default: {
                iIcon = this.fakeIcons[0];
            }
        }
        return iIcon;
    }

    public boolean func_149659_a(Explosion par1Explosion) {
        return false;
    }

    public boolean func_149707_d(World world, int x, int y, int z, int side) {
        if (side != 1) {
            return false;
        }
        ForgeDirection dir = ForgeDirection.getOrientation((int)side).getOpposite();
        return world.func_147439_a(x + dir.offsetX, y + dir.offsetY, z + dir.offsetZ).isSideSolid((IBlockAccess)world, x, y, z, dir);
    }

    public boolean func_149727_a(World world, int x, int y, int z, EntityPlayer EntityPlayer2, int par6, float subx, float suby, float subz) {
        MultiTile tileEntity = (MultiTile)world.func_147438_o(x, y, z);
        return tileEntity.onBlockActivated(world, x, y, z, EntityPlayer2);
    }

    public void func_149749_a(World world, int x, int y, int z, Block block, int meta) {
        TileEntity tileEntity = world.func_147438_o(x, y, z);
        if (tileEntity instanceof MultiTile) {
            ((MultiTile)tileEntity).onBlockRemoval();
        }
        super.func_149749_a(world, x, y, z, block, meta);
    }

    public void func_149719_a(IBlockAccess world, int x, int y, int z) {
        int meta = world.func_72805_g(x, y, z);
        switch (meta) {
            case 0: {
                this.func_149676_a(0.8125f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
                break;
            }
            case 1: {
                this.func_149676_a(0.0f, 0.0f, 0.8125f, 1.0f, 1.0f, 1.0f);
                break;
            }
            case 2: {
                this.func_149676_a(0.0f, 0.0f, 0.0f, 0.1875f, 1.0f, 1.0f);
                break;
            }
            case 3: {
                this.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 0.1875f);
                break;
            }
            case 4: {
                this.func_149676_a(0.5f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
                break;
            }
            case 5: {
                this.func_149676_a(0.0f, 0.0f, 0.5f, 1.0f, 1.0f, 1.0f);
                break;
            }
            case 6: {
                this.func_149676_a(0.0f, 0.0f, 0.0f, 0.5f, 1.0f, 1.0f);
                break;
            }
            case 7: {
                this.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 0.5f);
                break;
            }
            case 8: {
                this.func_149676_a(0.0f, 0.0f, 0.0f, 0.5f, 1.0f, 0.5f);
                break;
            }
            case 9: {
                this.func_149676_a(0.5f, 0.0f, 0.0f, 1.0f, 1.0f, 0.5f);
                break;
            }
            case 10: {
                this.func_149676_a(0.5f, 0.0f, 0.5f, 1.0f, 1.0f, 1.0f);
                break;
            }
            case 11: {
                this.func_149676_a(0.0f, 0.0f, 0.5f, 0.5f, 1.0f, 1.0f);
            }
        }
    }

    public void func_149743_a(World world, int x, int y, int z, AxisAlignedBB axisalignedbb, List<AxisAlignedBB> list, Entity entity) {
        this.func_149719_a((IBlockAccess)world, x, y, z);
        super.func_149743_a(world, x, y, z, axisalignedbb, list, entity);
    }

    public AxisAlignedBB func_149668_a(World world, int x, int y, int z) {
        this.func_149719_a((IBlockAccess)world, x, y, z);
        return super.func_149668_a(world, x, y, z);
    }

    public AxisAlignedBB func_149633_g(World world, int x, int y, int z) {
        this.func_149719_a((IBlockAccess)world, x, y, z);
        MultiTile thisTE = (MultiTile)world.func_147438_o(x, y, z);
        Block mainBlock = world.func_147439_a(thisTE.mainBlockX, thisTE.mainBlockY, thisTE.mainBlockZ);
        if (mainBlock instanceof BigDoor) {
            return mainBlock.func_149633_g(world, thisTE.mainBlockX, thisTE.mainBlockY, thisTE.mainBlockZ);
        }
        return super.func_149633_g(world, x, y, z);
    }

    public ComplexAxisAlignedBoundingBox getComplexBoundingBox(World world, int x, int y, int z) {
        this.func_149719_a((IBlockAccess)world, x, y, z);
        MultiTile TE = this.getTileEntity(world, x, y, z);
        BigDoor mainBlock = this.getMainBlock(world, x, y, z);
        return mainBlock.getComplexBoundingBoxWithOffset((IBlockAccess)world, TE.mainBlockX, TE.mainBlockY, TE.mainBlockZ, BoundingBoxType.SELECTION);
    }

    public BigDoor getMainBlock(World world, int x, int y, int z) {
        MultiTile cTE = this.getTileEntity(world, x, y, z);
        return (BigDoor)world.func_147439_a(cTE.mainBlockX, cTE.mainBlockY, cTE.mainBlockZ);
    }

    public BigDoorTileEntity getMainTileEntity(World world, int x, int y, int z) {
        MultiTile cTE = this.getTileEntity(world, x, y, z);
        return (BigDoorTileEntity)world.func_147438_o(cTE.mainBlockX, cTE.mainBlockY, cTE.mainBlockZ);
    }

    public MultiTile getTileEntity(World world, int x, int y, int z) {
        return (MultiTile)world.func_147438_o(x, y, z);
    }

    public TileEntity func_149915_a(World worldIn, int meta) {
        return new MultiTile();
    }

    public float func_149712_f(World world, int x, int y, int z) {
        TileEntity tileEntity = world.func_147438_o(x, y, z);
        if (tileEntity instanceof MultiTile) {
            int mainX = ((MultiTile)tileEntity).mainBlockX;
            int mainY = ((MultiTile)tileEntity).mainBlockY;
            int mainZ = ((MultiTile)tileEntity).mainBlockZ;
            return world.func_147439_a(mainX, mainY, mainZ).func_149712_f(world, mainX, mainY, mainZ);
        }
        return this.field_149782_v;
    }

    public int func_149745_a(Random par1Random) {
        return 0;
    }

    public int func_149645_b() {
        return -1;
    }

    public boolean func_149686_d() {
        return false;
    }

    public boolean func_149662_c() {
        return false;
    }

    public boolean func_149646_a(IBlockAccess worldIn, int x, int y, int z, int side) {
        return false;
    }

    public void makeCollisionHelperBlock(World world, int x, int y, int z, int meta, int xMain, int yMain, int zMain, int metaMain) {
        world.func_147465_d(x, y, z, (Block)this, meta, 3);
        MultiTile tile = (MultiTile)world.func_147438_o(x, y, z);
        tile.setMainBlock(xMain, yMain, zMain);
        tile.setMainBlockMeta(metaMain);
    }

    public ItemStack getPickBlock(MovingObjectPosition target, World world, int x, int y, int z) {
        TileEntity tileEntity = world.func_147438_o(x, y, z);
        if (tileEntity instanceof MultiTile) {
            Block mainBlock;
            MultiTile multiTileEntity = (MultiTile)tileEntity;
            if (multiTileEntity.mainBlockSet && Blocks.field_150350_a != (mainBlock = world.func_147439_a(multiTileEntity.mainBlockX, multiTileEntity.mainBlockY, multiTileEntity.mainBlockZ))) {
                return mainBlock.getPickBlock(target, world, multiTileEntity.mainBlockX, multiTileEntity.mainBlockY, multiTileEntity.mainBlockZ);
            }
        }
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean addDestroyEffects(World world, int x, int y, int z, int meta, EffectRenderer effectRenderer) {
        TileEntity tileEntity = world.func_147438_o(x, y, z);
        if (tileEntity instanceof MultiTile) {
            Block mainBlock;
            MultiTile multiTileEntity = (MultiTile)tileEntity;
            if (multiTileEntity.mainBlockSet && Blocks.field_150350_a != (mainBlock = world.func_147439_a(multiTileEntity.mainBlockX, multiTileEntity.mainBlockY, multiTileEntity.mainBlockZ))) {
                return world.func_147439_a(multiTileEntity.mainBlockX, multiTileEntity.mainBlockY, multiTileEntity.mainBlockZ).addDestroyEffects(world, x, y, z, meta, effectRenderer);
            }
        }
        return super.addDestroyEffects(world, x, y, z, meta, effectRenderer);
    }
}

