/*
 * Decompiled with CFR 0.152.
 */
package com.sinthoras.hydroenergy.network.packet;

import com.sinthoras.hydroenergy.HE;
import com.sinthoras.hydroenergy.server.HEServer;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import io.netty.buffer.ByteBuf;

public class HEPacketConfigRequest
implements IMessage {
    public int waterId;
    public HE.DamMode mode;
    public int limitWest;
    public int limitDown;
    public int limitNorth;
    public int limitEast;
    public int limitUp;
    public int limitSouth;

    public HEPacketConfigRequest(int waterId, HE.DamMode mode, int limitWest, int limitDown, int limitNorth, int limitEast, int limitUp, int limitSouth) {
        this.waterId = waterId;
        this.mode = mode;
        this.limitWest = limitWest;
        this.limitDown = limitDown;
        this.limitNorth = limitNorth;
        this.limitEast = limitEast;
        this.limitUp = limitUp;
        this.limitSouth = limitSouth;
    }

    public HEPacketConfigRequest() {
    }

    public void fromBytes(ByteBuf buf) {
        this.waterId = buf.readInt();
        this.mode = HE.DamMode.getMode(buf.readInt());
        this.limitWest = buf.readInt();
        this.limitDown = buf.readInt();
        this.limitNorth = buf.readInt();
        this.limitEast = buf.readInt();
        this.limitUp = buf.readInt();
        this.limitSouth = buf.readInt();
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.waterId);
        buf.writeInt(this.mode.getValue());
        buf.writeInt(this.limitWest);
        buf.writeInt(this.limitDown);
        buf.writeInt(this.limitNorth);
        buf.writeInt(this.limitEast);
        buf.writeInt(this.limitUp);
        buf.writeInt(this.limitSouth);
    }

    public static class Handler
    implements IMessageHandler<HEPacketConfigRequest, IMessage> {
        public IMessage onMessage(HEPacketConfigRequest message, MessageContext ctx) {
            HEServer.instance.onConfigRequest(message.waterId, message.mode, message.limitWest, message.limitDown, message.limitNorth, message.limitEast, message.limitUp, message.limitSouth);
            return null;
        }
    }
}

