/*
 * Decompiled with CFR 0.152.
 */
package com.sinthoras.hydroenergy.client;

import com.sinthoras.hydroenergy.HE;
import com.sinthoras.hydroenergy.HEUtil;
import com.sinthoras.hydroenergy.config.HEConfig;
import com.sinthoras.hydroenergy.network.packet.HEPacketConfigRequest;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class HEDam {
    private int waterId;
    private float waterLevel;
    private HE.DamMode mode;
    public int limitUp;
    public int limitDown;
    public int limitEast;
    public int limitWest;
    public int limitSouth;
    public int limitNorth;
    private int blockX;
    private int blockY;
    private int blockZ;
    private HE.DamMode pendingMode;
    private int pendingLimitWest;
    private int pendingLimitDown;
    private int pendingLimitNorth;
    private int pendingLimitEast;
    private int pendingLimitUp;
    private int pendingLimitSouth;

    public HEDam(int waterId) {
        this.waterId = waterId;
    }

    public void onConfigUpdate(int blockX, int blockY, int blockZ, HE.DamMode mode, int limitWest, int limitDown, int limitNorth, int limitEast, int limitUp, int limitSouth) {
        this.blockX = blockX;
        this.blockY = blockY;
        this.blockZ = blockZ;
        this.mode = mode;
        this.limitWest = limitWest;
        this.limitDown = limitDown;
        this.limitNorth = limitNorth;
        this.limitEast = limitEast;
        this.limitUp = limitUp;
        this.limitSouth = limitSouth;
        this.pendingMode = mode;
        this.pendingLimitWest = limitWest;
        this.pendingLimitDown = limitDown;
        this.pendingLimitNorth = limitNorth;
        this.pendingLimitEast = limitEast;
        this.pendingLimitUp = limitUp;
        this.pendingLimitSouth = limitSouth;
        this.verifyChanges();
    }

    private void verifyChanges() {
        this.pendingLimitWest = this.blockX - HEUtil.clamp(this.blockX - this.pendingLimitWest, 0, HEConfig.maxWaterSpreadWest);
        this.pendingLimitDown = this.blockY - HEUtil.clamp(this.blockY - this.pendingLimitDown, 0, HEConfig.maxWaterSpreadDown);
        this.pendingLimitNorth = this.blockZ - HEUtil.clamp(this.blockZ - this.pendingLimitNorth, 0, HEConfig.maxWaterSpreadNorth);
        this.pendingLimitEast = this.blockX + HEUtil.clamp(this.pendingLimitEast - this.blockX, 0, HEConfig.maxWaterSpreadEast);
        this.pendingLimitUp = this.blockY + HEUtil.clamp(this.pendingLimitUp - this.blockY, 0, HEConfig.maxWaterSpreadUp);
        this.pendingLimitSouth = this.blockZ + HEUtil.clamp(this.pendingLimitSouth - this.blockZ, 0, HEConfig.maxWaterSpreadSouth);
    }

    public void onWaterUpdate(float waterLevel) {
        this.waterLevel = waterLevel;
    }

    public boolean renderAsDebug() {
        return this.mode != HE.DamMode.SPREAD;
    }

    public float getWaterLevelForPhysicsAndLighting() {
        if (this.mode == HE.DamMode.SPREAD) {
            return this.waterLevel;
        }
        return 0.0f;
    }

    public float getWaterLevelForRendering() {
        if (this.mode == HE.DamMode.SPREAD) {
            return this.waterLevel;
        }
        return 256.0f;
    }

    public void applyChanges() {
        HE.network.sendToServer((IMessage)new HEPacketConfigRequest(this.waterId, this.pendingMode, this.pendingLimitWest, this.pendingLimitDown, this.pendingLimitNorth, this.pendingLimitEast, this.pendingLimitUp, this.pendingLimitSouth));
    }

    public void setMode(HE.DamMode mode) {
        this.pendingMode = mode;
    }

    public HE.DamMode getMode() {
        return this.pendingMode;
    }

    public void setLimitWest(int limitWest) {
        this.pendingLimitWest = limitWest;
        this.verifyChanges();
    }

    public void setLimitDown(int limitDown) {
        this.pendingLimitDown = limitDown;
        this.verifyChanges();
    }

    public void setLimitNorth(int limitNorth) {
        this.pendingLimitNorth = limitNorth;
        this.verifyChanges();
    }

    public void setLimitEast(int limitEast) {
        this.pendingLimitEast = limitEast;
        this.verifyChanges();
    }

    public void setLimitUp(int limitUp) {
        this.pendingLimitUp = limitUp;
        this.verifyChanges();
    }

    public void setLimitSouth(int limitSouth) {
        this.pendingLimitSouth = limitSouth;
        this.verifyChanges();
    }

    public int getLimitWest() {
        return this.pendingLimitWest;
    }

    public int getLimitDown() {
        return this.pendingLimitDown;
    }

    public int getLimitNorth() {
        return this.pendingLimitNorth;
    }

    public int getLimitEast() {
        return this.pendingLimitEast;
    }

    public int getLimitUp() {
        return this.pendingLimitUp;
    }

    public int getLimitSouth() {
        return this.pendingLimitSouth;
    }

    public int getBlockX() {
        return this.blockX;
    }

    public int getBlockY() {
        return this.blockY;
    }

    public int getWaterId() {
        return this.waterId;
    }

    public int getBlockZ() {
        return this.blockZ;
    }
}

