/*
 * Decompiled with CFR 0.152.
 */
package tectech.mechanics.pipe;

import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import eu.usrv.yamcore.network.client.AbstractClientMessageHandler;
import eu.usrv.yamcore.network.server.AbstractServerMessageHandler;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;
import tectech.mechanics.pipe.IActivePipe;

public class PipeActivityMessage
implements IMessage {
    int mPosX;
    int mPosY;
    int mPosZ;
    int mPosD;
    int mActive;

    public PipeActivityMessage() {
    }

    private PipeActivityMessage(IActivePipe metaTile) {
        IGregTechTileEntity base = metaTile.getBaseMetaTileEntity();
        this.mPosX = base.getXCoord();
        this.mPosY = base.getYCoord();
        this.mPosZ = base.getZCoord();
        this.mPosD = base.getWorld().field_73011_w.field_76574_g;
        this.mActive = metaTile.getActive() ? 1 : 0;
    }

    private PipeActivityMessage(World world, int x, int y, int z, boolean active) {
        this.mPosX = x;
        this.mPosY = y;
        this.mPosZ = z;
        this.mPosD = world.field_73011_w.field_76574_g;
        this.mActive = active ? 1 : 0;
    }

    public void fromBytes(ByteBuf buffer) {
        this.mPosX = buffer.readInt();
        this.mPosY = buffer.readInt();
        this.mPosZ = buffer.readInt();
        this.mPosD = buffer.readInt();
        this.mActive = buffer.readInt();
    }

    public void toBytes(ByteBuf buffer) {
        buffer.writeInt(this.mPosX);
        buffer.writeInt(this.mPosY);
        buffer.writeInt(this.mPosZ);
        buffer.writeInt(this.mPosD);
        buffer.writeInt(this.mActive);
    }

    public static class ServerHandler
    extends AbstractServerMessageHandler<PipeActivityQuery> {
        public IMessage handleServerMessage(EntityPlayer pPlayer, PipeActivityQuery pMessage, MessageContext pCtx) {
            IGregTechTileEntity gregTile;
            IMetaTileEntity meta;
            TileEntity te;
            WorldServer world = DimensionManager.getWorld((int)pMessage.mPosD);
            if (world != null && (te = world.func_147438_o(pMessage.mPosX, pMessage.mPosY, pMessage.mPosZ)) instanceof IGregTechTileEntity && (meta = (gregTile = (IGregTechTileEntity)te).getMetaTileEntity()) instanceof IActivePipe) {
                IActivePipe activePipe = (IActivePipe)meta;
                pMessage.mActive = activePipe.getActive() ? 1 : 0;
                return new PipeActivityData(pMessage);
            }
            return null;
        }
    }

    public static class ClientHandler
    extends AbstractClientMessageHandler<PipeActivityData> {
        public IMessage handleClientMessage(EntityPlayer pPlayer, PipeActivityData pMessage, MessageContext pCtx) {
            IGregTechTileEntity gregTile;
            IMetaTileEntity meta;
            TileEntity te;
            if (pPlayer.field_70170_p.field_73011_w.field_76574_g == pMessage.mPosD && (te = pPlayer.field_70170_p.func_147438_o(pMessage.mPosX, pMessage.mPosY, pMessage.mPosZ)) instanceof IGregTechTileEntity && (meta = (gregTile = (IGregTechTileEntity)te).getMetaTileEntity()) instanceof IActivePipe) {
                IActivePipe activePipe = (IActivePipe)meta;
                activePipe.setActive(pMessage.mActive == 1);
            }
            return null;
        }
    }

    public static class PipeActivityData
    extends PipeActivityMessage {
        public PipeActivityData() {
        }

        private PipeActivityData(PipeActivityQuery query) {
            this.mPosX = query.mPosX;
            this.mPosY = query.mPosY;
            this.mPosZ = query.mPosZ;
            this.mPosD = query.mPosD;
            this.mActive = query.mActive;
        }

        public PipeActivityData(IActivePipe metaTile) {
            super(metaTile);
        }

        public PipeActivityData(World world, int x, int y, int z, boolean active) {
            super(world, x, y, z, active);
        }
    }

    public static class PipeActivityQuery
    extends PipeActivityMessage {
        public PipeActivityQuery() {
        }

        public PipeActivityQuery(IActivePipe metaTile) {
            super(metaTile);
        }

        public PipeActivityQuery(World world, int x, int y, int z, boolean active) {
            super(world, x, y, z, active);
        }
    }
}

