/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.xmod.gregtech.loaders;

import gregtech.api.enums.GTValues;
import gregtech.api.enums.ItemList;
import gregtech.api.recipe.RecipeMaps;
import gtPlusPlus.api.interfaces.RunnableWithInfo;
import gtPlusPlus.api.objects.Logger;
import gtPlusPlus.api.recipe.GTPPRecipeMaps;
import gtPlusPlus.core.material.Material;
import gtPlusPlus.core.material.MaterialGenerator;
import gtPlusPlus.core.material.MaterialStack;
import gtPlusPlus.core.material.state.MaterialState;
import gtPlusPlus.core.util.minecraft.ItemUtils;
import gtPlusPlus.xmod.gregtech.loaders.RecipeGenBase;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import net.minecraft.item.ItemStack;
import org.apache.commons.lang3.tuple.Pair;

public class RecipeGenMaterialProcessing
extends RecipeGenBase {
    public static final Set<RunnableWithInfo<Material>> mRecipeGenMap = new HashSet<RunnableWithInfo<Material>>();

    public RecipeGenMaterialProcessing(Material M) {
        this(M, false);
    }

    public RecipeGenMaterialProcessing(Material M, boolean O) {
        this.toGenerate = M;
        this.disableOptional = O;
        mRecipeGenMap.add(this);
    }

    @Override
    public void run() {
        this.generateRecipes(this.toGenerate, this.disableOptional);
    }

    private void generateRecipes(Material material, boolean disableOptional) {
        if (disableOptional) {
            return;
        }
        if (material.getMaterialComposites().length > 1) {
            int[] mChances;
            ItemStack[] mInternalOutputs;
            Logger.MATERIALS("[Recipe Generator Debug] [" + material.getLocalizedName() + "]");
            int tVoltageMultiplier = material.vVoltageMultiplier;
            int[] partSizes = new int[99];
            if (material.vSmallestRatio != null) {
                partSizes = new int[material.vSmallestRatio.length];
                for (int hu = 0; hu < material.vSmallestRatio.length; ++hu) {
                    partSizes[hu] = (int)material.vSmallestRatio[hu];
                }
            }
            ArrayList<Pair> componentMap = new ArrayList<Pair>();
            int alnsnfds = 0;
            for (MaterialStack r : material.getComposites()) {
                if (r != null) {
                    componentMap.add(Pair.of((Object)partSizes[alnsnfds], (Object)r.getStackMaterial()));
                }
                ++alnsnfds;
            }
            if (!componentMap.isEmpty() && componentMap.size() <= 6 && material.smallestStackSizeWhenProcessing <= 64) {
                ItemStack mainDust;
                mInternalOutputs = new ItemStack[6];
                mChances = new int[6];
                int mCellCount = 0;
                int mTotalCount = 0;
                int mCounter = 0;
                for (Pair f : componentMap) {
                    if (((Material)f.getValue()).getState() != MaterialState.SOLID) {
                        Logger.MATERIALS("[Centrifuge] Found Fluid Component, adding " + f.getKey() + " cells of " + ((Material)f.getValue()).getLocalizedName() + ".");
                        mInternalOutputs[mCounter++] = ((Material)f.getValue()).getCell((Integer)f.getKey());
                        mTotalCount += ((Integer)f.getKey()).intValue();
                        Logger.MATERIALS("[Centrifuge] In total, adding " + (mCellCount += ((Integer)f.getKey()).intValue()) + " cells for " + material.getLocalizedName() + " processing.");
                        continue;
                    }
                    Logger.MATERIALS("[Centrifuge] Found Solid Component, adding " + f.getKey() + " dusts of " + ((Material)f.getValue()).getLocalizedName() + ".");
                    mInternalOutputs[mCounter++] = ((Material)f.getValue()).getDust((Integer)f.getKey());
                    mTotalCount += ((Integer)f.getKey()).intValue();
                }
                for (int g = 0; g < mInternalOutputs.length; ++g) {
                    Logger.MATERIALS("[Centrifuge] Is output[" + g + "] valid with a chance? " + (mInternalOutputs[g] != null ? 10000 : 0));
                    mChances[g] = mInternalOutputs[g] != null ? 10000 : 0;
                }
                ItemStack emptyCell = null;
                if (mCellCount > 0) {
                    emptyCell = ItemUtils.getItemStackOfAmountFromOreDict("cellEmpty", mCellCount);
                    Logger.MATERIALS("[Centrifuge] Recipe now requires " + mCellCount + " empty cells as input.");
                }
                if ((mainDust = material.getDust(material.smallestStackSizeWhenProcessing)) != null) {
                    Logger.MATERIALS("[Centrifuge] Recipe now requires " + material.smallestStackSizeWhenProcessing + "x " + mainDust.func_82833_r() + " as input.");
                } else {
                    mainDust = material.getDust(mTotalCount);
                    Logger.MATERIALS("[Centrifuge] Could not find valid input dust, trying alternative.");
                    if (mainDust != null) {
                        Logger.MATERIALS("[Centrifuge] Recipe now requires " + mTotalCount + "x " + mainDust.func_82833_r() + " as input.");
                    } else {
                        Logger.MATERIALS("[Centrifuge] Could not find valid input dust, exiting.");
                        return;
                    }
                }
                for (int j = 0; j < mInternalOutputs.length; ++j) {
                    if (mInternalOutputs[j] == null) {
                        mInternalOutputs[j] = GTValues.NI;
                        Logger.MATERIALS("[Centrifuge] Set slot " + j + "  to null.");
                        continue;
                    }
                    Logger.MATERIALS("[Centrifuge] Set slot " + j + " to " + mInternalOutputs[j].func_82833_r() + ".");
                }
                ArrayList<ItemStack> internalOutputs = new ArrayList<ItemStack>(Arrays.asList(mInternalOutputs));
                internalOutputs.removeIf(Objects::isNull);
                int[] chances = new int[internalOutputs.size()];
                System.arraycopy(mChances, 0, chances, 0, internalOutputs.size());
                ItemStack[] inputs = emptyCell == null ? new ItemStack[]{mainDust} : new ItemStack[]{mainDust, emptyCell};
                GTValues.RA.stdBuilder().itemInputs(inputs).itemOutputs(internalOutputs.toArray(new ItemStack[0])).outputChances(chances).eut(tVoltageMultiplier).duration(tVoltageMultiplier / 10 * 20).addTo(RecipeMaps.centrifugeRecipes);
                Logger.MATERIALS("[Centrifuge] Generated Centrifuge recipe for " + material.getDust(1).func_82833_r());
            } else if (componentMap.size() > 6 && componentMap.size() <= 9) {
                ItemStack mainDust;
                Logger.MATERIALS("[Issue][Electrolyzer] " + material.getLocalizedName() + " is composed of over 6 materials, so an electrolyzer recipe for processing cannot be generated. Trying to create one for the Dehydrator instead.");
                mInternalOutputs = new ItemStack[9];
                mChances = new int[9];
                int mCellCount = 0;
                int mTotalCount = 0;
                int mCounter = 0;
                for (Pair f : componentMap) {
                    if (((Material)f.getValue()).getState() != MaterialState.SOLID) {
                        Logger.MATERIALS("[Dehydrator] Found Fluid Component, adding " + f.getKey() + " cells of " + ((Material)f.getValue()).getLocalizedName() + ".");
                        mInternalOutputs[mCounter++] = ((Material)f.getValue()).getCell((Integer)f.getKey());
                        mTotalCount += ((Integer)f.getKey()).intValue();
                        Logger.MATERIALS("[Dehydrator] In total, adding " + (mCellCount += ((Integer)f.getKey()).intValue()) + " cells for " + material.getLocalizedName() + " processing.");
                        continue;
                    }
                    Logger.MATERIALS("[Dehydrator] Found Solid Component, adding " + f.getKey() + " dusts of " + ((Material)f.getValue()).getLocalizedName() + ".");
                    mInternalOutputs[mCounter++] = ((Material)f.getValue()).getDust((Integer)f.getKey());
                    mTotalCount += ((Integer)f.getKey()).intValue();
                }
                for (int g = 0; g < mInternalOutputs.length; ++g) {
                    Logger.MATERIALS("[Dehydrator] Is output[" + g + "] valid with a chance? " + (mInternalOutputs[g] != null ? 10000 : 0));
                    mChances[g] = mInternalOutputs[g] != null ? 10000 : 0;
                }
                ItemStack emptyCell = null;
                if (mCellCount > 0) {
                    emptyCell = ItemList.Cell_Empty.get(mCellCount, new Object[0]);
                    Logger.MATERIALS("[Dehydrator] Recipe now requires " + mCellCount + " empty cells as input.");
                }
                if ((mainDust = material.getDust(material.smallestStackSizeWhenProcessing)) != null) {
                    Logger.MATERIALS("[Dehydrator] Recipe now requires " + material.smallestStackSizeWhenProcessing + "x " + mainDust.func_82833_r() + " as input.");
                } else {
                    mainDust = material.getDust(mTotalCount);
                    Logger.MATERIALS("[Dehydrator] Could not find valid input dust, trying alternative.");
                    if (mainDust != null) {
                        Logger.MATERIALS("[Dehydrator] Recipe now requires " + mTotalCount + "x " + mainDust.func_82833_r() + " as input.");
                    } else {
                        Logger.MATERIALS("[Dehydrator] Could not find valid input dust, exiting.");
                        return;
                    }
                }
                for (int j = 0; j < mInternalOutputs.length; ++j) {
                    if (mInternalOutputs[j] == null) {
                        mInternalOutputs[j] = GTValues.NI;
                        Logger.MATERIALS("[Dehydrator] Set slot " + j + "  to null.");
                        continue;
                    }
                    Logger.MATERIALS("[Dehydrator] Set slot " + j + " to " + mInternalOutputs[j].func_82833_r() + ".");
                }
                ArrayList<ItemStack> internalOutputs = new ArrayList<ItemStack>(Arrays.asList(mInternalOutputs));
                internalOutputs.removeIf(Objects::isNull);
                int[] chances = new int[internalOutputs.size()];
                System.arraycopy(mChances, 0, chances, 0, internalOutputs.size());
                ItemStack[] inputs = emptyCell == null ? new ItemStack[]{mainDust} : new ItemStack[]{mainDust, emptyCell};
                GTValues.RA.stdBuilder().itemInputs(inputs).itemOutputs(internalOutputs.toArray(new ItemStack[0])).outputChances(chances).eut(tVoltageMultiplier).duration(20 * (tVoltageMultiplier / 10)).addTo(GTPPRecipeMaps.chemicalDehydratorRecipes);
                Logger.MATERIALS("[Dehydrator] Generated Dehydrator recipe for " + material.getDust(1).func_82833_r());
            }
        }
    }

    static {
        MaterialGenerator.mRecipeMapsToGenerate.add(mRecipeGenMap);
    }
}

