/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.core.item.base;

import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import gregtech.api.enums.Mods;
import gtPlusPlus.api.objects.Logger;
import java.util.List;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumChatFormatting;

public class BaseItemDamageable
extends Item {
    private final EnumRarity rarity;
    private final String itemDescription;
    protected String itemName;
    private final boolean hasEffect;

    public BaseItemDamageable(String unlocalizedName, CreativeTabs creativeTab, int stackSize, int maxDmg, String description, EnumRarity regRarity, EnumChatFormatting colour, boolean Effect, ItemStack OverrideItem) {
        this.func_77655_b(unlocalizedName);
        this.func_111206_d(Mods.GTPlusPlus.ID + ":" + unlocalizedName);
        this.func_77637_a(creativeTab);
        this.func_77625_d(1);
        this.func_77656_e(251);
        this.setNoRepair();
        this.rarity = regRarity;
        this.itemDescription = description;
        this.hasEffect = Effect;
        GameRegistry.registerItem((Item)this, (String)unlocalizedName);
    }

    public String getItemDescription() {
        return this.itemDescription;
    }

    public void func_77624_a(ItemStack stack, EntityPlayer aPlayer, List list, boolean bool) {
        int dmg = (int)BaseItemDamageable.getItemDamage(stack);
        if (dmg <= 3) {
            list.add(EnumChatFormatting.GRAY + this.itemDescription);
        }
        if (dmg > 3 && dmg <= 25) {
            list.add(EnumChatFormatting.GRAY + "You have discovered that smashing this against valuable stones has some function..");
        } else if (dmg > 0) {
            int maxDamage = 250;
            list.add(EnumChatFormatting.GRAY + "" + ((long)maxDamage - BaseItemDamageable.getItemDamage(stack)) + "/" + maxDamage + " gems remaining.");
        }
    }

    @SideOnly(value=Side.CLIENT)
    public EnumRarity func_77613_e(ItemStack par1ItemStack) {
        int dmg = (int)BaseItemDamageable.getItemDamage(par1ItemStack);
        if (dmg > 200) {
            return EnumRarity.epic;
        }
        return this.rarity;
    }

    public boolean hasEffect(ItemStack par1ItemStack, int pass) {
        int dmg = (int)BaseItemDamageable.getItemDamage(par1ItemStack);
        if (dmg > 200) {
            return true;
        }
        return this.hasEffect;
    }

    public String func_77653_i(ItemStack tItem) {
        if (this.itemName == null || this.itemName.isEmpty()) {
            return super.func_77653_i(tItem);
        }
        return this.itemName;
    }

    private static boolean createNBT(ItemStack rStack) {
        NBTTagCompound tagMain = new NBTTagCompound();
        NBTTagCompound tagNBT = new NBTTagCompound();
        tagNBT.func_74772_a("Value", 0L);
        tagMain.func_74782_a("Damage", (NBTBase)tagNBT);
        rStack.func_77982_d(tagMain);
        return true;
    }

    public static long getItemDamage(ItemStack aStack) {
        NBTTagCompound aNBT = aStack.func_77978_p();
        if (aNBT != null) {
            if ((aNBT = aNBT.func_74775_l("Damage")) != null) {
                return aNBT.func_74763_f("Value");
            }
        } else {
            BaseItemDamageable.createNBT(aStack);
        }
        return 0L;
    }

    public static boolean setItemDamage(ItemStack aStack, long aDamage) {
        NBTTagCompound aNBT = aStack.func_77978_p();
        if (aNBT != null) {
            if ((aNBT = aNBT.func_74775_l("Damage")) != null) {
                aNBT.func_74772_a("Value", aDamage);
                return true;
            }
        } else {
            BaseItemDamageable.createNBT(aStack);
        }
        return false;
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        if (stack.func_77978_p() == null) {
            BaseItemDamageable.createNBT(stack);
        }
        double currentDamage = BaseItemDamageable.getItemDamage(stack);
        double durabilitypercent = currentDamage / 100.0;
        double inverse = 100.0 - durabilitypercent;
        return durabilitypercent;
    }

    public boolean showDurabilityBar(ItemStack stack) {
        int dmg = (int)BaseItemDamageable.getItemDamage(stack);
        return dmg > 20;
    }

    public static ItemStack damageItem(ItemStack item) {
        if (item != null) {
            long currentUse = BaseItemDamageable.getItemDamage(item);
            if (currentUse >= 0L && currentUse <= 250L) {
                BaseItemDamageable.setItemDamage(item, currentUse + 1L);
            }
            return item;
        }
        return null;
    }

    public boolean func_77630_h(ItemStack stack) {
        Logger.INFO("Does Leave Table? " + stack.func_82833_r());
        return true;
    }

    public boolean hasContainerItem(ItemStack stack) {
        return true;
    }

    public ItemStack getContainerItem(ItemStack itemStack) {
        ItemStack stack = itemStack.func_77946_l();
        BaseItemDamageable.damageItem(stack);
        stack.field_77994_a = 1;
        return stack;
    }

    public int getDamage(ItemStack stack) {
        return (int)BaseItemDamageable.getItemDamage(stack);
    }
}

