/*
 * Decompiled with CFR 0.152.
 */
package gregtech.crossmod.navigator;

import com.gtnewhorizons.navigator.api.model.locations.IWaypointAndLocationProvider;
import com.gtnewhorizons.navigator.api.model.waypoints.Waypoint;
import gregtech.common.data.GTPowerfailTracker;

public class PowerfailLocationWrapper
implements IWaypointAndLocationProvider {
    public GTPowerfailTracker.Powerfail powerfail;
    private boolean activeAsWaypoint = false;
    public final String mteName;
    public boolean highlighted = true;

    public PowerfailLocationWrapper(GTPowerfailTracker.Powerfail powerfail) {
        this.powerfail = powerfail;
        this.mteName = powerfail.getMTEName().toLowerCase();
    }

    public Waypoint toWaypoint() {
        return new Waypoint(this.powerfail.x, this.powerfail.y, this.powerfail.z, this.powerfail.dim, this.powerfail.toSummary().toString(), 0xFF3333);
    }

    public boolean isActiveAsWaypoint() {
        return this.activeAsWaypoint;
    }

    public void onWaypointCleared() {
        this.activeAsWaypoint = false;
    }

    public void onWaypointUpdated(Waypoint waypoint) {
        this.activeAsWaypoint = waypoint.dimensionId == this.powerfail.dim && waypoint.blockX == this.powerfail.x && waypoint.blockZ == this.powerfail.z;
    }

    public int getDimensionId() {
        return this.powerfail.dim;
    }

    public double getBlockX() {
        return this.powerfail.x;
    }

    public double getBlockZ() {
        return this.powerfail.z;
    }
}

