/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.render.items;

import codechicken.lib.render.TextureUtils;
import com.mitchej123.hodgepodge.textures.IPatchedTextureAtlasSprite;
import gregtech.api.enums.Mods;
import gregtech.api.interfaces.IGT_ItemWithMaterialRenderer;
import gregtech.api.util.GTUtility;
import gregtech.common.render.GTRenderUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraftforge.client.IItemRenderer;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import org.lwjgl.opengl.GL11;

public class GeneratedMaterialRenderer
implements IItemRenderer {
    public boolean handleRenderType(ItemStack item, IItemRenderer.ItemRenderType type) {
        return type == IItemRenderer.ItemRenderType.EQUIPPED || type == IItemRenderer.ItemRenderType.EQUIPPED_FIRST_PERSON || type == IItemRenderer.ItemRenderType.INVENTORY || type == IItemRenderer.ItemRenderType.ENTITY;
    }

    public boolean shouldUseRenderHelper(IItemRenderer.ItemRenderType type, ItemStack item, IItemRenderer.ItemRendererHelper helper) {
        return type == IItemRenderer.ItemRenderType.ENTITY && helper == IItemRenderer.ItemRendererHelper.ENTITY_BOBBING || helper == IItemRenderer.ItemRendererHelper.ENTITY_ROTATION && Minecraft.func_71410_x().field_71474_y.field_74347_j;
    }

    public boolean renderFluidDisplayItem(IItemRenderer.ItemRenderType type, ItemStack aStack, Object ... data) {
        return false;
    }

    public void renderItem(IItemRenderer.ItemRenderType type, ItemStack aStack, Object ... data) {
        short aMetaData = (short)aStack.func_77960_j();
        Item item = aStack.func_77973_b();
        if (!(item instanceof IGT_ItemWithMaterialRenderer)) {
            return;
        }
        IGT_ItemWithMaterialRenderer aItem = (IGT_ItemWithMaterialRenderer)item;
        int passes = 1;
        if (aItem.requiresMultipleRenderPasses()) {
            passes = aItem.getRenderPasses(aMetaData);
        }
        for (int pass = 0; pass < passes; ++pass) {
            IIcon fluidIcon;
            IIcon tIcon = aItem.getIcon(aMetaData, pass);
            IIcon tOverlay = aItem.getOverlayIcon(aMetaData, pass);
            FluidStack aFluid = GTUtility.getFluidForFilledItem(aStack, true);
            GL11.glEnable((int)3042);
            GL11.glBlendFunc((int)770, (int)771);
            GL11.glEnable((int)3008);
            if (tIcon != null) {
                this.markNeedsAnimationUpdate(tIcon);
                this.renderRegularItem(type, aStack, tIcon, aFluid == null, pass, data);
            }
            if (tOverlay != null && aFluid != null && aFluid.getFluid() != null && (fluidIcon = aFluid.getFluid().getIcon(aFluid)) != null) {
                this.markNeedsAnimationUpdate(fluidIcon);
                this.renderContainedFluid(type, aFluid, fluidIcon);
            }
            if (tOverlay != null) {
                GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
                TextureUtils.bindAtlas((int)aItem.getSpriteNumber());
                this.markNeedsAnimationUpdate(tOverlay);
                this.renderItemOverlay(type, tOverlay);
            }
            GL11.glDisable((int)3042);
        }
    }

    protected void renderRegularItem(IItemRenderer.ItemRenderType type, ItemStack aStack, IIcon icon, boolean shouldModulateColor, int pass, Object ... data) {
        this.renderRegularItem(type, aStack, icon, shouldModulateColor);
    }

    protected void renderRegularItem(IItemRenderer.ItemRenderType type, ItemStack aStack, IIcon icon, boolean shouldModulateColor) {
        Item item = aStack.func_77973_b();
        if (!(item instanceof IGT_ItemWithMaterialRenderer)) {
            return;
        }
        IGT_ItemWithMaterialRenderer aItem = (IGT_ItemWithMaterialRenderer)item;
        if (shouldModulateColor) {
            short[] tModulation = aItem.getRGBa(aStack);
            GL11.glColor3f((float)((float)tModulation[0] / 255.0f), (float)((float)tModulation[1] / 255.0f), (float)((float)tModulation[2] / 255.0f));
        }
        GTRenderUtil.renderItem(type, icon);
    }

    protected void renderContainedFluid(IItemRenderer.ItemRenderType type, FluidStack aFluidStack, IIcon fluidIcon) {
        Fluid aFluid = aFluidStack.getFluid();
        int tColor = aFluid.getColor(aFluidStack);
        GL11.glColor3f((float)((float)(tColor >> 16 & 0xFF) / 255.0f), (float)((float)(tColor >> 8 & 0xFF) / 255.0f), (float)((float)(tColor & 0xFF) / 255.0f));
        TextureUtils.bindAtlas((int)aFluid.getSpriteNumber());
        GL11.glDepthFunc((int)514);
        GTRenderUtil.renderItem(type, fluidIcon);
        GL11.glDepthFunc((int)515);
    }

    protected void renderItemOverlay(IItemRenderer.ItemRenderType type, IIcon overlay) {
        GTRenderUtil.renderItem(type, overlay);
    }

    protected void markNeedsAnimationUpdate(IIcon icon) {
        if (Mods.HodgePodge.isModLoaded() && icon instanceof IPatchedTextureAtlasSprite) {
            ((IPatchedTextureAtlasSprite)icon).markNeedsAnimationUpdate();
        }
    }
}

