/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.gui.modularui.widget;

import com.gtnewhorizon.gtnhlib.util.parsing.MathExpressionParser;
import com.gtnewhorizons.modularui.api.drawable.IDrawable;
import com.gtnewhorizons.modularui.api.math.Alignment;
import com.gtnewhorizons.modularui.api.math.Color;
import com.gtnewhorizons.modularui.common.widget.textfield.TextFieldWidget;
import gregtech.api.gui.modularui.GTUITextures;
import gregtech.api.gui.modularui.ICoverDataFollowerWidget;
import gregtech.common.covers.Cover;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.client.gui.GuiScreen;

public class CoverDataFollowerTextFieldWidget<T extends Cover>
extends TextFieldWidget
implements ICoverDataFollowerWidget<T, String> {
    private Function<T, String> dataToStateGetter;

    public CoverDataFollowerTextFieldWidget() {
        this.setGetter(() -> "");
        this.setSynced(false, false);
        this.setTextColor(Color.WHITE.dark(1));
        this.setTextAlignment(Alignment.CenterLeft);
        this.setBackground(new IDrawable[]{GTUITextures.BACKGROUND_TEXT_FIELD.withOffset(-1.0f, -1.0f, 2.0f, 2.0f)});
    }

    @Override
    public void onPostInit() {
        super.onPostInit();
        if (this.focusOnGuiOpen) {
            this.shouldGetFocus();
        }
    }

    public CoverDataFollowerTextFieldWidget<T> setDataToStateGetter(Function<T, String> dataToStateGetter) {
        this.dataToStateGetter = dataToStateGetter;
        return this;
    }

    public CoverDataFollowerTextFieldWidget<T> setStateSetter(Consumer<String> setter) {
        super.setSetter(setter);
        return this;
    }

    @Override
    public void updateState(T data) {
        this.setText(this.dataToStateGetter.apply(data));
    }

    @Deprecated
    public CoverDataFollowerTextFieldWidget<T> setOnScrollNumbers(int baseStep, int ctrlStep, int shiftStep) {
        this.setOnScrollNumbers((val, direction) -> {
            int step = (GuiScreen.func_146272_n() ? shiftStep : (GuiScreen.func_146271_m() ? ctrlStep : baseStep)) * direction;
            try {
                val = Math.addExact(val, step);
            }
            catch (ArithmeticException ignored) {
                val = Integer.MAX_VALUE;
            }
            return val;
        });
        return this;
    }

    @Deprecated
    public CoverDataFollowerTextFieldWidget<T> setOnScrollNumbers() {
        return this.setOnScrollNumbers(1, 50, 1000);
    }

    @Deprecated
    public CoverDataFollowerTextFieldWidget<T> setOnScrollText(int baseStep, int ctrlStep, int shiftStep) {
        this.setOnScroll((text, direction) -> {
            int val = (int)MathExpressionParser.parse((String)text);
            int step = (GuiScreen.func_146272_n() ? shiftStep : (GuiScreen.func_146271_m() ? ctrlStep : baseStep)) * direction;
            try {
                val = Math.addExact(val, step);
            }
            catch (ArithmeticException ignored) {
                val = Integer.MAX_VALUE;
            }
            return this.getDecimalFormatter().format(val);
        });
        return this;
    }

    @Deprecated
    public CoverDataFollowerTextFieldWidget<T> setOnScrollText() {
        return this.setOnScrollText(1, 5, 50);
    }

    @Deprecated
    public CoverDataFollowerTextFieldWidget<T> setOnScrollNumbersLong(long baseStep, long ctrlStep, long shiftStep) {
        this.setOnScrollNumbersLong((val, direction) -> {
            long step = (GuiScreen.func_146272_n() ? shiftStep : (GuiScreen.func_146271_m() ? ctrlStep : baseStep)) * (long)direction.intValue();
            try {
                val = Math.addExact(val, step);
            }
            catch (ArithmeticException ignored) {
                val = Long.MAX_VALUE;
            }
            return val;
        });
        return this;
    }
}

