/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common;

import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.common.misc.GlobalVariableStorage;
import gregtech.common.misc.spaceprojects.SpaceProjectManager;
import java.util.UUID;
import tectech.mechanics.dataTransport.QuantumDataPacket;

public class WirelessComputationPacket {
    public boolean wirelessEnabled = false;
    private final long[] computationStored = new long[]{0L, 0L};
    private int currentIndex = 0;
    private long lastUpdateTick = -1L;

    private int uploadIndex() {
        return this.currentIndex;
    }

    private int downloadIndex() {
        return (this.currentIndex + 1) % 2;
    }

    public long getAvailableComputationStored() {
        return this.computationStored[this.downloadIndex()];
    }

    private QuantumDataPacket download(long dataIn, long aTick) {
        if (!this.wirelessEnabled) {
            return new QuantumDataPacket(0L);
        }
        if (this.lastUpdateTick < aTick) {
            this.update();
            this.lastUpdateTick = aTick;
        }
        if (this.getAvailableComputationStored() >= dataIn) {
            int n = this.downloadIndex();
            this.computationStored[n] = this.computationStored[n] - dataIn;
            return new QuantumDataPacket(dataIn);
        }
        return new QuantumDataPacket(0L);
    }

    private void update() {
        this.computationStored[this.downloadIndex()] = 0L;
        this.currentIndex = (this.currentIndex + 1) % 2;
    }

    private void setWirelessEnabled(boolean wirelessEnabled) {
        this.wirelessEnabled = wirelessEnabled;
    }

    private void upload(long dataOut, long aTick) {
        if (this.lastUpdateTick < aTick) {
            this.update();
            this.lastUpdateTick = aTick;
        }
        int n = this.uploadIndex();
        this.computationStored[n] = this.computationStored[n] + dataOut;
    }

    public static QuantumDataPacket downloadData(UUID userId, long dataIn, long aTick) {
        return WirelessComputationPacket.getPacketByUserId(userId).download(dataIn, aTick);
    }

    public static void uploadData(UUID userId, long dataOut, long aTick) {
        WirelessComputationPacket.getPacketByUserId(userId).upload(dataOut, aTick);
    }

    public static void enableWirelessNetWork(IGregTechTileEntity entity) {
        WirelessComputationPacket.getPacketByUserId(entity.getOwnerUuid()).setWirelessEnabled(true);
    }

    public static void disableWirelessNetWork(IGregTechTileEntity entity) {
        WirelessComputationPacket.getPacketByUserId(entity.getOwnerUuid()).setWirelessEnabled(false);
    }

    public static WirelessComputationPacket getPacketByUserId(UUID userId) {
        UUID team = SpaceProjectManager.getLeader(userId);
        if (GlobalVariableStorage.GlobalWirelessComputation.get(team) == null) {
            GlobalVariableStorage.GlobalWirelessComputation.put(team, new WirelessComputationPacket());
        }
        return GlobalVariableStorage.GlobalWirelessComputation.get(team);
    }
}

