/*
 * Decompiled with CFR 0.152.
 */
package bwcrossmod.openComputers;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import net.minecraft.nbt.NBTTagCompound;

public class GTNBTDataBase {
    private static final BiMap<NBTTagCompound, Long> tagIdBiMap = HashBiMap.create();
    private static final BiMap<GTNBTDataBase, Long> GTNBTBIMAP = HashBiMap.create();
    private static long maxID = -9223372036854775807L;
    private final NBTTagCompound tagCompound;
    private final String mDataName;
    private final String mDataTitle;
    private long id;

    GTNBTDataBase(String mDataName, String mDataTitle, NBTTagCompound tagCompound) {
        this.mDataName = mDataName;
        this.mDataTitle = mDataTitle;
        this.tagCompound = tagCompound;
        this.id = maxID++;
        tagIdBiMap.put((Object)tagCompound, (Object)this.id);
        GTNBTBIMAP.put((Object)this, (Object)this.id);
    }

    static GTNBTDataBase getGTTagFromId(Long id) {
        return (GTNBTDataBase)GTNBTBIMAP.inverse().get((Object)id);
    }

    static Long getIdFromGTTag(GTNBTDataBase tagCompound) {
        return (Long)GTNBTBIMAP.get((Object)tagCompound);
    }

    static NBTTagCompound getTagFromId(Long id) {
        return (NBTTagCompound)tagIdBiMap.inverse().get((Object)id);
    }

    static Long getIdFromTag(NBTTagCompound tagCompound) {
        return (Long)tagIdBiMap.get((Object)tagCompound);
    }

    public NBTTagCompound getTagCompound() {
        return this.tagCompound;
    }

    public String getmDataName() {
        return this.mDataName;
    }

    static long getMaxID() {
        return maxID;
    }

    public String getmDataTitle() {
        return this.mDataTitle;
    }

    public long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    private GTNBTDataBase(NBTTagCompound tagCompound, String mDataName, String mDataTitle, long id) {
        this.tagCompound = tagCompound;
        this.mDataName = mDataName;
        this.mDataTitle = mDataTitle;
        this.id = id;
    }

    public static GTNBTDataBase makeNewWithoutRegister(String mDataName, String mDataTitle, NBTTagCompound tagCompound) {
        return new GTNBTDataBase(tagCompound, mDataName, mDataTitle, Long.MIN_VALUE);
    }
}

