/*
 * Decompiled with CFR 0.152.
 */
package bartworks.common.tileentities.multis;

import bartworks.API.modularUI.BWUITextures;
import bartworks.API.recipe.BartWorksRecipeMaps;
import bartworks.system.material.CircuitGeneration.BWMetaItems;
import bartworks.system.material.CircuitGeneration.CircuitImprintLoader;
import com.gtnewhorizon.structurelib.alignment.constructable.ISurvivalConstructable;
import com.gtnewhorizon.structurelib.structure.IStructureDefinition;
import com.gtnewhorizon.structurelib.structure.ISurvivalBuildEnvironment;
import com.gtnewhorizon.structurelib.structure.StructureDefinition;
import com.gtnewhorizon.structurelib.structure.StructureUtility;
import com.gtnewhorizons.modularui.api.drawable.IDrawable;
import com.gtnewhorizons.modularui.api.screen.ModularWindow;
import com.gtnewhorizons.modularui.api.screen.UIBuildContext;
import com.gtnewhorizons.modularui.api.widget.Widget;
import com.gtnewhorizons.modularui.common.widget.CycleButtonWidget;
import com.gtnewhorizons.modularui.common.widget.FakeSyncWidget;
import gregtech.GTMod;
import gregtech.api.GregTechAPI;
import gregtech.api.enums.HatchElement;
import gregtech.api.enums.SoundResource;
import gregtech.api.enums.Textures;
import gregtech.api.gui.modularui.GTUITextures;
import gregtech.api.interfaces.IIconContainer;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.logic.ProcessingLogic;
import gregtech.api.metatileentity.implementations.MTEEnhancedMultiBlockBase;
import gregtech.api.metatileentity.implementations.MTEHatch;
import gregtech.api.metatileentity.implementations.MTEHatchInput;
import gregtech.api.metatileentity.implementations.MTEHatchInputBus;
import gregtech.api.recipe.RecipeMap;
import gregtech.api.recipe.RecipeMapBackend;
import gregtech.api.recipe.RecipeMaps;
import gregtech.api.recipe.check.CheckRecipeResult;
import gregtech.api.recipe.check.CheckRecipeResultRegistry;
import gregtech.api.recipe.check.SimpleCheckRecipeResult;
import gregtech.api.render.TextureFactory;
import gregtech.api.util.GTLanguageManager;
import gregtech.api.util.GTRecipe;
import gregtech.api.util.GTStructureUtility;
import gregtech.api.util.GTUtility;
import gregtech.api.util.MultiblockTooltipBuilder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;
import mcp.mobius.waila.api.IWailaConfigHandler;
import mcp.mobius.waila.api.IWailaDataAccessor;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import org.jetbrains.annotations.NotNull;

public class MTECircuitAssemblyLine
extends MTEEnhancedMultiBlockBase<MTECircuitAssemblyLine>
implements ISurvivalConstructable {
    private static final int CASING_INDEX = 16;
    private static final String STRUCTURE_PIECE_FIRST = "first";
    private static final String STRUCTURE_PIECE_NEXT = "next";
    private static final String STRUCTURE_PIECE_NEXT_HINT = "next_hint";
    private static final String STRUCTURE_PIECE_LAST = "last";
    private static final int MINIMUM_CIRCUIT_ASSEMBLER_LENGTH = 5;
    public static final String IMPRINT_KEY = "Type";
    protected static final String LENGTH_KEY = "Length";
    protected static final String RUNNING_MODE_KEY = "RunningMode";
    private int length;
    private Mode mode = Mode.CircuitAssemblyLine;
    private int glassTier = -1;
    private String imprintedItemName;
    private ItemStack imprintedStack;
    private static final IStructureDefinition<MTECircuitAssemblyLine> STRUCTURE_DEFINITION = StructureDefinition.builder().addShape("first", StructureUtility.transpose((String[][])new String[][]{{"~", "G", "G"}, {"g", "l", "g"}, {"b", "i", "b"}})).addShape("next", StructureUtility.transpose((String[][])new String[][]{{"G", "G", "G"}, {"g", "l", "g"}, {"b", "I", "b"}})).addShape("next_hint", StructureUtility.transpose((String[][])new String[][]{{"G", "G", "G"}, {"g", "l", "g"}, {"b", "i", "b"}})).addShape("last", StructureUtility.transpose((String[][])new String[][]{{"G", "G", "G"}, {"g", "l", "g"}, {"b", "o", "b"}})).addElement('G', GTStructureUtility.buildHatchAdder(MTECircuitAssemblyLine.class).atLeast(HatchElement.Energy).casingIndex(16).dot(1).buildAndChain(GregTechAPI.sBlockCasings3, 10)).addElement('g', GTStructureUtility.chainAllGlasses(-1, (te, t) -> {
        te.glassTier = t;
    }, te -> te.glassTier)).addElement('l', StructureUtility.ofBlock((Block)GregTechAPI.sBlockCasings2, (int)5)).addElement('b', GTStructureUtility.buildHatchAdder(MTECircuitAssemblyLine.class).atLeast(HatchElement.InputHatch, HatchElement.Maintenance).casingIndex(16).dot(2).disallowOnly(ForgeDirection.EAST, ForgeDirection.WEST).buildAndChain(GregTechAPI.sBlockCasings2, 0)).addElement('i', HatchElement.InputBus.newAny(16, 3, ForgeDirection.DOWN)).addElement('I', GTStructureUtility.buildHatchAdder(MTECircuitAssemblyLine.class).atLeast(HatchElement.InputHatch, HatchElement.InputBus, HatchElement.OutputBus).casingIndex(16).dot(2).disallowOnly(ForgeDirection.EAST, ForgeDirection.WEST).buildAndChain(GregTechAPI.sBlockCasings2, 0)).addElement('o', HatchElement.OutputBus.newAny(16, 2, ForgeDirection.DOWN)).build();
    private NBTTagCompound type = new NBTTagCompound();
    private String[] infoDataBuffer;

    @Override
    public IStructureDefinition<MTECircuitAssemblyLine> getStructureDefinition() {
        return STRUCTURE_DEFINITION;
    }

    @Override
    protected MultiblockTooltipBuilder createTooltip() {
        MultiblockTooltipBuilder tt = new MultiblockTooltipBuilder();
        tt.addMachineType("Circuit Assembler, CAL").addInfo("Change Mode with Screwdriver").addPerfectOCInfo().addSeparator().addInfo(EnumChatFormatting.GOLD + StatCollector.func_74838_a((String)"chat.cal.mode.0") + ":").addInfo("Imprint this machine with a Circuit Imprint,").addInfo("by putting the imprint in the controller").addInfo("Every Circuit Assembly Line can only be imprinted ONCE").addSeparator().addInfo(EnumChatFormatting.GOLD + StatCollector.func_74838_a((String)"chat.cal.mode.1") + ":").addInfo("Does Circuit Assembler recipes, Minimum Length: " + EnumChatFormatting.RED + 5 + EnumChatFormatting.GRAY).addInfo("Recipe tier in Circuit Assembler mode is at most Energy Hatch tier - 1").addInfo("This mode supports Crafting Input Buffer/Bus and allows bus separation").beginVariableStructureBlock(2, 7, 3, 3, 3, 3, false).addStructureInfo("From Bottom to Top, Left to Right").addStructureInfo("Layer 1 - Solid Steel Machine Casing, Input bus (Last Output bus), Solid Steel Machine Casing").addStructureInfo("Layer 2 - " + GTUtility.getColoredTierNameFromTier((byte)4) + "+ Tier Glass, Assembly Line Casing, " + GTUtility.getColoredTierNameFromTier((byte)4) + "+ Tier Glass").addStructureInfo("Layer 3 - Grate Machine Casing").addStructureInfo("Up to 7 repeating slices, last is Output Bus").addController("Layer 3 first slice front").addOtherStructurePart("1x " + StatCollector.func_74838_a((String)"GT5U.MBTT.EnergyHatch"), "Any layer 3 casing", 1).addInputHatch("Any layer 1 casing", 2).addInputBus("As specified on layer 1", 3, 4).addOutputBus("As specified in final slice on layer 1", 4).addOtherStructurePart(StatCollector.func_74837_a((String)"tooltip.bw.structure.tier_glass", (Object[])new Object[]{GTUtility.getColoredTierNameFromTier((byte)4)}), "As specified on layer 2", 5).addMaintenanceHatch("Any layer 1 casing", 2).toolTipFinisher(new String[0]);
        return tt;
    }

    private void switchMode() {
        Mode mode;
        switch (this.mode) {
            default: {
                throw new IncompatibleClassChangeError();
            }
            case CircuitAssembler: {
                mode = Mode.CircuitAssemblyLine;
                break;
            }
            case CircuitAssemblyLine: {
                mode = Mode.CircuitAssembler;
            }
        }
        this.mode = mode;
    }

    private void setMode(boolean value) {
        this.mode = value ? Mode.CircuitAssembler : Mode.CircuitAssemblyLine;
    }

    public String getTypeForDisplay() {
        if (!this.isImprinted()) {
            return "";
        }
        return GTLanguageManager.getTranslation(GTLanguageManager.getTranslateableItemStackName(CircuitImprintLoader.getStackFromTag(this.type)));
    }

    public MTECircuitAssemblyLine(int aID, String aName, String aNameRegional) {
        super(aID, aName, aNameRegional);
    }

    private MTECircuitAssemblyLine(String aName) {
        super(aName);
    }

    public boolean isImprinted() {
        return !this.type.func_82582_d();
    }

    private boolean imprintMachine(ItemStack itemStack) {
        if (this.isImprinted()) {
            return true;
        }
        if (!GTUtility.isStackValid(itemStack)) {
            return false;
        }
        if (itemStack.func_77973_b() instanceof BWMetaItems.BW_GT_MetaGenCircuits && itemStack.func_77960_j() == 0 && itemStack.func_77978_p() != null) {
            this.type = itemStack.func_77978_p();
            --itemStack.field_77994_a;
            if (itemStack == this.getControllerSlot() && itemStack.field_77994_a <= 0) {
                this.mInventory[this.getControllerSlotIndex()] = null;
            }
            this.getBaseMetaTileEntity().issueBlockUpdate();
            return true;
        }
        return false;
    }

    @Override
    public void startSoundLoop(byte aIndex, double aX, double aY, double aZ) {
        super.startSoundLoop(aIndex, aX, aY, aZ);
        if (aIndex == 20) {
            GTUtility.doSoundAtClient(SoundResource.GTCEU_LOOP_ASSEMBLER, 10, 1.0f, aX, aY, aZ);
        }
    }

    @Override
    public void loadNBTData(NBTTagCompound aNBT) {
        this.type = aNBT.func_74775_l(IMPRINT_KEY);
        this.imprintedItemName = this.type == null ? "" : GTLanguageManager.getTranslateableItemStackName(ItemStack.func_77949_a((NBTTagCompound)this.type));
        this.mode = Mode.fromIndex(aNBT.func_74762_e(RUNNING_MODE_KEY));
        if (aNBT.func_74764_b(LENGTH_KEY)) {
            this.length = aNBT.func_74762_e(LENGTH_KEY);
        }
        super.loadNBTData(aNBT);
    }

    @Override
    public void setItemNBT(NBTTagCompound aNBT) {
        if (this.isImprinted()) {
            aNBT.func_74782_a(IMPRINT_KEY, (NBTBase)this.type);
        }
        super.setItemNBT(aNBT);
    }

    @Override
    public void saveNBTData(NBTTagCompound aNBT) {
        if (this.isImprinted()) {
            aNBT.func_74782_a(IMPRINT_KEY, (NBTBase)this.type);
        }
        aNBT.func_74768_a(RUNNING_MODE_KEY, this.mode.index);
        aNBT.func_74768_a(LENGTH_KEY, this.length);
        super.saveNBTData(aNBT);
    }

    @Override
    public void onLeftclick(IGregTechTileEntity aBaseMetaTileEntity, EntityPlayer aPlayer) {
        ItemStack heldItem;
        if (this.mode == Mode.CircuitAssemblyLine && !this.isImprinted() && this.getBaseMetaTileEntity().isServerSide() && this.imprintMachine(heldItem = aPlayer.func_70694_bm())) {
            if (heldItem.field_77994_a <= 0) {
                aPlayer.field_71071_by.func_70299_a(aPlayer.field_71071_by.field_70461_c, null);
            }
            return;
        }
        super.onLeftclick(aBaseMetaTileEntity, aPlayer);
    }

    @Override
    public final void onScrewdriverRightClick(ForgeDirection side, EntityPlayer aPlayer, float aX, float aY, float aZ, ItemStack aTool) {
        if (this.getBaseMetaTileEntity().isServerSide()) {
            this.switchMode();
            GTUtility.sendChatToPlayer(aPlayer, StatCollector.func_74838_a((String)("chat.cal.mode." + this.mode.index)));
        }
        super.onScrewdriverRightClick(side, aPlayer, aX, aY, aZ, aTool);
    }

    @Override
    public RecipeMap<?> getRecipeMap() {
        RecipeMap<RecipeMapBackend> recipeMap;
        switch (this.mode) {
            default: {
                throw new IncompatibleClassChangeError();
            }
            case CircuitAssemblyLine: {
                recipeMap = BartWorksRecipeMaps.circuitAssemblyLineRecipes;
                break;
            }
            case CircuitAssembler: {
                recipeMap = RecipeMaps.circuitAssemblerRecipes;
            }
        }
        return recipeMap;
    }

    @Override
    @Nonnull
    public Collection<RecipeMap<?>> getAvailableRecipeMaps() {
        return Arrays.asList(BartWorksRecipeMaps.circuitAssemblyLineRecipes, RecipeMaps.circuitAssemblerRecipes);
    }

    @Override
    protected ProcessingLogic createProcessingLogic() {
        return new ProcessingLogic(){

            @Override
            @Nonnull
            protected CheckRecipeResult validateRecipe(@Nonnull GTRecipe recipe) {
                if (MTECircuitAssemblyLine.this.mode == Mode.CircuitAssembler && (long)recipe.mEUt > MTECircuitAssemblyLine.this.getMaxInputVoltage() / 4L) {
                    return CheckRecipeResultRegistry.NO_RECIPE;
                }
                return CheckRecipeResultRegistry.SUCCESSFUL;
            }
        }.enablePerfectOverclock();
    }

    @Override
    @NotNull
    public CheckRecipeResult checkProcessing() {
        switch (this.mode) {
            case CircuitAssemblyLine: {
                if (!this.isImprinted() && !this.imprintMachine(this.getControllerSlot())) {
                    return SimpleCheckRecipeResult.ofFailure("no_imprint");
                }
                if (this.imprintedItemName != null && this.imprintedStack != null) break;
                this.imprintedStack = new ItemStack((Item)BWMetaItems.getCircuitParts(), 1, 0);
                this.imprintedStack.func_77982_d(this.type);
                this.imprintedItemName = GTLanguageManager.getTranslateableItemStackName(this.imprintedStack);
                break;
            }
            case CircuitAssembler: {
                if (this.length >= 5) break;
                return SimpleCheckRecipeResult.ofFailure("not_enough_length");
            }
        }
        return super.checkProcessing();
    }

    @Override
    protected void setupProcessingLogic(ProcessingLogic logic) {
        super.setupProcessingLogic(logic);
        logic.setSpecialSlotItem(this.imprintedStack);
    }

    @Override
    protected SoundResource getProcessStartSound() {
        return SoundResource.GTCEU_LOOP_ASSEMBLER;
    }

    @Override
    public ArrayList<ItemStack> getStoredInputsForColor(Optional<Byte> color) {
        if (this.mode == Mode.CircuitAssembler) {
            return super.getStoredInputsForColor(color);
        }
        ArrayList<ItemStack> rList = new ArrayList<ItemStack>();
        block0: for (MTEHatchInputBus tHatch : GTUtility.validMTEList(this.mInputBusses)) {
            tHatch.mRecipeMap = this.getRecipeMap();
            for (int i = 0; i < tHatch.getBaseMetaTileEntity().func_70302_i_(); ++i) {
                if (tHatch.getBaseMetaTileEntity().func_70301_a(i) == null) continue;
                rList.add(tHatch.getBaseMetaTileEntity().func_70301_a(i));
                continue block0;
            }
        }
        return rList;
    }

    @Override
    public boolean addInputToMachineList(IGregTechTileEntity aTileEntity, int aBaseCasingIndex) {
        if (aTileEntity == null) {
            return false;
        }
        IMetaTileEntity aMetaTileEntity = aTileEntity.getMetaTileEntity();
        if (aMetaTileEntity instanceof MTEHatchInput) {
            ((MTEHatch)aMetaTileEntity).updateTexture(aBaseCasingIndex);
            ((MTEHatchInput)aMetaTileEntity).mRecipeMap = this.getRecipeMap();
            return this.mInputHatches.add((MTEHatchInput)aMetaTileEntity);
        }
        if (aMetaTileEntity instanceof MTEHatchInputBus) {
            ((MTEHatch)aMetaTileEntity).updateTexture(aBaseCasingIndex);
            ((MTEHatchInputBus)aMetaTileEntity).mRecipeMap = this.getRecipeMap();
            return this.mInputBusses.add((MTEHatchInputBus)aMetaTileEntity);
        }
        return false;
    }

    @Override
    public boolean addInputHatchToMachineList(IGregTechTileEntity aTileEntity, int aBaseCasingIndex) {
        if (aTileEntity == null) {
            return false;
        }
        IMetaTileEntity aMetaTileEntity = aTileEntity.getMetaTileEntity();
        if (!(aMetaTileEntity instanceof MTEHatchInput)) {
            return false;
        }
        ((MTEHatch)aMetaTileEntity).updateTexture(aBaseCasingIndex);
        ((MTEHatchInput)aMetaTileEntity).mRecipeMap = this.getRecipeMap();
        return this.mInputHatches.add((MTEHatchInput)aMetaTileEntity);
    }

    @Override
    public IMetaTileEntity newMetaEntity(IGregTechTileEntity iGregTechTileEntity) {
        return new MTECircuitAssemblyLine(this.mName);
    }

    @Override
    public String[] getInfoData() {
        if (this.infoDataBuffer != null) {
            return this.infoDataBuffer;
        }
        String[] oldInfo = super.getInfoData();
        this.infoDataBuffer = new String[oldInfo.length + 1];
        System.arraycopy(oldInfo, 0, this.infoDataBuffer, 0, oldInfo.length);
        this.infoDataBuffer[oldInfo.length] = StatCollector.func_74838_a((String)"tooltip.cal.imprintedWith") + " " + EnumChatFormatting.YELLOW + this.getTypeForDisplay();
        return this.infoDataBuffer;
    }

    @Override
    public ITexture[] getTexture(IGregTechTileEntity aBaseMetaTileEntity, ForgeDirection side, ForgeDirection facing, int aColorIndex, boolean aActive, boolean aRedstone) {
        if (side == facing) {
            if (aActive) {
                return new ITexture[]{Textures.BlockIcons.getCasingTextureForId(16), TextureFactory.builder().addIcon((IIconContainer)Textures.BlockIcons.OVERLAY_FRONT_ASSEMBLY_LINE_ACTIVE).extFacing().build(), TextureFactory.builder().addIcon((IIconContainer)Textures.BlockIcons.OVERLAY_FRONT_ASSEMBLY_LINE_ACTIVE_GLOW).extFacing().glow().build()};
            }
            return new ITexture[]{Textures.BlockIcons.getCasingTextureForId(16), TextureFactory.builder().addIcon((IIconContainer)Textures.BlockIcons.OVERLAY_FRONT_ASSEMBLY_LINE).extFacing().build(), TextureFactory.builder().addIcon((IIconContainer)Textures.BlockIcons.OVERLAY_FRONT_ASSEMBLY_LINE_GLOW).extFacing().glow().build()};
        }
        return new ITexture[]{Textures.BlockIcons.getCasingTextureForId(16)};
    }

    @Override
    public boolean checkMachine(IGregTechTileEntity aBaseMetaTileEntity, ItemStack aStack) {
        this.glassTier = -1;
        if (!this.checkPiece(STRUCTURE_PIECE_FIRST, 0, 0, 0)) {
            return false;
        }
        if (this.glassTier < 4) {
            return false;
        }
        return this.checkMachine(true) || this.checkMachine(false);
    }

    private boolean checkMachine(boolean leftToRight) {
        for (int i = 1; i < 7; ++i) {
            if (!this.checkPiece(STRUCTURE_PIECE_NEXT, leftToRight ? -i : i, 0, 0)) {
                return false;
            }
            this.length = i + 1;
            if (this.mOutputBusses.isEmpty()) continue;
            return this.mEnergyHatches.size() == 1 && this.mMaintenanceHatches.size() == 1;
        }
        return false;
    }

    public void construct(ItemStack stackSize, boolean hintsOnly) {
        this.buildPiece(STRUCTURE_PIECE_FIRST, stackSize, hintsOnly, 0, 0, 0);
        int tLength = Math.min(stackSize.field_77994_a + 1, 7);
        for (int i = 1; i < tLength; ++i) {
            this.buildPiece(STRUCTURE_PIECE_NEXT, stackSize, hintsOnly, -i, 0, 0);
        }
    }

    public int survivalConstruct(ItemStack stackSize, int elementBudget, ISurvivalBuildEnvironment env) {
        if (this.mMachine) {
            return -1;
        }
        int built = this.survivalBuildPiece(STRUCTURE_PIECE_FIRST, stackSize, 0, 0, 0, elementBudget, env, false, true);
        if (built >= 0) {
            return built;
        }
        int tLength = Math.min(stackSize.field_77994_a + 1, 7);
        for (int i = 1; i < tLength - 1; ++i) {
            built = this.survivalBuildPiece(STRUCTURE_PIECE_NEXT_HINT, stackSize, -i, 0, 0, elementBudget, env, false, true);
            if (built < 0) continue;
            return built;
        }
        return this.survivalBuildPiece(STRUCTURE_PIECE_LAST, stackSize, -(tLength - 1), 0, 0, elementBudget, env, false, true);
    }

    @Override
    public void addAdditionalTooltipInformation(ItemStack stack, List<String> tooltip) {
        if (stack.func_77942_o() && stack.field_77990_d.func_74764_b(IMPRINT_KEY)) {
            tooltip.add(StatCollector.func_74838_a((String)"tooltip.cal.imprintedWith") + " " + EnumChatFormatting.YELLOW + StatCollector.func_74838_a((String)GTLanguageManager.getTranslateableItemStackName(ItemStack.func_77949_a((NBTTagCompound)stack.field_77990_d.func_74775_l(IMPRINT_KEY)))));
        }
    }

    @Override
    public void addUIWidgets(ModularWindow.Builder builder, UIBuildContext buildContext) {
        super.addUIWidgets(builder, buildContext);
        builder.widget((Widget)new FakeSyncWidget.StringSyncer(() -> this.imprintedItemName, val -> {
            this.imprintedItemName = val;
        }));
        builder.widget(new CycleButtonWidget().setToggle(() -> this.mode == Mode.CircuitAssembler, this::setMode).setTextureGetter(state -> state == 1 ? BWUITextures.OVERLAY_BUTTON_ASSEMBLER_MODE : BWUITextures.OVERLAY_BUTTON_LINE_MODE).setBackground(new IDrawable[]{GTUITextures.BUTTON_STANDARD}).setPos(80, 91).setSize(16, 16).dynamicTooltip(() -> Collections.singletonList(StatCollector.func_74838_a((String)("chat.cal.mode." + this.mode.index)))).setUpdateTooltipEveryTick(true).setTooltipShowUpDelay(5));
    }

    @Override
    public boolean supportsVoidProtection() {
        return true;
    }

    @Override
    public boolean supportsBatchMode() {
        return true;
    }

    @Override
    protected boolean supportsSlotAutomation(int aSlot) {
        return aSlot == this.getControllerSlotIndex();
    }

    @Override
    public boolean onWireCutterRightClick(ForgeDirection side, ForgeDirection wrenchingSide, EntityPlayer aPlayer, float aX, float aY, float aZ, ItemStack aTool) {
        if (!aPlayer.func_70093_af()) {
            if (this.mode == Mode.CircuitAssemblyLine) {
                return false;
            }
            this.inputSeparation = !this.inputSeparation;
            GTUtility.sendChatToPlayer(aPlayer, StatCollector.func_74838_a((String)"GT5U.machines.separatebus") + " " + this.inputSeparation);
        } else {
            boolean bl = this.batchMode = !this.batchMode;
            if (this.batchMode) {
                GTUtility.sendChatToPlayer(aPlayer, StatCollector.func_74838_a((String)"misc.BatchModeTextOn"));
            } else {
                GTUtility.sendChatToPlayer(aPlayer, StatCollector.func_74838_a((String)"misc.BatchModeTextOff"));
            }
        }
        return true;
    }

    @Override
    public boolean supportsInputSeparation() {
        boolean bl;
        if (this.mode == null) {
            return false;
        }
        switch (this.mode) {
            default: {
                throw new IncompatibleClassChangeError();
            }
            case CircuitAssemblyLine: {
                bl = false;
                break;
            }
            case CircuitAssembler: {
                bl = true;
            }
        }
        return bl;
    }

    @Override
    public boolean supportsSingleRecipeLocking() {
        return true;
    }

    @Override
    public boolean isInputSeparationEnabled() {
        return this.mode == Mode.CircuitAssembler && super.isInputSeparationEnabled();
    }

    @Override
    public void getWailaBody(ItemStack itemStack, List<String> currenttip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
        super.getWailaBody(itemStack, currenttip, accessor, config);
        NBTTagCompound tag = accessor.getNBTData();
        currenttip.add(StatCollector.func_74838_a((String)"GT5U.multiblock.runningMode") + " " + EnumChatFormatting.WHITE + StatCollector.func_74838_a((String)("chat.cal.mode." + tag.func_74762_e(RUNNING_MODE_KEY))));
        if (tag.func_74764_b("ImprintedWith") && tag.func_74762_e(RUNNING_MODE_KEY) == 0) {
            currenttip.add(StatCollector.func_74838_a((String)"tooltip.cal.imprintedWith") + " " + EnumChatFormatting.YELLOW + tag.func_74779_i("ImprintedWith"));
        }
    }

    @Override
    public void getWailaNBTData(EntityPlayerMP player, TileEntity tile, NBTTagCompound tag, World world, int x, int y, int z) {
        super.getWailaNBTData(player, tile, tag, world, x, y, z);
        String imprintedWith = this.getTypeForDisplay();
        if (!imprintedWith.isEmpty()) {
            tag.func_74778_a("ImprintedWith", imprintedWith);
        }
        tag.func_74768_a(RUNNING_MODE_KEY, this.mode.index);
    }

    @Override
    protected boolean supportsCraftingMEBuffer() {
        boolean bl;
        switch (this.mode) {
            default: {
                throw new IncompatibleClassChangeError();
            }
            case CircuitAssemblyLine: {
                bl = false;
                break;
            }
            case CircuitAssembler: {
                bl = true;
            }
        }
        return bl;
    }

    private static enum Mode {
        CircuitAssemblyLine(0),
        CircuitAssembler(1);

        private final int index;

        private Mode(int index) {
            this.index = index;
        }

        @NotNull
        private static Mode fromIndex(int index) {
            Mode mode;
            switch (index) {
                case 0: {
                    mode = CircuitAssemblyLine;
                    break;
                }
                case 1: {
                    mode = CircuitAssembler;
                    break;
                }
                default: {
                    GTMod.GT_FML_LOGGER.error("Invalid mode for Circuit Assembly Line. Falling back to default.");
                    mode = CircuitAssemblyLine;
                }
            }
            return mode;
        }
    }
}

