/*
 * Decompiled with CFR 0.152.
 */
package chylex.hee.world.structure.island.biome.feature.mountains;

import chylex.hee.system.collections.WeightedList;
import chylex.hee.system.collections.weight.IWeightProvider;
import chylex.hee.system.collections.weight.ObjectWeightPair;
import chylex.hee.system.util.MathUtil;
import chylex.hee.world.structure.island.biome.IslandBiomeBurningMountains;
import chylex.hee.world.structure.island.biome.data.IslandBiomeData;
import chylex.hee.world.structure.island.biome.feature.AbstractIslandStructure;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;

public class StructureMiningSpot
extends AbstractIslandStructure {
    private WeightedList<ObjectWeightPair<Block>> oreWeights;
    private byte iterationsLeft;

    public void regenerateOreWeightList(Random rand, IslandBiomeData biomeData) {
        this.oreWeights = new WeightedList((IWeightProvider[])new ObjectWeightPair[]{ObjectWeightPair.of(Blocks.field_150412_bA, 8), ObjectWeightPair.of(Blocks.field_150369_x, 8), ObjectWeightPair.of(Blocks.field_150450_ax, 11), ObjectWeightPair.of(Blocks.field_150482_ag, 14), ObjectWeightPair.of(Blocks.field_150365_q, 20), ObjectWeightPair.of(Blocks.field_150352_o, 25), ObjectWeightPair.of(Blocks.field_150366_p, 26)});
        if (biomeData.hasDeviation(IslandBiomeBurningMountains.LIMITED_ORES)) {
            WeightedList selected = new WeightedList((IWeightProvider[])new ObjectWeightPair[0]);
            for (int a = 0; a < 3 + rand.nextInt(2); ++a) {
                selected.add(this.oreWeights.removeRandomItem(rand));
            }
            this.oreWeights = selected;
        } else {
            for (int a = 0; a < 1 + rand.nextInt(2); ++a) {
                this.oreWeights.remove(rand.nextInt(this.oreWeights.size()));
            }
        }
    }

    @Override
    protected boolean generate(Random rand) {
        if (this.oreWeights == null) {
            this.regenerateOreWeightList(rand, this.biomeData);
        }
        int x = this.getRandomXZ(rand, 32);
        int z = this.getRandomXZ(rand, 32);
        int y = 15 - rand.nextInt(2) * rand.nextInt(14) + rand.nextInt(15 + rand.nextInt(35));
        if (this.world.getBlock(x, y, z) != Blocks.field_150377_bs) {
            return false;
        }
        double rad = 1.6 + rand.nextDouble() * 0.7;
        this.iterationsLeft = (byte)(70 + rand.nextInt(110));
        this.generateBlob(rand, x, y, z, rad, 0);
        return true;
    }

    private void generateBlob(Random rand, int x, int y, int z, double rad, int recursionLevel) {
        if ((double)x <= rad || (double)z <= rad || (double)x >= 208.0 - rad || (double)z >= 208.0 - rad || (double)y <= rad) {
            return;
        }
        if (this.iterationsLeft == 0 || (this.iterationsLeft = (byte)(this.iterationsLeft - 1)) == 0 || recursionLevel > 35 || recursionLevel > 12 && rand.nextInt(60 - Math.min(recursionLevel * 2, 50)) == 0) {
            return;
        }
        int xx = MathUtil.floor((double)x - rad) - 1;
        while ((double)xx <= (double)x + rad + 1.0) {
            int yy = MathUtil.floor((double)y - rad) - 1;
            while ((double)yy <= (double)y + rad + 1.0) {
                if (yy > 0) {
                    int zz = MathUtil.floor((double)z - rad) - 1;
                    while ((double)zz <= (double)z + rad + 1.0) {
                        double dist = MathUtil.distance(xx - x, yy - y, zz - z);
                        if (this.world.getBlock(xx, yy, zz) == Blocks.field_150377_bs && rand.nextInt(7) <= 1 && dist <= rad - rand.nextDouble() * 0.3) {
                            this.placeBlock(rand, xx, yy, zz, dist / rad);
                        }
                        ++zz;
                    }
                }
                ++yy;
            }
            ++xx;
        }
        if (rand.nextInt(6 + recursionLevel * 3) == 0) {
            this.generateBlob(rand, x + rand.nextInt(3) - rand.nextInt(3), y + rand.nextInt(3) - rand.nextInt(3), z + rand.nextInt(3) - rand.nextInt(3), rad, recursionLevel + 1);
        }
        this.generateBlob(rand, x + rand.nextInt(3) - rand.nextInt(3), y + rand.nextInt(3) - rand.nextInt(3), z + rand.nextInt(3) - rand.nextInt(3), rad, recursionLevel);
    }

    private void placeBlock(Random rand, int x, int y, int z, double distPercent) {
        if (rand.nextBoolean() && rand.nextBoolean() && rand.nextDouble() > distPercent - 0.2 - rand.nextDouble() * 0.25) {
            this.world.setBlock(x, y, z, this.oreWeights.getRandomItem(rand).getObject());
        } else if (rand.nextBoolean()) {
            this.world.setBlock(x, y, z, Blocks.field_150348_b);
        }
    }
}

