/*
 * Decompiled with CFR 0.152.
 */
package chylex.hee.world.structure.island.biome.feature.mountains;

import chylex.hee.block.BlockDungeonPuzzle;
import chylex.hee.init.BlockList;
import chylex.hee.system.util.MathUtil;
import chylex.hee.world.structure.island.biome.feature.AbstractIslandStructure;
import chylex.hee.world.structure.island.gen.CaveGenerator;
import chylex.hee.world.util.Direction;
import java.util.Random;
import net.minecraft.init.Blocks;
import net.minecraft.util.Vec3;

public class StructureDungeonPuzzle
extends AbstractIslandStructure {
    private static final byte[] checkX = new byte[]{-1, -1, 1, 1};
    private static final byte[] checkZ = new byte[]{-1, 1, -1, 1};

    @Override
    protected boolean generate(Random rand) {
        int xSize = 7 + 2 * rand.nextInt(4);
        int zSize = 7 + 2 * rand.nextInt(4);
        if (xSize == 7) {
            xSize = 7 + 2 * rand.nextInt(4);
        }
        if (zSize == 7) {
            zSize = 7 + 2 * rand.nextInt(4);
        }
        int checkMpX = 1 + (xSize >> 1);
        int checkMpZ = 1 + (zSize >> 1);
        int distX = xSize >> 1;
        int distZ = zSize >> 1;
        for (int attempt = 0; attempt < 500; ++attempt) {
            int posZ;
            int posX;
            int posZ2;
            int posZ3;
            int posX2;
            int a;
            int zz;
            boolean canGenerate = true;
            boolean foundAir = false;
            int xx = this.getRandomXZ(rand, 32);
            int yy = this.world.getHighestY(xx, zz = this.getRandomXZ(rand, 32));
            if (yy == 0) continue;
            for (a = 0; a < 4; ++a) {
                int topY = this.world.getHighestY(xx + checkX[a] * checkMpX, zz + checkZ[a] * checkMpZ);
                if (Math.abs(topY - yy) > 5) {
                    canGenerate = false;
                    break;
                }
                if (topY >= yy) continue;
                yy = topY;
            }
            if (!canGenerate || (yy -= 8 - rand.nextInt(20) - (attempt > 140 ? rand.nextInt(20) : 0)) < 0) continue;
            for (a = 0; a < 4; ++a) {
                if (!this.world.isAir(xx + checkX[a] * checkMpX, yy - 1, zz + checkZ[a] * checkMpZ) && !this.world.isAir(xx + checkX[a] * checkMpX, yy + 6, zz + checkZ[a] * checkMpZ)) continue;
                canGenerate = false;
                break;
            }
            if (!canGenerate) continue;
            float airX = 0.0f;
            float airY = 0.0f;
            float airZ = 0.0f;
            for (int airAttempt = 0; airAttempt < 60; ++airAttempt) {
                airX = xx + rand.nextInt(31) - 15;
                airY = yy + rand.nextInt(8) - 2;
                airZ = zz + rand.nextInt(31) - 15;
                if (MathUtil.distance(airX - (float)xx, airZ - (float)zz) < 10.0 || !this.world.isAir(MathUtil.floor(airX), MathUtil.floor(airY), MathUtil.floor(airZ))) continue;
                foundAir = true;
                break;
            }
            if (!foundAir) continue;
            for (int posY = yy; posY < yy + 5; ++posY) {
                boolean genRock = posY > yy && posY < yy + 4;
                for (posX2 = xx - distX; posX2 <= xx + distX; ++posX2) {
                    this.world.setBlock(posX2, posY, zz - distZ, BlockList.dungeon_puzzle, genRock && rand.nextInt(24) == 0 ? 14 : 13);
                    this.world.setBlock(posX2, posY, zz + distZ, BlockList.dungeon_puzzle, genRock && rand.nextInt(24) == 0 ? 14 : 13);
                }
                for (posZ3 = zz - distZ; posZ3 <= zz + distZ; ++posZ3) {
                    this.world.setBlock(xx - distX, posY, posZ3, BlockList.dungeon_puzzle, genRock && rand.nextInt(24) == 0 ? 14 : 13);
                    this.world.setBlock(xx + distX, posY, posZ3, BlockList.dungeon_puzzle, genRock && rand.nextInt(24) == 0 ? 14 : 13);
                }
                if (posY <= yy || posY >= yy + 4) continue;
                for (posX2 = xx - distX + 1; posX2 <= xx + distX - 1; ++posX2) {
                    for (posZ2 = zz - distZ + 1; posZ2 <= zz + distZ - 1; ++posZ2) {
                        this.world.setBlock(posX2, posY, posZ2, Blocks.field_150350_a);
                    }
                }
            }
            for (int posX3 = xx - distX + 1; posX3 <= xx + distX - 1; ++posX3) {
                for (posZ3 = zz - distZ + 1; posZ3 <= zz + distZ - 1; ++posZ3) {
                    this.world.setBlock(posX3, yy + 4, posZ3, BlockList.dungeon_puzzle, 15);
                    int meta = posX3 == xx - distX + 1 || posX3 == xx + distX - 1 || posZ3 == zz - distZ + 1 || posZ3 == zz + distZ - 1 ? this.pickBlock(2, rand) : this.pickBlock(0, rand);
                    this.world.setBlock(posX3, yy, posZ3, BlockList.dungeon_puzzle, meta);
                }
            }
            int amt = 3 + rand.nextInt(5);
            for (int a2 = 0; a2 < amt + rand.nextInt(4 + rand.nextInt(10)); ++a2) {
                if (rand.nextBoolean()) {
                    posX2 = rand.nextBoolean() ? xx + distX - 1 : xx - distX + 1;
                    posZ2 = zz + rand.nextInt(distZ * 2 + 1) - distZ;
                } else {
                    posX2 = xx + rand.nextInt(distX * 2 + 1) - distX;
                    posZ2 = rand.nextBoolean() ? zz + distZ - 1 : zz - distZ + 1;
                }
                this.world.setBlock(posX2, yy, posZ2, BlockList.dungeon_puzzle, this.pickBlock(0, rand));
            }
            boolean[] foundTriggerable = new boolean[4];
            for (int posX4 = xx - distX + 1; posX4 <= xx + distX - 1; ++posX4) {
                if (BlockDungeonPuzzle.getUnlit(this.world.getMetadata(posX4, yy, zz - distZ + 1)) == 0) {
                    foundTriggerable[0] = true;
                }
                if (BlockDungeonPuzzle.getUnlit(this.world.getMetadata(posX4, yy, zz + distZ - 1)) != 0) continue;
                foundTriggerable[1] = true;
            }
            for (int posZ4 = zz - distZ + 1; posZ4 <= zz + distZ - 1; ++posZ4) {
                if (BlockDungeonPuzzle.getUnlit(this.world.getMetadata(xx - distX + 1, yy, posZ4)) == 0) {
                    foundTriggerable[2] = true;
                }
                if (BlockDungeonPuzzle.getUnlit(this.world.getMetadata(xx + distX - 1, yy, posZ4)) != 0) continue;
                foundTriggerable[3] = true;
            }
            if (!foundTriggerable[0]) {
                this.world.setBlock(xx + rand.nextInt(distX * 2 + 1) - distX, yy, zz - distZ + 1, BlockList.dungeon_puzzle, this.pickBlock(0, rand));
            }
            if (!foundTriggerable[1]) {
                this.world.setBlock(xx + rand.nextInt(distX * 2 + 1) - distX, yy, zz + distZ - 1, BlockList.dungeon_puzzle, this.pickBlock(0, rand));
            }
            if (!foundTriggerable[2]) {
                this.world.setBlock(xx - distX + 1, yy, zz + rand.nextInt(distZ * 2 + 1) - distZ, BlockList.dungeon_puzzle, this.pickBlock(0, rand));
            }
            if (!foundTriggerable[3]) {
                this.world.setBlock(xx + distX - 1, yy, zz + rand.nextInt(distZ * 2 + 1) - distZ, BlockList.dungeon_puzzle, this.pickBlock(0, rand));
            }
            amt = 3 + rand.nextInt(4 + rand.nextInt(xSize * zSize > 90 ? 5 : 3));
            for (int distrAttempt = amt * 3; distrAttempt > 0 && amt > 0; --distrAttempt) {
                posX = xx + rand.nextInt(distX * 2 + 1) - distX;
                posZ = zz + rand.nextInt(distZ * 2 + 1) - distZ;
                int meta = BlockDungeonPuzzle.getUnlit(this.world.getMetadata(posX, yy, posZ));
                int type = rand.nextInt(2);
                if (meta != 0 && (meta != 2 || rand.nextInt(5) <= 2)) continue;
                boolean stop = false;
                for (int dir = 0; dir < 4; ++dir) {
                    int adjMeta = BlockDungeonPuzzle.getUnlit(this.world.getMetadata(posX + Direction.offsetX[dir], yy, posZ + Direction.offsetZ[dir]));
                    if (adjMeta != 4 && adjMeta != 6) continue;
                    stop = true;
                    break;
                }
                if (stop) continue;
                if (type == 0) {
                    int nextX = Integer.MIN_VALUE;
                    int nextZ = Integer.MIN_VALUE;
                    for (int px = xx - distX + 1; px <= xx + distX - 1; ++px) {
                        if (px == posX || BlockDungeonPuzzle.getUnlit(this.world.getMetadata(px, yy, posZ)) != 4) continue;
                        nextX = px;
                        break;
                    }
                    for (int pz = zz - distZ + 1; pz <= zz + distZ - 1; ++pz) {
                        if (pz == posZ || BlockDungeonPuzzle.getUnlit(this.world.getMetadata(posX, yy, zz)) != 4) continue;
                        nextZ = pz;
                        break;
                    }
                    if (nextX != Integer.MIN_VALUE && nextZ != Integer.MIN_VALUE && BlockDungeonPuzzle.getUnlit(this.world.getMetadata(nextX, yy, nextZ)) == 4) continue;
                }
                this.world.setBlock(posX, yy, posZ, BlockList.dungeon_puzzle, this.pickBlock(type == 0 ? 4 : 6, rand));
            }
            amt = 1 + rand.nextInt(6 + (rand.nextInt(xSize * 2 + zSize * 2) >> 3)) + (MathUtil.square(xSize) >> 4) + (MathUtil.square(zSize) >> 4);
            for (int chainAttempt = amt * 3; chainAttempt > 0 && amt > 0; --chainAttempt) {
                posX = xx + rand.nextInt(distX * 2 + 1) - distX;
                if (BlockDungeonPuzzle.getUnlit(this.world.getMetadata(posX, yy, posZ = zz + rand.nextInt(distZ * 2 + 1) - distZ)) != 0) continue;
                boolean canSpawn = true;
                int adjacentNonTrig = 0;
                for (int dir = 0; dir < 4; ++dir) {
                    int adjMeta = BlockDungeonPuzzle.getUnlit(this.world.getMetadata(posX + Direction.offsetX[dir], yy, posZ + Direction.offsetZ[dir]));
                    if ((adjMeta != 2 || ++adjacentNonTrig <= 1) && adjMeta == 0) continue;
                    canSpawn = false;
                    break;
                }
                if (!canSpawn) continue;
                --amt;
                if (rand.nextInt(3) != 0) continue;
                --amt;
            }
            Vec3 caveVec = Vec3.func_72443_a((double)((float)xx - airX), (double)((float)yy - airY), (double)((float)zz - airZ)).func_72432_b();
            int iterLimiter = 0;
            int add = 1 + rand.nextInt(4);
            int brokenDungBlocks = 0;
            yy += add;
            do {
                float rad = rand.nextFloat() * 0.3f + 1.9f;
                int intrad = MathUtil.ceil(rad);
                int px = MathUtil.floor(airX - (float)intrad);
                while ((float)px <= airX + (float)intrad) {
                    int py = MathUtil.floor(airY - (float)intrad);
                    while ((float)py <= airY + (float)intrad) {
                        int pz = MathUtil.floor(airZ - (float)intrad);
                        while ((float)pz <= airZ + (float)intrad) {
                            if (CaveGenerator.getDistance((int)((float)px - airX), (int)((float)py - airY), (int)((float)pz - airZ)) < (double)(rad + rand.nextFloat() * 0.35f)) {
                                if (this.world.getBlock(px, py, pz) == BlockList.dungeon_puzzle) {
                                    ++brokenDungBlocks;
                                }
                                this.world.setBlock(px, py, pz, Blocks.field_150350_a);
                            }
                            ++pz;
                        }
                        ++py;
                    }
                    ++px;
                }
            } while (!(MathUtil.distance((float)xx - (airX = (float)((double)airX + caveVec.field_72450_a * 0.6)), (float)yy - (airY = (float)((double)airY + caveVec.field_72448_b * 0.6)), (float)zz - (airZ = (float)((double)airZ + caveVec.field_72449_c * 0.6))) < 4.8) && brokenDungBlocks <= 4 && ++iterLimiter <= 30);
            yy -= add;
            return true;
        }
        return false;
    }

    private int pickBlock(int meta, Random rand) {
        return rand.nextInt(9) < 7 ? BlockDungeonPuzzle.getUnlit(meta) : BlockDungeonPuzzle.toggleState(BlockDungeonPuzzle.getUnlit(meta));
    }
}

