/*
 * Decompiled with CFR 0.152.
 */
package chylex.hee.system.collections;

import chylex.hee.HardcoreEnderExpansion;
import chylex.hee.system.collections.weight.IWeightProvider;
import chylex.hee.system.collections.weight.ObjectWeightPair;
import chylex.hee.system.commands.HeeDebugCommand;
import gnu.trove.map.hash.TObjectIntHashMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Random;

public class WeightedList<T extends IWeightProvider>
extends ArrayList<T> {
    private static final long serialVersionUID = -382485527777212023L;
    protected int totalWeight;
    public static final HeeDebugCommand.HeeTest $debugTest = new HeeDebugCommand.HeeTest(){

        @Override
        public void run(String ... args) {
            WeightedList list = new WeightedList((IWeightProvider[])new ObjectWeightPair[0]);
            list.addAll(Arrays.asList(ObjectWeightPair.of("A", 50), ObjectWeightPair.of("B", 25), ObjectWeightPair.of("C", 10), ObjectWeightPair.of("D", 5), ObjectWeightPair.of("E", 5), ObjectWeightPair.of("F", 1)));
            TObjectIntHashMap freq = new TObjectIntHashMap();
            for (int a = 0; a < 5000; ++a) {
                freq.adjustOrPutValue((Object)((String)((ObjectWeightPair)list.getRandomItem(this.world.field_73012_v)).getObject()), 1, 1);
            }
            for (String key : freq.keySet()) {
                HardcoreEnderExpansion.notifications.report(key + " ... " + freq.get((Object)key));
            }
        }
    };

    public WeightedList(T ... weightedItems) {
        this.addAll((IWeightProvider[])weightedItems);
    }

    public WeightedList(WeightedList<T> weightedItemCollection) {
        this.addAll((Collection<? extends T>)weightedItemCollection);
    }

    @Override
    public boolean add(T obj) {
        this.totalWeight += obj.getWeight();
        return super.add(obj);
    }

    public WeightedList<T> addAll(T[] objArray) {
        for (T obj : objArray) {
            super.add(obj);
        }
        this.recalculateWeight();
        return this;
    }

    @Override
    public boolean addAll(Collection<? extends T> collection) {
        boolean b = super.addAll(collection);
        this.recalculateWeight();
        return b;
    }

    @Override
    public T remove(int index) {
        IWeightProvider is = (IWeightProvider)super.remove(index);
        this.totalWeight -= is.getWeight();
        return (T)is;
    }

    @Override
    public boolean remove(Object o) {
        boolean b = super.remove(o);
        if (b) {
            this.totalWeight -= ((IWeightProvider)o).getWeight();
        }
        return b;
    }

    public void recalculateWeight() {
        this.totalWeight = 0;
        for (IWeightProvider obj : this) {
            this.totalWeight += obj.getWeight();
        }
    }

    public T getRandomItem(Random rand) {
        if (this.totalWeight == 0) {
            return null;
        }
        int i = rand.nextInt(this.totalWeight);
        for (IWeightProvider obj : this) {
            if ((i -= obj.getWeight()) >= 0) continue;
            return (T)obj;
        }
        return null;
    }

    public T removeRandomItem(Random rand) {
        T item = this.getRandomItem(rand);
        this.remove(item);
        return item;
    }
}

