/*
 * Decompiled with CFR 0.152.
 */
package ganymedes01.etfuturum.core.handlers;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.Lists;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.common.eventhandler.EventPriority;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.relauncher.ReflectionHelper;
import cpw.mods.fml.relauncher.Side;
import ganymedes01.etfuturum.EtFuturum;
import ganymedes01.etfuturum.ModBlocks;
import ganymedes01.etfuturum.ModEnchantments;
import ganymedes01.etfuturum.ModItems;
import ganymedes01.etfuturum.api.HoeRegistry;
import ganymedes01.etfuturum.api.RawOreRegistry;
import ganymedes01.etfuturum.api.StrippedLogRegistry;
import ganymedes01.etfuturum.api.mappings.RawOreDropMapping;
import ganymedes01.etfuturum.api.mappings.RegistryMapping;
import ganymedes01.etfuturum.blocks.BlockHoney;
import ganymedes01.etfuturum.blocks.BlockMagma;
import ganymedes01.etfuturum.client.sound.ModSounds;
import ganymedes01.etfuturum.compat.ExternalContent;
import ganymedes01.etfuturum.compat.ModsList;
import ganymedes01.etfuturum.configuration.configs.ConfigBlocksItems;
import ganymedes01.etfuturum.configuration.configs.ConfigEnchantsPotions;
import ganymedes01.etfuturum.configuration.configs.ConfigEntities;
import ganymedes01.etfuturum.configuration.configs.ConfigFunctions;
import ganymedes01.etfuturum.configuration.configs.ConfigMixins;
import ganymedes01.etfuturum.configuration.configs.ConfigSounds;
import ganymedes01.etfuturum.configuration.configs.ConfigTweaks;
import ganymedes01.etfuturum.configuration.configs.ConfigWorld;
import ganymedes01.etfuturum.core.utils.ItemStackMap;
import ganymedes01.etfuturum.core.utils.ItemStackSet;
import ganymedes01.etfuturum.core.utils.Utils;
import ganymedes01.etfuturum.elytra.IElytraEntityTrackerEntry;
import ganymedes01.etfuturum.elytra.IElytraPlayer;
import ganymedes01.etfuturum.entities.EntityBoostingFireworkRocket;
import ganymedes01.etfuturum.entities.EntityBrownMooshroom;
import ganymedes01.etfuturum.entities.EntityEndermite;
import ganymedes01.etfuturum.entities.EntityFox;
import ganymedes01.etfuturum.entities.EntityHusk;
import ganymedes01.etfuturum.entities.EntityLingeringEffect;
import ganymedes01.etfuturum.entities.EntityNewBoat;
import ganymedes01.etfuturum.entities.EntityNewSnowGolem;
import ganymedes01.etfuturum.entities.EntityRabbit;
import ganymedes01.etfuturum.entities.EntityShulker;
import ganymedes01.etfuturum.entities.EntityStray;
import ganymedes01.etfuturum.entities.EntityTippedArrow;
import ganymedes01.etfuturum.entities.EntityZombieVillager;
import ganymedes01.etfuturum.entities.ai.EntityAIOpenCustomDoor;
import ganymedes01.etfuturum.gamerule.DoWeatherCycle;
import ganymedes01.etfuturum.gamerule.PlayersSleepingPercentage;
import ganymedes01.etfuturum.gamerule.RandomTickSpeed;
import ganymedes01.etfuturum.items.ItemArrowTipped;
import ganymedes01.etfuturum.network.AttackYawMessage;
import ganymedes01.etfuturum.network.BlackHeartParticlesMessage;
import ganymedes01.etfuturum.recipes.ModRecipes;
import ganymedes01.etfuturum.spectator.SpectatorMode;
import ganymedes01.etfuturum.storage.EtFuturumPlayer;
import ganymedes01.etfuturum.tileentities.TileEntityGateway;
import ganymedes01.etfuturum.world.EtFuturumWorldListener;
import ganymedes01.etfuturum.world.nether.biome.utils.NetherBiomeManager;
import java.io.BufferedReader;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import net.minecraft.block.Block;
import net.minecraft.block.BlockEndPortalFrame;
import net.minecraft.block.BlockFarmland;
import net.minecraft.block.BlockLilyPad;
import net.minecraft.block.BlockRedstoneWire;
import net.minecraft.block.BlockSoulSand;
import net.minecraft.block.BlockTrapDoor;
import net.minecraft.block.IGrowable;
import net.minecraft.block.material.Material;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityFlying;
import net.minecraft.entity.EntityLeashKnot;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EntityTrackerEntry;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAIOpenDoor;
import net.minecraft.entity.ai.EntityAITargetNonTamed;
import net.minecraft.entity.ai.EntityAITasks;
import net.minecraft.entity.ai.EntityAITempt;
import net.minecraft.entity.boss.EntityWither;
import net.minecraft.entity.item.EntityBoat;
import net.minecraft.entity.item.EntityFallingBlock;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.item.EntityItemFrame;
import net.minecraft.entity.item.EntityPainting;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.monster.EntityEnderman;
import net.minecraft.entity.monster.EntitySkeleton;
import net.minecraft.entity.monster.EntitySnowman;
import net.minecraft.entity.monster.EntityWitch;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.passive.EntityChicken;
import net.minecraft.entity.passive.EntityCow;
import net.minecraft.entity.passive.EntityMooshroom;
import net.minecraft.entity.passive.EntityPig;
import net.minecraft.entity.passive.EntitySheep;
import net.minecraft.entity.passive.EntitySquid;
import net.minecraft.entity.passive.EntityTameable;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.entity.passive.EntityWolf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemBucket;
import net.minecraft.item.ItemHoe;
import net.minecraft.item.ItemPotion;
import net.minecraft.item.ItemShears;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemTool;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S29PacketSoundEffect;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.potion.PotionHelper;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityMobSpawner;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Direction;
import net.minecraft.util.EntityDamageSource;
import net.minecraft.util.EntityDamageSourceIndirect;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.StatCollector;
import net.minecraft.util.Vec3;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.IWorldAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldProviderHell;
import net.minecraft.world.WorldServer;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.ChunkProviderServer;
import net.minecraft.world.gen.structure.MapGenNetherBridge;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.event.FuelBurnTimeEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.EntityStruckByLightningEvent;
import net.minecraftforge.event.entity.item.ItemTossEvent;
import net.minecraftforge.event.entity.living.EnderTeleportEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingFallEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.living.LivingPackSizeEvent;
import net.minecraftforge.event.entity.living.LivingSpawnEvent;
import net.minecraftforge.event.entity.player.ArrowLooseEvent;
import net.minecraftforge.event.entity.player.ArrowNockEvent;
import net.minecraftforge.event.entity.player.AttackEntityEvent;
import net.minecraftforge.event.entity.player.BonemealEvent;
import net.minecraftforge.event.entity.player.EntityInteractEvent;
import net.minecraftforge.event.entity.player.FillBucketEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.entity.player.PlayerPickupXpEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.event.world.ChunkEvent;
import net.minecraftforge.event.world.ExplosionEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.oredict.OreDictionary;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.mutable.MutableFloat;

public class ServerEventHandler {
    public static final ServerEventHandler INSTANCE = new ServerEventHandler();
    public static HashSet<EntityPlayerMP> playersClosedContainers = new HashSet();
    private static final Map<EntityPlayer, List<ItemStack>> armorTracker = new WeakHashMap<EntityPlayer, List<ItemStack>>();
    private static final Set<EntityFallingBlock> fallingConcreteBlocks = new HashSet<EntityFallingBlock>();
    public static final Cache<EntityItem, EntityPlayer> droppedEntityItems = CacheBuilder.newBuilder().weakKeys().maximumSize(1000L).build();
    private final Set<Chunk> loadedChunks = Collections.newSetFromMap(new WeakHashMap());
    private final ThreadLocal<Integer> sideHit = new ThreadLocal();
    private Method addRandomArmorMethod;
    private Method enchantEquipmentMethod;
    private final Map<Class<? extends IChunkProvider>, Field[]> chunkProviderFieldsCache = new WeakHashMap<Class<? extends IChunkProvider>, Field[]>();
    private final Map<EntityPlayer, MutableFloat> lastAttackedAtYaw = new WeakHashMap<EntityPlayer, MutableFloat>();
    private final ItemStackSet noBurnItems = new ItemStackSet();
    private final ItemStackMap<Integer> burnTimeRemappings = new ItemStackMap();
    private final AtomicBoolean initNoBurnItems = new AtomicBoolean(false);
    private final AtomicBoolean initBurnTimeRemappings = new AtomicBoolean(false);

    private ServerEventHandler() {
    }

    @SubscribeEvent
    public void onPlayerPickXP(PlayerPickupXpEvent event) {
        ModEnchantments.onPlayerPickupXP(event);
    }

    @SubscribeEvent
    public void livingJump(LivingEvent.LivingJumpEvent event) {
        int z;
        int y;
        int x = MathHelper.func_76128_c((double)event.entity.field_70165_t);
        if (event.entity.field_70170_p.func_147439_a(x, y = MathHelper.func_76128_c((double)(event.entity.field_70163_u - (double)0.2f - (double)event.entity.field_70129_M)), z = MathHelper.func_76128_c((double)event.entity.field_70161_v)) instanceof BlockHoney) {
            event.entity.field_70181_x *= 0.5;
        }
    }

    @SubscribeEvent
    public void livingFall(LivingFallEvent event) {
        Entity entity = event.entity;
        if (entity instanceof EntityFox) {
            EntityFox fox = (EntityFox)entity;
            event.distance = fox.computeFallDistance(event.distance);
        }
    }

    @SubscribeEvent
    public void livingUpdate(LivingEvent.LivingUpdateEvent event) {
        EntityLivingBase entity = event.entityLiving;
        if (entity.field_70170_p == null) {
            return;
        }
        ModEnchantments.onLivingUpdate(entity);
        double x = entity.field_70165_t;
        double y = entity.field_70163_u;
        double z = entity.field_70161_v;
        if (ConfigBlocksItems.enableMagmaBlock && !entity.func_70045_F() && !entity.func_70093_af() && entity.field_70122_E && entity.field_70170_p.func_147439_a(MathHelper.func_76128_c((double)x), (int)(y - 0.45), MathHelper.func_76128_c((double)z)) == ModBlocks.MAGMA.get() && ConfigEnchantsPotions.enableFrostWalker && EnchantmentHelper.func_77506_a((int)ConfigEnchantsPotions.frostWalkerID, (ItemStack)entity.func_71124_b(1)) == 0) {
            entity.func_70097_a(BlockMagma.HOT_FLOOR, 1.0f);
        }
        if (ConfigMixins.stepHeightFix && entity.field_70138_W == 0.5f) {
            entity.field_70138_W = 0.6f;
        }
        if (ConfigMixins.enableElytra && entity instanceof IElytraPlayer) {
            ((IElytraPlayer)entity).tickElytra();
        }
        if (EntitySquid.class.equals(entity.getClass())) {
            EntitySquid sq = (EntitySquid)entity;
            if (ConfigEntities.enableSquidInk && "Nelly".equals(sq.func_94057_bL())) {
                Vec3 a = sq.func_70040_Z().func_72432_b();
                sq.field_70143_R = 0.0f;
                sq.func_70024_g(a.field_72450_a * 0.08, 0.08, a.field_72449_c * 0.08);
                sq.field_70181_x = 0.08;
                sq.field_70133_I = true;
            }
        }
        if (ConfigSounds.armorEquip && !entity.field_70170_p.field_72995_K && entity instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)entity;
            if (!(entity instanceof FakePlayer)) {
                if (!SpectatorMode.isSpectator(player)) {
                    if (!armorTracker.containsKey(player)) {
                        ItemStack playerBoots = player.func_71124_b(1);
                        ItemStack playerLeggings = player.func_71124_b(2);
                        ItemStack playerChestplate = player.func_71124_b(3);
                        ItemStack playerHelmet = player.func_71124_b(4);
                        armorTracker.put(player, Arrays.asList(playerBoots, playerLeggings, playerChestplate, playerHelmet));
                    } else {
                        List<ItemStack> armorList = armorTracker.get(player);
                        String itemEquippedSound = "";
                        for (int i = 0; i < 4; ++i) {
                            ItemStack storedArmor = armorList.get(i);
                            ItemStack currentArmor = player.func_71124_b(i + 1);
                            if (currentArmor != null && (storedArmor == null || !currentArmor.func_77973_b().equals(storedArmor.func_77973_b()) || currentArmor.field_77990_d == null && storedArmor.field_77990_d != null || currentArmor.field_77990_d != null && !currentArmor.field_77990_d.equals((Object)storedArmor.field_77990_d)) && player.field_71071_by.func_94041_b(i, currentArmor)) {
                                String armorString = currentArmor.func_77977_a().toLowerCase();
                                if (EtFuturum.stringListContainsPhrase(ConfigSounds.newArmorEquipCustomRulesNone, armorString)) continue;
                                if (armorString.contains("chain") || EtFuturum.stringListContainsPhrase(ConfigSounds.newArmorEquipCustomRulesChain, armorString)) {
                                    itemEquippedSound = "item.armor.equip_chain";
                                } else if (armorString.contains("diamond") || EtFuturum.stringListContainsPhrase(ConfigSounds.newArmorEquipCustomRulesDiamond, armorString)) {
                                    itemEquippedSound = "item.armor.equip_diamond";
                                } else if (armorString.contains("gold") || EtFuturum.stringListContainsPhrase(ConfigSounds.newArmorEquipCustomRulesGold, armorString)) {
                                    itemEquippedSound = "item.armor.equip_gold";
                                } else if (armorString.contains("iron") || EtFuturum.stringListContainsPhrase(ConfigSounds.newArmorEquipCustomRulesIron, armorString)) {
                                    itemEquippedSound = "item.armor.equip_iron";
                                } else if (armorString.contains("leather") || EtFuturum.stringListContainsPhrase(ConfigSounds.newArmorEquipCustomRulesLeather, armorString)) {
                                    itemEquippedSound = "item.armor.equip_leather";
                                } else if (armorString.contains("netherite") || EtFuturum.stringListContainsPhrase(ConfigSounds.newArmorEquipCustomRulesNetherite, armorString)) {
                                    itemEquippedSound = "item.armor.equip_netherite";
                                } else if (armorString.contains("elytra") || EtFuturum.stringListContainsPhrase(ConfigSounds.newArmorEquipCustomRulesElytra, armorString)) {
                                    itemEquippedSound = "item.armor.equip_elytra";
                                } else if (EtFuturum.stringListContainsPhrase(ConfigSounds.newArmorEquipCustomRulesTurtle, armorString)) {
                                    itemEquippedSound = "item.armor.equip_turtle";
                                } else if (currentArmor.func_77973_b() instanceof ItemArmor || EtFuturum.stringListContainsPhrase(ConfigSounds.newArmorEquipCustomRulesGeneric, armorString)) {
                                    itemEquippedSound = "item.armor.equip_generic";
                                }
                            }
                            armorList.set(i, currentArmor);
                            if (!itemEquippedSound.equals("")) break;
                        }
                        if (!itemEquippedSound.equals("")) {
                            player.field_70170_p.func_72956_a((Entity)player, "minecraft_1.21:" + itemEquippedSound, 1.0f, 1.0f);
                        }
                    }
                } else {
                    armorTracker.remove(player);
                }
            }
        }
    }

    @SubscribeEvent
    public void onAttackEntityEvent(AttackEntityEvent event) {
        if (!event.target.field_70170_p.field_72995_K) {
            Entity entity;
            if (ConfigSounds.paintingItemFramePlacing && (entity = event.target) instanceof EntityItemFrame) {
                EntityItemFrame itemframe = (EntityItemFrame)entity;
                if (itemframe.func_82335_i() != null) {
                    event.target.func_85030_a("minecraft_1.21:entity.item_frame.remove_item", 1.0f, 1.0f);
                } else {
                    event.target.func_85030_a("minecraft_1.21:entity.item_frame.break", 1.0f, 1.0f);
                }
            } else if (ConfigSounds.paintingItemFramePlacing && event.target instanceof EntityPainting) {
                event.target.func_85030_a("minecraft_1.21:entity.painting.break", 1.0f, 1.0f);
            } else if (ConfigSounds.leashSounds && event.target instanceof EntityLeashKnot) {
                event.target.func_85030_a("minecraft_1.21:entity.leash_knot.break", 1.0f, 1.0f);
            }
        }
    }

    @SubscribeEvent
    public void entityAdded(EntityJoinWorldEvent event) {
        if (event.world.field_72995_K) {
            return;
        }
        Chunk chunk = event.world.func_72964_e(MathHelper.func_76128_c((double)event.entity.field_70165_t) >> 4, MathHelper.func_76128_c((double)event.entity.field_70161_v) >> 4);
        String sound = "";
        if (ConfigSounds.paintingItemFramePlacing && event.entity instanceof EntityItemFrame) {
            sound = "item_frame";
        } else if (ConfigSounds.paintingItemFramePlacing && event.entity instanceof EntityPainting) {
            sound = "painting";
        } else if (ConfigSounds.leashSounds && event.entity instanceof EntityLeashKnot) {
            sound = "leash_knot";
        }
        if (!sound.equals("")) {
            event.world.func_72956_a(event.entity, "minecraft_1.21:entity." + sound + ".place", 1.0f, 1.0f);
            return;
        }
        if (ConfigBlocksItems.enableNewBoats && ConfigBlocksItems.replaceOldBoats && event.entity.getClass() == EntityBoat.class) {
            EntityNewBoat boat = new EntityNewBoat(event.world);
            event.entity.field_70177_z += 90.0f;
            this.replaceEntity(event.entity, boat, event.world, chunk);
            boat.setBoatType("minecraft", "oak");
            event.setCanceled(true);
            return;
        }
        if (ConfigEntities.enableVillagerZombies && event.entity.getClass() == EntityZombie.class && ((EntityZombie)event.entity).func_82231_m()) {
            this.replaceEntity(event.entity, (Entity)new EntityZombieVillager(event.world), event.world, chunk);
            event.setCanceled(true);
            return;
        }
        if (ConfigEntities.enableShearableSnowGolems && event.entity.getClass() == EntitySnowman.class) {
            EntityNewSnowGolem entity = new EntityNewSnowGolem(event.world);
            this.replaceEntity(event.entity, (Entity)entity, event.world, chunk);
            entity.func_70096_w().func_75692_b(12, (Object)1);
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void chunkLoad(ChunkEvent.Load event) {
        this.loadedChunks.add(event.getChunk());
    }

    @SubscribeEvent
    public void chunkUnload(ChunkEvent.Unload event) {
        this.loadedChunks.remove(event.getChunk());
    }

    private void replaceEntity(Entity oldEntity, Entity newEntity, World world, Chunk chunk) {
        newEntity.func_82141_a(oldEntity, true);
        if (this.loadedChunks.contains(chunk)) {
            world.func_72838_d(newEntity);
        } else {
            chunk.func_76612_a(newEntity);
        }
        oldEntity.func_70106_y();
    }

    @SubscribeEvent
    public void livingAttack(LivingAttackEvent event) {
        EntityDamageSourceIndirect dmgSrc;
        Entity entity;
        if (event.source == DamageSource.field_82727_n && event.entityLiving instanceof EntitySkeleton && ((EntitySkeleton)event.entityLiving).func_82202_m() == 1) {
            event.setCanceled(true);
            return;
        }
        DamageSource damageSource = event.source;
        if (damageSource instanceof EntityDamageSourceIndirect && (entity = (dmgSrc = (EntityDamageSourceIndirect)damageSource).func_76364_f()) instanceof EntityTippedArrow) {
            EntityTippedArrow tippedArrow = (EntityTippedArrow)entity;
            if (!tippedArrow.field_70170_p.field_72995_K && dmgSrc.func_76346_g() instanceof EntityLivingBase) {
                List<PotionEffect> list = ((ItemArrowTipped)ModItems.TIPPED_ARROW.get()).getEffects(tippedArrow.getArrow());
                for (PotionEffect potioneffect : list) {
                    int i = potioneffect.func_76456_a();
                    if (Potion.field_76425_a[i].func_76403_b()) {
                        Potion.field_76425_a[i].func_76402_a((EntityLivingBase)dmgSrc.func_76346_g(), event.entityLiving, potioneffect.func_76458_c(), 1.0);
                        continue;
                    }
                    event.entityLiving.func_70690_d(new PotionEffect(i, potioneffect.func_76459_b(), potioneffect.func_76458_c()));
                }
            }
        }
    }

    @SubscribeEvent
    public void arrowNock(ArrowNockEvent event) {
        if (event.result == null) {
            return;
        }
        InventoryPlayer invt = event.entityPlayer.field_71071_by;
        for (int i = 0; i < invt.func_70302_i_(); ++i) {
            ItemStack stack = invt.func_70301_a(i);
            if (stack == null || stack.field_77994_a <= 0) continue;
            if (stack.func_77973_b() == Items.field_151032_g) {
                return;
            }
            if (stack.func_77973_b() != ModItems.TIPPED_ARROW.get()) continue;
            event.setCanceled(true);
            event.entityPlayer.func_71008_a(event.result, event.result.func_77973_b().func_77626_a(event.result));
            return;
        }
    }

    @SubscribeEvent
    public void arrowLoose(ArrowLooseEvent event) {
        if (event.bow == null) {
            return;
        }
        InventoryPlayer invt = event.entityPlayer.field_71071_by;
        for (int i = 0; i < invt.func_70302_i_(); ++i) {
            int punch;
            int power;
            ItemStack arrow = invt.func_70301_a(i);
            if (arrow == null || arrow.field_77994_a <= 0 || arrow.func_77973_b() != ModItems.TIPPED_ARROW.get()) continue;
            float charge = (float)event.charge / 20.0f;
            if ((double)(charge = (charge * charge + charge * 2.0f) / 3.0f) < 0.1) {
                return;
            }
            if (charge > 1.0f) {
                charge = 1.0f;
            }
            EntityTippedArrow arrowEntity = new EntityTippedArrow(event.entityPlayer.field_70170_p, (EntityLivingBase)event.entityPlayer, charge * 2.0f);
            arrowEntity.setArrow(arrow);
            if (charge == 1.0f) {
                arrowEntity.func_70243_d(true);
            }
            if ((power = EnchantmentHelper.func_77506_a((int)Enchantment.field_77345_t.field_77352_x, (ItemStack)event.bow)) > 0) {
                arrowEntity.func_70239_b(arrowEntity.func_70242_d() + (double)power * 0.5 + 0.5);
            }
            if ((punch = EnchantmentHelper.func_77506_a((int)Enchantment.field_77344_u.field_77352_x, (ItemStack)event.bow)) > 0) {
                arrowEntity.func_70240_a(punch);
            }
            if (EnchantmentHelper.func_77506_a((int)Enchantment.field_77343_v.field_77352_x, (ItemStack)event.bow) > 0) {
                arrowEntity.func_70015_d(100);
            }
            event.bow.func_77972_a(1, (EntityLivingBase)event.entityPlayer);
            event.entityPlayer.field_70170_p.func_72956_a((Entity)event.entityPlayer, "random.bow", 1.0f, 1.0f / (event.entityPlayer.field_70170_p.field_73012_v.nextFloat() * 0.4f + 1.2f) + charge * 0.5f);
            if (!event.entityPlayer.field_71075_bZ.field_75098_d && --arrow.field_77994_a <= 0) {
                event.entityPlayer.field_71071_by.func_70299_a(i, null);
            }
            if (!event.entityPlayer.field_70170_p.field_72995_K) {
                event.entityPlayer.field_70170_p.func_72838_d((Entity)arrowEntity);
            }
            event.setCanceled(true);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SubscribeEvent
    public void onPlayerLoadFromFileEvent(PlayerEvent.LoadFromFile event) {
        if (!ConfigBlocksItems.enableEnchantingTable) {
            return;
        }
        Path file = event.getPlayerFile("etfuturum").toPath();
        if (Files.exists(file, new LinkOption[0])) {
            EtFuturumPlayer storage = EtFuturumPlayer.get(event.entityPlayer);
            try {
                try (BufferedReader reader = Files.newBufferedReader(file, StandardCharsets.UTF_8);){
                    int seed = Integer.parseInt(reader.readLine());
                    storage.setEnchantmentSeed(seed);
                }
                catch (NumberFormatException numberFormatException) {
                }
                finally {
                    Files.delete(file);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void harvestEvent(BlockEvent.HarvestDropsEvent event) {
        ItemStack stack;
        if (ConfigFunctions.enableSilkTouchingMushrooms && event.isSilkTouching) {
            if (event.block == Blocks.field_150420_aW) {
                event.drops.clear();
                event.drops.add(new ItemStack(ModBlocks.BROWN_MUSHROOM.get()));
            } else if (event.block == Blocks.field_150419_aX) {
                event.drops.clear();
                event.drops.add(new ItemStack(ModBlocks.RED_MUSHROOM.get()));
            }
        }
        if (ConfigFunctions.enableSticksFromDeadBushes && event.block == Blocks.field_150330_I) {
            boolean isShears;
            boolean bl = isShears = event.harvester != null && event.harvester.func_71045_bC() != null && event.harvester.func_71045_bC().func_77973_b() instanceof ItemShears;
            if (event.harvester == null || event.harvester.func_71045_bC() == null || !isShears) {
                event.drops.add(new ItemStack(Items.field_151055_y, event.world.field_73012_v.nextInt(3)));
            }
        }
        if (ConfigBlocksItems.enableRawOres && !event.isSilkTouching) {
            block0: for (int i = 0; i < event.drops.size(); ++i) {
                ItemStack stack2 = (ItemStack)event.drops.get(i);
                for (String oreName : EtFuturum.getOreStrings(stack2)) {
                    RawOreDropMapping mapping = RawOreRegistry.getOreMap().get(oreName);
                    if (mapping == null || stack2 == null || EtFuturum.dictTagsStartWith(stack2, "raw")) continue;
                    event.drops.set(i, new ItemStack((Item)mapping.getObject(), mapping.getDropAmount(event.world.field_73012_v, event.fortuneLevel), mapping.getMeta()));
                    continue block0;
                }
            }
        }
        if (ConfigFunctions.enableShearableCobwebs && event.block == Blocks.field_150321_G && event.harvester != null && (stack = event.harvester.func_71045_bC()) != null && stack.func_77973_b() instanceof ItemShears) {
            event.drops.clear();
            event.drops.add(new ItemStack(Blocks.field_150321_G));
        }
    }

    @SubscribeEvent
    public void onBlockBroken(BlockEvent.BreakEvent event) {
        ItemStack itemstack;
        if (ConfigFunctions.enableHoeMining && (double)event.block.func_149712_f(event.world, event.x, event.y, event.z) != 0.0 && (itemstack = event.getPlayer().func_70694_bm()) != null && itemstack.func_77973_b() instanceof ItemHoe) {
            itemstack.func_77972_a(1, (EntityLivingBase)event.getPlayer());
        }
    }

    @SubscribeEvent
    public void breakSpeedEvent(PlayerEvent.BreakSpeed event) {
        ItemStack stack;
        boolean flag = false;
        float toolSpeed = 0.0f;
        float speedModifier = 0.0f;
        if (ConfigFunctions.enableHoeMining && HoeRegistry.hoeArrayHas(event.block) && (stack = event.entityPlayer.func_70694_bm()) != null && stack.func_77973_b() instanceof ItemHoe) {
            try {
                Item hoe = stack.func_77973_b();
                toolSpeed = this.getHoeSpeed(hoe);
                speedModifier = this.speedModifier(event.entityPlayer, event.block, event.metadata, toolSpeed);
                flag = true;
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
            }
        }
        if (flag) {
            event.newSpeed = event.originalSpeed + toolSpeed + speedModifier;
        }
    }

    public float getHoeSpeed(Item item) {
        float returnValue = 0.0f;
        try {
            if (item instanceof ItemHoe || item instanceof ItemTool) {
                Item.ToolMaterial theToolMaterial = item instanceof ItemTool ? ((ItemTool)item).field_77862_b : ((ItemHoe)item).field_77843_a;
                returnValue = theToolMaterial.func_77998_b();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return returnValue;
    }

    public float speedModifier(EntityPlayer entity, Block block, int meta, float digSpeed) {
        float moddedDigSpeed = 1.0f;
        int i = EnchantmentHelper.func_77509_b((EntityLivingBase)entity);
        ItemStack itemstack = entity.field_71071_by.func_70448_g();
        if (i > 0 && itemstack != null) {
            float f1 = i * i + 1;
            moddedDigSpeed += f1;
        }
        if (entity.func_70644_a(Potion.field_76422_e)) {
            moddedDigSpeed *= 1.0f + (float)(entity.func_70660_b(Potion.field_76422_e).func_76458_c() + 1) * 0.2f;
        }
        if (entity.func_70644_a(Potion.field_76419_f)) {
            moddedDigSpeed *= 1.0f - (float)(entity.func_70660_b(Potion.field_76419_f).func_76458_c() + 1) * 0.2f;
        }
        if (entity.func_70055_a(Material.field_151586_h) && !EnchantmentHelper.func_77510_g((EntityLivingBase)entity)) {
            moddedDigSpeed /= 5.0f;
        }
        if (!entity.field_70122_E) {
            moddedDigSpeed /= 5.0f;
        }
        return moddedDigSpeed - 1.0f < 0.0f ? 0.0f : moddedDigSpeed - 1.0f;
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void captureLastSideHit(PlayerInteractEvent event) {
        if (ConfigFunctions.enableFloatingTrapDoors && event.action == PlayerInteractEvent.Action.RIGHT_CLICK_BLOCK && !SpectatorMode.isSpectator(event.entityPlayer)) {
            this.sideHit.set(event.face);
        }
    }

    @SubscribeEvent
    public void onPlaceBlock(BlockEvent.PlaceEvent event) {
        if (ConfigFunctions.enableFloatingTrapDoors && event.placedBlock instanceof BlockTrapDoor && (this.sideHit.get() == 0 || this.sideHit.get() == 1)) {
            int l = MathHelper.func_76128_c((double)((double)(event.player.field_70177_z * 4.0f / 360.0f) + 0.5)) + 1 & 3;
            l = l == 0 ? 2 : (l == 3 ? 1 : (l == 1 ? 0 : 3));
            if (this.sideHit.get() == 0) {
                l += 8;
            }
            event.world.func_72921_c(event.x, event.y, event.z, l, 2);
        }
    }

    @SubscribeEvent
    public void onPlayerInteractNonVanilla(PlayerInteractEvent event) {
        if (event.action == PlayerInteractEvent.Action.RIGHT_CLICK_AIR) {
            EntityPlayer player = event.entityPlayer;
            ItemStack heldStack = player.func_70694_bm();
            World world = event.world;
            if (ConfigMixins.enableElytra && heldStack != null && heldStack.func_77973_b() == Items.field_151152_bP && ((IElytraPlayer)player).etfu$isElytraFlying()) {
                player.func_71038_i();
                if (!world.field_72995_K) {
                    EntityBoostingFireworkRocket entityfireworkrocket = new EntityBoostingFireworkRocket(world, heldStack, (EntityLivingBase)player);
                    world.func_72838_d((Entity)entityfireworkrocket);
                    if (!player.field_71075_bZ.field_75098_d) {
                        --heldStack.field_77994_a;
                    }
                    event.useItem = Event.Result.ALLOW;
                }
            }
        }
    }

    @SubscribeEvent
    public void onBoneMeal(BonemealEvent event) {
        if (ConfigSounds.bonemealing && event.block instanceof IGrowable && !event.world.field_72995_K && ((IGrowable)event.block).func_149851_a(event.world, event.x, event.y, event.z, false)) {
            event.world.func_72908_a((double)((float)event.x + 0.5f), (double)((float)event.y + 0.5f), (double)((float)event.z + 0.5f), "minecraft_1.21:item.bone_meal.use", 1.0f, 1.0f);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onPlayerInteract(PlayerInteractEvent event) {
        EntityPlayer player = event.entityPlayer;
        if (!(event.action != PlayerInteractEvent.Action.RIGHT_CLICK_BLOCK && event.action != PlayerInteractEvent.Action.RIGHT_CLICK_AIR || SpectatorMode.isSpectator(player) || player == null)) {
            ItemStack heldStack = player.func_70694_bm();
            World world = event.world;
            int x = event.x;
            int y = event.y;
            int z = event.z;
            Block oldBlock = world.func_147439_a(x, y, z);
            int meta = world.func_72805_g(x, y, z);
            int side = event.face;
            if (player.func_82247_a(x, y, z, side, heldStack) && event.getResult() == event.useItem) {
                Set toolClasses;
                MovingObjectPosition movingobjectposition;
                if (ConfigSounds.endPortalFillSounds && heldStack != null && !world.field_72995_K && heldStack.func_77973_b() == Items.field_151061_bv && oldBlock == Blocks.field_150378_br && !BlockEndPortalFrame.func_150020_b((int)meta)) {
                    int i2;
                    int l2;
                    int l1;
                    world.func_72908_a((double)((float)x + 0.5f), (double)((float)y + 0.5f), (double)((float)z + 0.5f), "minecraft_1.21:block.end_portal_frame.fill", 1.0f, 1.0f);
                    int j1 = meta & 3;
                    int j2 = 0;
                    int k1 = 0;
                    boolean flag1 = false;
                    boolean flag = true;
                    int k2 = Direction.field_71577_f[j1];
                    for (l1 = -2; l1 <= 2; ++l1) {
                        l2 = x + Direction.field_71583_a[k2] * l1;
                        i2 = z + Direction.field_71581_b[k2] * l1;
                        if (world.func_147439_a(l2, y, i2) != Blocks.field_150378_br) continue;
                        if (!(BlockEndPortalFrame.func_150020_b((int)world.func_72805_g(l2, y, i2)) || l2 == x && i2 == z)) {
                            flag = false;
                            break;
                        }
                        k1 = l1;
                        if (flag1) continue;
                        j2 = l1;
                        flag1 = true;
                    }
                    if (flag && k1 == j2 + 2) {
                        for (l1 = j2; l1 <= k1; ++l1) {
                            l2 = x + Direction.field_71583_a[k2] * l1;
                            i2 = z + Direction.field_71581_b[k2] * l1;
                            if (world.func_147439_a(l2 += Direction.field_71583_a[j1] * 4, y, i2 += Direction.field_71581_b[j1] * 4) == Blocks.field_150378_br && BlockEndPortalFrame.func_150020_b((int)world.func_72805_g(l2, y, i2)) || l2 == x && i2 == z) continue;
                            flag = false;
                            break;
                        }
                        block16: for (l1 = j2 - 1; l1 <= k1 + 1; l1 += 4) {
                            for (l2 = 1; l2 <= 3; ++l2) {
                                i2 = x + Direction.field_71583_a[k2] * l1;
                                int i3 = z + Direction.field_71581_b[k2] * l1;
                                if (world.func_147439_a(i2 += Direction.field_71583_a[j1] * l2, y, i3 += Direction.field_71581_b[j1] * l2) == Blocks.field_150378_br && BlockEndPortalFrame.func_150020_b((int)world.func_72805_g(i2, y, i3)) || i2 == x && i3 == z) continue;
                                flag = false;
                                continue block16;
                            }
                        }
                        if (flag) {
                            for (WorldServer worldserver : FMLCommonHandler.instance().getMinecraftServerInstance().field_71305_c) {
                                for (Object playerobj : worldserver.field_73010_i) {
                                    if (!(playerobj instanceof EntityPlayerMP)) continue;
                                    EntityPlayerMP playermp = (EntityPlayerMP)playerobj;
                                    playermp.field_71135_a.func_147359_a((Packet)new S29PacketSoundEffect("minecraft_1.21:block.end_portal.spawn", playermp.field_70165_t, playermp.field_70137_T, playermp.field_70161_v, 1.0f, 1.0f));
                                }
                            }
                        }
                    }
                }
                if (ConfigSounds.fixSilentPlacing && heldStack != null && !world.field_72995_K) {
                    BlockRedstoneWire block = null;
                    Item item = heldStack.func_77973_b();
                    if (item == Items.field_151137_ax) {
                        block = Blocks.field_150488_af;
                    } else if (item == Items.field_151155_ap) {
                        block = side < 2 ? Blocks.field_150472_an : Blocks.field_150444_as;
                    } else if (item == Items.field_151135_aq && side == 1) {
                        block = Blocks.field_150466_ao;
                    } else if (item == Items.field_151139_aw && side == 1) {
                        block = Blocks.field_150454_av;
                    } else if (item == Items.field_151104_aV && side == 1) {
                        block = Blocks.field_150324_C;
                    }
                    if (block != null) {
                        int xMutable = x;
                        int yMutable = y;
                        int zMutable = z;
                        if (block != Blocks.field_150488_af || !world.func_147439_a(xMutable, yMutable, zMutable).isReplaceable((IBlockAccess)world, xMutable, yMutable, zMutable)) {
                            switch (event.face) {
                                case 0: {
                                    --yMutable;
                                    break;
                                }
                                case 1: {
                                    ++yMutable;
                                    break;
                                }
                                case 2: {
                                    --zMutable;
                                    break;
                                }
                                case 3: {
                                    ++zMutable;
                                    break;
                                }
                                case 4: {
                                    --xMutable;
                                    break;
                                }
                                case 5: {
                                    ++xMutable;
                                }
                            }
                            if (!world.func_147437_c(xMutable, yMutable, zMutable)) {
                                return;
                            }
                        }
                        if (block == Blocks.field_150324_C) {
                            int i1 = MathHelper.func_76128_c((double)((double)(player.field_70177_z * 4.0f / 360.0f) + 0.5)) & 3;
                            int b0 = 0;
                            int b1 = 0;
                            switch (i1) {
                                case 0: {
                                    b1 = (byte)(b1 + 1);
                                    break;
                                }
                                case 1: {
                                    b0 = (byte)(b0 - 1);
                                    break;
                                }
                                case 2: {
                                    b1 = (byte)(b1 - 1);
                                    break;
                                }
                                case 3: {
                                    b0 = (byte)(b0 + 1);
                                }
                            }
                            if (!(player.func_82247_a(xMutable + b0, yMutable, zMutable + b1, side, heldStack) && block.func_149742_c(world, xMutable + b0, yMutable, zMutable + b1) && world.func_147437_c(xMutable, yMutable, zMutable) && world.func_147437_c(xMutable + b0, yMutable, zMutable + b1) && World.func_147466_a((IBlockAccess)world, (int)xMutable, (int)(yMutable - 1), (int)zMutable) && World.func_147466_a((IBlockAccess)world, (int)(xMutable + b0), (int)(yMutable - 1), (int)(zMutable + b1)))) {
                                return;
                            }
                        }
                        if (!player.func_82247_a(xMutable, yMutable, zMutable, side, heldStack)) {
                            return;
                        }
                        if (block.func_149742_c(world, xMutable, yMutable, zMutable)) {
                            world.func_72908_a((double)xMutable + 0.5, (double)yMutable + 0.5, (double)zMutable + 0.5, block.field_149762_H.func_150496_b(), (block.field_149762_H.func_150497_c() + 1.0f) / 2.0f, block.field_149762_H.func_150494_d() * 0.8f);
                            return;
                        }
                    }
                }
                if (ConfigSounds.seedPlanting && side == 1 && heldStack != null && heldStack.func_77973_b() instanceof IPlantable && player.func_82247_a(x, y + 1, z, side, heldStack) && world.func_147439_a(x, y, z).canSustainPlant((IBlockAccess)world, x, y, z, ForgeDirection.UP, (IPlantable)heldStack.func_77973_b()) && world.func_147437_c(x, y + 1, z)) {
                    if (oldBlock instanceof BlockFarmland) {
                        world.func_72908_a((double)x + 0.5, (double)((float)y + 1.0f), (double)z + 0.5, ModSounds.soundCrops.func_150496_b(), ModSounds.soundCrops.func_150497_c(), ModSounds.soundCrops.func_150494_d());
                        return;
                    }
                    if (oldBlock instanceof BlockSoulSand) {
                        world.func_72908_a((double)x + 0.5, (double)((float)y + 1.0f), (double)z + 0.5, ModSounds.soundCropWarts.func_150496_b(), ModSounds.soundCropWarts.func_150497_c(), ModSounds.soundCropWarts.func_150494_d());
                        return;
                    }
                }
                if (heldStack != null && ServerEventHandler.canUse(player, world, x, y, z) && oldBlock == Blocks.field_150383_bp) {
                    Item item = heldStack.func_77973_b();
                    if (ConfigBlocksItems.enableLavaCauldrons && item instanceof ItemBucket && ((ItemBucket)item).field_77876_a == Blocks.field_150356_k && meta == 0) {
                        event.setResult(Event.Result.DENY);
                        player.func_71038_i();
                        world.func_147449_b(x, y, z, ModBlocks.LAVA_CAULDRON.get());
                        if (ConfigSounds.fluidInteract) {
                            world.func_72908_a((double)x, (double)y, (double)z, "minecraft_1.21:item.bucket.empty_lava", 1.0f, 1.0f);
                        }
                        if (!player.field_71075_bZ.field_75098_d) {
                            if (heldStack.field_77994_a <= 1) {
                                player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, new ItemStack(item.func_77668_q()));
                            } else {
                                --heldStack.field_77994_a;
                            }
                        }
                        return;
                    }
                    if (ConfigSounds.fluidInteract) {
                        String container = "";
                        String fillOrEmpty = "";
                        if (item instanceof ItemBucket && ((ItemBucket)item).field_77876_a == Blocks.field_150358_i && meta < 3) {
                            container = "bucket";
                            fillOrEmpty = "empty";
                        } else if (item == Items.field_151069_bo || item == Items.field_151068_bn && heldStack.func_77960_j() == 0 && !heldStack.func_77942_o()) {
                            container = "bottle";
                            String string = fillOrEmpty = item == Items.field_151069_bo && meta > 0 ? "fill" : "";
                        }
                        if (!container.equals("") && !fillOrEmpty.equals("")) {
                            world.func_72908_a((double)x, (double)y, (double)z, "minecraft_1.21:item." + container + "." + fillOrEmpty, 1.0f, 1.0f);
                            return;
                        }
                    }
                }
                if (ConfigSounds.fluidInteract && !world.field_72995_K && heldStack != null && heldStack.func_77973_b() == Items.field_151069_bo && event.action == PlayerInteractEvent.Action.RIGHT_CLICK_AIR && (movingobjectposition = ServerEventHandler.getMovingObjectPositionFromPlayer(world, player, true)) != null && movingobjectposition.field_72313_a == MovingObjectPosition.MovingObjectType.BLOCK) {
                    boolean isWater;
                    int i = movingobjectposition.field_72311_b;
                    int j = movingobjectposition.field_72312_c;
                    int k = movingobjectposition.field_72309_d;
                    if (!world.func_72962_a(player, i, j, k)) {
                        return;
                    }
                    if (!player.func_82247_a(i, j, k, movingobjectposition.field_72310_e, heldStack)) {
                        return;
                    }
                    boolean bl = isWater = world.func_147439_a(i, j, k).func_149688_o() == Material.field_151586_h;
                    if (isWater) {
                        world.func_72956_a((Entity)player, "minecraft_1.21:item.bottle.fill", 1.0f, 1.0f);
                        return;
                    }
                }
                if (ConfigSounds.newBlockSounds && heldStack != null && Block.func_149634_a((Item)heldStack.func_77973_b()) instanceof BlockLilyPad) {
                    Block block = Block.func_149634_a((Item)heldStack.func_77973_b());
                    MovingObjectPosition movingobjectposition2 = ServerEventHandler.getMovingObjectPositionFromPlayer(world, player, true);
                    if (movingobjectposition2 == null) {
                        return;
                    }
                    if (movingobjectposition2.field_72313_a == MovingObjectPosition.MovingObjectType.BLOCK) {
                        int i = movingobjectposition2.field_72311_b;
                        int j = movingobjectposition2.field_72312_c;
                        int k = movingobjectposition2.field_72309_d;
                        if (!world.func_72962_a(player, i + 1, j, k)) {
                            return;
                        }
                        if (!player.func_82247_a(i, j + 1, k, movingobjectposition2.field_72310_e, heldStack)) {
                            return;
                        }
                        if (block.func_149718_j(world, i, j + 1, k) && event.action == PlayerInteractEvent.Action.RIGHT_CLICK_AIR) {
                            world.func_72908_a((double)((float)i + 0.5f), (double)((float)j + 0.5f), (double)((float)k + 0.5f), "minecraft_1.21:block.lily_pad.place", 1.0f, 1.0f);
                            return;
                        }
                    }
                }
                if (ModBlocks.DAYLIGHT_DETECTOR_INVERTED.isEnabled() && oldBlock == Blocks.field_150453_bW && ServerEventHandler.canUse(player, world, x, y, z)) {
                    player.func_71038_i();
                    world.func_147465_d(x, y, z, ModBlocks.DAYLIGHT_DETECTOR_INVERTED.get(), 15 - meta, 2);
                    if (!world.field_72995_K) {
                        event.setResult(Event.Result.DENY);
                        event.setCanceled(true);
                    }
                    world.func_147444_c(x, y, z, ModBlocks.DAYLIGHT_DETECTOR_INVERTED.get());
                }
                if (heldStack != null && heldStack.func_77973_b() == Items.field_151068_bn && Utils.hasPotionEffect(heldStack) && ModBlocks.POTION_CAULDRON.isEnabled() && oldBlock == Blocks.field_150383_bp && meta == 0 && !ItemPotion.func_77831_g((int)heldStack.func_77960_j())) {
                    world.func_147449_b(x, y, z, ModBlocks.POTION_CAULDRON.get());
                }
                if (heldStack != null) {
                    this.doMudConversion(world, x, y, z, player, oldBlock, meta, heldStack);
                }
                if (ConfigFunctions.mobSpawnerEgging && oldBlock == Blocks.field_150474_ac && heldStack != null && heldStack.func_77973_b() == Items.field_151063_bx) {
                    TileEntityMobSpawner tileEntityMobSpawner = (TileEntityMobSpawner)world.func_147438_o(x, y, z);
                    String entityName = EntityList.func_75617_a((int)heldStack.func_77960_j());
                    if (!entityName.equals(tileEntityMobSpawner.func_145881_a().func_98276_e())) {
                        tileEntityMobSpawner.func_145881_a().func_98272_a(entityName);
                        player.func_71038_i();
                        if (!world.field_72995_K) {
                            event.setResult(Event.Result.ALLOW);
                            event.setCanceled(true);
                        }
                        world.func_147471_g(x, y, z);
                        if (!player.field_71075_bZ.field_75098_d) {
                            --heldStack.field_77994_a;
                        }
                        return;
                    }
                }
                if (heldStack != null && (toolClasses = heldStack.func_77973_b().getToolClasses(heldStack)) != null && heldStack.func_77973_b() != ExternalContent.Items.BOTANIA_MANASTEEL_SHOVEL.get() && heldStack.func_77973_b() != ExternalContent.Items.THAUMCRAFT_EARTHMOVER_SHOVEL.get()) {
                    RegistryMapping<Block> newBlock;
                    if (ConfigBlocksItems.enableGrassPath && toolClasses.contains("shovel") && !world.func_147439_a(x, y + 1, z).func_149688_o().func_76220_a() && (oldBlock == Blocks.field_150349_c || oldBlock == Blocks.field_150346_d || oldBlock == Blocks.field_150391_bh)) {
                        player.func_71038_i();
                        if (!world.field_72995_K) {
                            world.func_147449_b(x, y, z, ModBlocks.GRASS_PATH.get());
                            heldStack.func_77972_a(1, (EntityLivingBase)player);
                            world.func_72908_a((double)((float)x + 0.5f), (double)((float)y + 0.5f), (double)((float)z + 0.5f), "minecraft_1.21:item.shovel.flatten", 1.0f, 1.0f);
                        }
                    } else if (ConfigBlocksItems.enableStrippedLogs && toolClasses.contains("axe") && (newBlock = StrippedLogRegistry.getLog(oldBlock, world.func_72805_g(x, y, z) % 4)) != null) {
                        player.func_71038_i();
                        if (!world.field_72995_K) {
                            world.func_147465_d(x, y, z, newBlock.getObject(), newBlock.getMeta() + meta / 4 * 4, 2);
                            heldStack.func_77972_a(1, (EntityLivingBase)player);
                            world.func_72908_a((double)((float)x + 0.5f), (double)((float)y + 0.5f), (double)((float)z + 0.5f), "minecraft_1.21:item.axe.strip", 1.0f, 0.8f);
                        }
                    }
                }
            }
        }
    }

    private boolean doMudConversion(World world, int x, int y, int z, EntityPlayer player, Block oldBlock, int meta, ItemStack heldStack) {
        boolean isValid;
        boolean bl = isValid = heldStack.func_77973_b() == Items.field_151068_bn && heldStack.func_77960_j() == 0 && Items.field_151068_bn.func_77832_l(heldStack) == null;
        if (!isValid && ModsList.EXTRA_UTILITIES.isLoaded()) {
            int itemDamage = heldStack.func_77960_j();
            boolean bl2 = isValid = heldStack.func_77973_b() == ExternalContent.Items.EXTRAUTILS_WATERING_CAN.get() && (itemDamage == 0 || itemDamage == 3);
        }
        if (ModBlocks.MUD.isEnabled() && isValid && (oldBlock == Blocks.field_150346_d && meta != 2 || oldBlock == ModBlocks.COARSE_DIRT.get())) {
            world.func_147449_b(x, y, z, ModBlocks.MUD.get());
            world.func_72908_a((double)((float)x + 0.5f), (double)((float)y + 0.5f), (double)((float)z + 0.5f), "minecraft_1.21:item.bottle.empty", 1.0f, 1.0f);
            player.func_71038_i();
            if (world.field_72995_K) {
                double d0 = 0.0625;
                for (int l = 0; l < 10; ++l) {
                    double d1 = (float)x + world.field_73012_v.nextFloat();
                    double d2 = (float)y + world.field_73012_v.nextFloat();
                    double d3 = (float)z + world.field_73012_v.nextFloat();
                    if (l == 0 && !world.func_147439_a(x, y + 1, z).func_149662_c()) {
                        d2 = (double)(y + 1) + d0;
                    }
                    if (l == 1 && !world.func_147439_a(x, y - 1, z).func_149662_c()) {
                        d2 = (double)y - d0;
                    }
                    if (l == 2 && !world.func_147439_a(x, y, z + 1).func_149662_c()) {
                        d3 = (double)(z + 1) + d0;
                    }
                    if (l == 3 && !world.func_147439_a(x, y, z - 1).func_149662_c()) {
                        d3 = (double)z - d0;
                    }
                    if (l == 4 && !world.func_147439_a(x + 1, y, z).func_149662_c()) {
                        d1 = (double)(x + 1) + d0;
                    }
                    if (l == 5 && !world.func_147439_a(x - 1, y, z).func_149662_c()) {
                        d1 = (double)x - d0;
                    }
                    if (!(d1 < (double)x || d1 > (double)(x + 1) || d2 < 0.0 || d2 > (double)(y + 1) || d3 < (double)z) && !(d3 > (double)(z + 1))) continue;
                    world.func_72869_a("splash", d1, d2, d3, 0.0, 0.0, 0.0);
                }
            }
            if (!player.field_71075_bZ.field_75098_d && heldStack.func_77973_b() == Items.field_151068_bn) {
                ItemStack bottle = new ItemStack(Items.field_151069_bo);
                if (heldStack.field_77994_a <= 1) {
                    player.func_70062_b(0, bottle);
                } else {
                    player.field_71071_by.func_70298_a(player.field_71071_by.field_70461_c, 1);
                    if (!player.field_71071_by.func_70441_a(bottle)) {
                        player.func_71019_a(bottle, false);
                    }
                }
            }
            return true;
        }
        return false;
    }

    @SubscribeEvent
    public void onFillBucketEvent(FillBucketEvent event) {
        if (ConfigSounds.fluidInteract && event.current.func_77973_b() instanceof ItemBucket) {
            Block isFull = ((ItemBucket)event.current.func_77973_b()).field_77876_a;
            MovingObjectPosition target = event.target;
            int x = target.field_72311_b;
            int y = target.field_72312_c;
            int z = target.field_72309_d;
            if (!event.world.func_72962_a(event.entityPlayer, x, y, z)) {
                return;
            }
            if (isFull == Blocks.field_150350_a && !event.entityPlayer.func_82247_a(x, y, z, target.field_72310_e, event.current)) {
                return;
            }
            if (!event.world.field_72995_K) {
                if (isFull.func_149688_o() == Material.field_151586_h) {
                    event.world.func_72908_a((double)target.field_72311_b + 0.5, (double)target.field_72312_c + 0.5, (double)target.field_72309_d + 0.5, "minecraft_1.21:item.bucket.empty", 1.0f, 1.0f);
                } else if (isFull != Blocks.field_150350_a) {
                    event.world.func_72908_a((double)target.field_72311_b + 0.5, (double)target.field_72312_c + 0.5, (double)target.field_72309_d + 0.5, "minecraft_1.21:item.bucket.empty_lava", 1.0f, 1.0f);
                } else if (event.world.func_147439_a(target.field_72311_b, target.field_72312_c, target.field_72309_d).func_149688_o() == Material.field_151586_h) {
                    event.world.func_72908_a((double)target.field_72311_b + 0.5, (double)target.field_72312_c + 0.5, (double)target.field_72309_d + 0.5, "minecraft_1.21:item.bucket.fill", 1.0f, 1.0f);
                } else if (event.world.func_147439_a(target.field_72311_b, target.field_72312_c, target.field_72309_d).func_149688_o().func_76224_d()) {
                    event.world.func_72908_a((double)target.field_72311_b + 0.5, (double)target.field_72312_c + 0.5, (double)target.field_72309_d + 0.5, "minecraft_1.21:item.bucket.fill_lava", 1.0f, 1.0f);
                }
            }
        }
    }

    public static boolean canUse(EntityPlayer player, World world, int x, int y, int z) {
        return !player.func_70093_af() || player.func_70694_bm() == null || player.func_70694_bm().func_77973_b().doesSneakBypassUse(world, x, y, z, player);
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void dropEvent(LivingDropsEvent event) {
        Entity entity2;
        if (event.entityLiving.field_70170_p.field_72995_K) {
            return;
        }
        if (ConfigFunctions.enableSkullDrop && event.entityLiving.field_70170_p.func_82736_K().func_82766_b("doMobLoot")) {
            this.dropHead(event.entityLiving, event.source, event.lootingLevel, event.drops);
        }
        Random rand = event.entityLiving.field_70170_p.field_73012_v;
        if (ModItems.MUTTON_RAW.isEnabled() && ModItems.MUTTON_COOKED.isEnabled() && event.entityLiving.field_70170_p.func_82736_K().func_82766_b("doMobLoot") && event.entityLiving instanceof EntitySheep) {
            int amount = rand.nextInt(3) + 1 + rand.nextInt(1 + event.lootingLevel);
            for (int i = 0; i < amount; ++i) {
                if (event.entityLiving.func_70027_ad()) {
                    this.addDrop(new ItemStack(ModItems.MUTTON_COOKED.get()), event.entityLiving, event.drops);
                    continue;
                }
                this.addDrop(new ItemStack(ModItems.MUTTON_RAW.get()), event.entityLiving, event.drops);
            }
        }
        if (ModBlocks.WITHER_ROSE.isEnabled() && event.entity instanceof EntityLivingBase && event.source.func_76346_g() instanceof EntityWither) {
            World world = event.entity.field_70170_p;
            Entity entity2 = event.entity;
            if (world.func_82736_K().func_82766_b("mobGriefing") && ModBlocks.WITHER_ROSE.get().func_149742_c(world, (int)entity2.field_70165_t, (int)entity2.field_70163_u, (int)entity2.field_70161_v)) {
                world.func_147449_b((int)entity2.field_70165_t, (int)entity2.field_70163_u, (int)entity2.field_70161_v, ModBlocks.WITHER_ROSE.get());
            } else {
                this.addDrop(ModBlocks.WITHER_ROSE.newItemStack(1, 0), event.entityLiving, event.drops);
            }
        }
        if ((entity2 = event.source.func_76346_g()) instanceof EntityFox) {
            EntityFox fox = (EntityFox)entity2;
            int looting = fox.getLootingLevel();
            EntityLivingBase victim = event.entityLiving;
            if (victim instanceof EntityChicken) {
                int extraChicken = victim.func_70681_au().nextInt(1 + looting);
                for (EntityItem entityItem : event.drops) {
                    Item item = entityItem.func_92059_d().func_77973_b();
                    if (item != Items.field_151077_bg && item != Items.field_151076_bf) continue;
                    entityItem.func_92059_d().field_77994_a += extraChicken;
                }
            }
        }
    }

    private void dropHead(EntityLivingBase entity, DamageSource source, int looting, List<EntityItem> drops) {
        int meta;
        if (this.isPoweredCreeper(source) && (meta = this.getHeadMetadata(entity)) >= 0) {
            this.addDrop(new ItemStack(Items.field_151144_bL, 1, meta), entity, drops);
        }
    }

    private void addDrop(ItemStack stack, EntityLivingBase entity, List<EntityItem> list) {
        if (stack.field_77994_a <= 0) {
            return;
        }
        EntityItem entityItem = new EntityItem(entity.field_70170_p, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, stack);
        entityItem.field_145804_b = 10;
        list.add(entityItem);
    }

    private boolean isPoweredCreeper(DamageSource source) {
        Entity entity;
        if (source.func_94541_c() && source instanceof EntityDamageSource && (entity = source.func_76346_g()) instanceof EntityCreeper) {
            return ((EntityCreeper)entity).func_70830_n();
        }
        return false;
    }

    private int getHeadMetadata(EntityLivingBase entity) {
        if (entity.getClass() == EntityZombie.class) {
            return 2;
        }
        if (entity.getClass() == EntitySkeleton.class && ((EntitySkeleton)entity).func_82202_m() == 0) {
            return 0;
        }
        if (entity.getClass() == EntityCreeper.class) {
            return 4;
        }
        return -1;
    }

    @SubscribeEvent
    public void teleportEvent(EnderTeleportEvent event) {
        EntityLivingBase entity = event.entityLiving;
        if (entity instanceof EntityPlayerMP) {
            ForgeDirection[] horizontal;
            if (ConfigEntities.enableEndermite && entity.func_70681_au().nextFloat() < 0.05f && entity.field_70170_p.func_82736_K().func_82766_b("doMobSpawning")) {
                EntityEndermite entityendermite = new EntityEndermite(entity.field_70170_p);
                entityendermite.func_70012_b(event.targetX, event.targetY, event.targetZ, entity.field_70177_z, entity.field_70125_A);
                entity.field_70170_p.func_72838_d((Entity)entityendermite);
                entityendermite.setSpawnedByPlayer(true);
                entityendermite.aggroEndermen(64);
            }
            for (ForgeDirection enumfacing : horizontal = new ForgeDirection[]{ForgeDirection.NORTH, ForgeDirection.SOUTH, ForgeDirection.WEST, ForgeDirection.EAST}) {
                TileEntity tile = event.entity.field_70170_p.func_147438_o(MathHelper.func_76128_c((double)(event.targetX + (double)enumfacing.offsetX)), MathHelper.func_76128_c((double)event.targetY), MathHelper.func_76128_c((double)(event.targetZ + (double)enumfacing.offsetZ)));
                if (event.entity.field_70170_p.field_72995_K || !(tile instanceof TileEntityGateway) || ((TileEntityGateway)tile).isCoolingDown()) continue;
                ((TileEntityGateway)tile).teleportEntity(event.entity);
                tile.func_70296_d();
                event.setCanceled(true);
                break;
            }
        }
    }

    @SubscribeEvent
    public void naturalSpawnEvent(LivingSpawnEvent.SpecialSpawn event) {
        Object[] biomeTags;
        Chunk chunk;
        if (!(event.entity instanceof EntityLiving)) {
            return;
        }
        int x = MathHelper.func_76128_c((double)event.x);
        int y = MathHelper.func_76128_c((double)event.y);
        int z = MathHelper.func_76128_c((double)event.z);
        World world = event.world;
        EntityLivingBase entity = event.entityLiving;
        EnumFacing[] enumFacingArray = event.entityLiving;
        if (enumFacingArray instanceof EntityShulker) {
            EntityShulker shulker = (EntityShulker)enumFacingArray;
            shulker.field_82179_bU = false;
            if (ConfigTweaks.spawnAnywhereShulkerColors) {
                for (EnumFacing facing : Utils.ENUM_FACING_VALUES) {
                    int offX = x + facing.func_82601_c();
                    int offY = y + facing.func_96559_d();
                    int offZ = z + facing.func_82599_e();
                    Block block = world.func_147439_a(offX, offY, offZ);
                    byte color = -1;
                    int meta = world.func_72805_g(offX, offY, offZ);
                    if (facing == EnumFacing.DOWN && block == ExternalContent.Blocks.HEE_END_STONE.get()) {
                        color = (byte)(meta == 2 ? 10 : (meta == 1 ? 1 : 14));
                    } else if (block == ExternalContent.Blocks.ENDERLICIOUS_SAND.get()) {
                        color = (byte)(meta == 1 ? 15 : 0);
                    } else if (block == ExternalContent.Blocks.HEE_END_STONE.get()) {
                        color = (byte)(meta % 4 == 1 ? 13 : -1);
                    }
                    if (color <= -1) continue;
                    shulker.setColor(color);
                    break;
                }
            }
        } else if (ConfigEntities.enableStray && !ConfigWorld.oldStraySpawning && EntityList.func_75619_a((Entity)entity) == 51 && world.field_73012_v.nextFloat() < 0.8f && world.func_72937_j(x, y + 1, z)) {
            chunk = world.func_72938_d(x, z);
            Object[] biomeTags2 = BiomeDictionary.getTypesForBiome((BiomeGenBase)chunk.func_76591_a(x & 0xF, z & 0xF, world.func_72959_q()));
            if (ArrayUtils.contains((Object[])biomeTags2, (Object)BiomeDictionary.Type.SNOWY)) {
                EntityStray stray = new EntityStray(world);
                this.replaceEntity((Entity)entity, (Entity)stray, world, chunk);
                stray.func_110161_a(null);
                event.setCanceled(true);
                event.setResult(Event.Result.DENY);
            }
        } else if (ConfigEntities.enableHusk && !ConfigWorld.oldHuskSpawning && EntityList.func_75619_a((Entity)entity) == 54 && world.field_73012_v.nextFloat() < 0.8f && world.func_72937_j(x, y + 1, z) && ArrayUtils.contains((Object[])(biomeTags = BiomeDictionary.getTypesForBiome((BiomeGenBase)(chunk = world.func_72938_d(x, z)).func_76591_a(x & 0xF, z & 0xF, world.func_72959_q()))), (Object)BiomeDictionary.Type.HOT) && ArrayUtils.contains((Object[])biomeTags, (Object)BiomeDictionary.Type.DRY) && ArrayUtils.contains((Object[])biomeTags, (Object)BiomeDictionary.Type.SANDY)) {
            EntityHusk husk = new EntityHusk(world);
            this.replaceEntity((Entity)entity, (Entity)husk, world, chunk);
            husk.func_110161_a(null);
            event.setCanceled(true);
            event.setResult(Event.Result.DENY);
        }
    }

    @SubscribeEvent
    public void naturalSpawnEvent(LivingPackSizeEvent event) {
        int x = MathHelper.func_76128_c((double)event.entityLiving.field_70165_t);
        int y = MathHelper.func_76128_c((double)event.entityLiving.field_70163_u);
        int z = MathHelper.func_76128_c((double)event.entityLiving.field_70161_v);
        World world = event.entityLiving.field_70170_p;
        if (ConfigWorld.soulSandValleyID != -1 && EntityList.func_75619_a((Entity)event.entity) == 51 && ((EntitySkeleton)event.entity).func_82202_m() == 1 && !world.field_72995_K && world.field_73011_w instanceof WorldProviderHell && world.func_72807_a(x, z) == NetherBiomeManager.soulSandValley) {
            if (this.addRandomArmorMethod == null) {
                this.addRandomArmorMethod = ReflectionHelper.findMethod(EntityLiving.class, null, (String[])new String[]{"func_82164_bB", "addRandomArmor"}, (Class[])new Class[0]);
            }
            if (this.enchantEquipmentMethod == null) {
                this.enchantEquipmentMethod = ReflectionHelper.findMethod(EntityLiving.class, null, (String[])new String[]{"func_82162_bC", "enchantEquipment"}, (Class[])new Class[0]);
            }
            if (this.addRandomArmorMethod != null && this.enchantEquipmentMethod != null) {
                ArrayList list = Lists.newArrayList();
                try {
                    Field[] fields;
                    IChunkProvider provider = world.func_72863_F() instanceof ChunkProviderServer ? ((ChunkProviderServer)world.func_72863_F()).field_73246_d : world.func_72863_F();
                    if (this.chunkProviderFieldsCache.containsKey(provider.getClass())) {
                        fields = this.chunkProviderFieldsCache.get(provider.getClass());
                    } else {
                        fields = provider.getClass().getFields();
                        this.chunkProviderFieldsCache.put(provider.getClass(), fields);
                    }
                    for (Field field : fields) {
                        Object o = field.get(provider);
                        if (!(o instanceof MapGenNetherBridge)) continue;
                        list.add((MapGenNetherBridge)o);
                    }
                }
                catch (IllegalAccessException ignored) {
                    return;
                }
                for (MapGenNetherBridge bridge : list) {
                    if (!bridge.func_75048_a(x, y, z)) continue;
                    return;
                }
                ((EntitySkeleton)event.entity).func_82201_a(0);
                event.entity.func_70062_b(0, null);
                event.entity.func_70062_b(1, null);
                event.entity.func_70062_b(2, null);
                event.entity.func_70062_b(3, null);
                event.entity.func_70062_b(4, null);
                try {
                    this.addRandomArmorMethod.invoke((Object)event.entity, new Object[0]);
                    this.enchantEquipmentMethod.invoke((Object)event.entity, new Object[0]);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    @SubscribeEvent
    public void spawnEvent(LivingSpawnEvent.CheckSpawn event) {
        if (event.getResult() != Event.Result.DENY) {
            World world = event.world;
            int x = MathHelper.func_76128_c((double)event.x);
            int y = MathHelper.func_76128_c((double)event.y);
            int z = MathHelper.func_76128_c((double)event.z);
            if (event.world.field_73011_w instanceof WorldProviderHell && world.func_147439_a(x, y - 1, z) == ModBlocks.NETHER_WART.get() && world.func_72805_g(x, y - 1, z) == 0 && !(event.entity instanceof EntityFlying)) {
                event.setResult(Event.Result.DENY);
            }
        }
    }

    @SubscribeEvent
    public void spawnEvent(EntityJoinWorldEvent event) {
        Object object = event.entity;
        if (object instanceof EntityPig) {
            EntityPig pig = (EntityPig)object;
            if (ModItems.BEETROOT.isEnabled()) {
                pig.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAITempt((EntityCreature)pig, 1.2, ModItems.BEETROOT.get(), false));
            }
        } else {
            object = event.entity;
            if (object instanceof EntityChicken) {
                EntityChicken chicken = (EntityChicken)object;
                if (ModItems.BEETROOT.isEnabled()) {
                    chicken.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAITempt((EntityCreature)chicken, 1.0, ModItems.BEETROOT_SEEDS.get(), false));
                }
            } else if (ConfigEntities.enableRabbit && (object = event.entity) instanceof EntityWolf) {
                EntityWolf wolf = (EntityWolf)object;
                wolf.field_70715_bh.func_75776_a(4, (EntityAIBase)new EntityAITargetNonTamed((EntityTameable)wolf, EntityRabbit.class, 200, false));
            } else if (ConfigEntities.enableEndermite && (object = event.entity) instanceof EntityEnderman) {
                EntityEnderman enderman = (EntityEnderman)object;
                enderman.field_70715_bh.func_75776_a(3, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)enderman, EntityEndermite.class, 100, false));
            } else {
                object = event.entity;
                if (object instanceof EntityVillager) {
                    EntityVillager villager = (EntityVillager)object;
                    for (Object obj : villager.field_70714_bg.field_75782_a) {
                        EntityAITasks.EntityAITaskEntry entry = (EntityAITasks.EntityAITaskEntry)obj;
                        if (!(entry.field_75733_a instanceof EntityAIOpenDoor)) continue;
                        villager.field_70714_bg.func_85156_a(entry.field_75733_a);
                        villager.field_70714_bg.func_75776_a(entry.field_75731_b, (EntityAIBase)new EntityAIOpenCustomDoor((EntityLiving)villager, true));
                        break;
                    }
                } else if (!event.world.field_72995_K && ModBlocks.CONCRETE_POWDER.isEnabled() && event.entity instanceof EntityFallingBlock && ((EntityFallingBlock)event.entity).field_145811_e == ModBlocks.CONCRETE_POWDER.get()) {
                    fallingConcreteBlocks.add((EntityFallingBlock)event.entity);
                }
            }
        }
    }

    @SubscribeEvent
    public void interactEntityEvent(EntityInteractEvent event) {
        ItemStack stack = event.entityPlayer.func_71045_bC();
        World world = event.entityPlayer.field_70170_p;
        Entity target = event.target;
        if (target instanceof EntityAnimal && stack != null) {
            EntityAnimal animal = (EntityAnimal)event.target;
            if (!animal.func_70631_g_()) {
                if (animal instanceof EntityPig) {
                    if (stack.func_77973_b() == ModItems.BEETROOT.get() && ConfigBlocksItems.enableBeetroot) {
                        this.setAnimalInLove(animal, event.entityPlayer, stack);
                    }
                } else if (animal instanceof EntityChicken && stack.func_77973_b() == ModItems.BEETROOT_SEEDS.get() && ConfigBlocksItems.enableBeetroot) {
                    this.setAnimalInLove(animal, event.entityPlayer, stack);
                }
            } else if (ConfigEntities.enableBabyGrowthBoost && this.isFoodItem(animal, stack)) {
                this.feedBaby(animal, event.entityPlayer, stack);
            }
            if (animal instanceof EntitySheep) {
                EntitySheep sheep = (EntitySheep)animal;
                if (stack.func_77973_b() != Items.field_151100_aR && !animal.field_70170_p.field_72995_K) {
                    for (int oreID : OreDictionary.getOreIDs((ItemStack)stack)) {
                        int fleeceColour = ~ArrayUtils.indexOf((Object[])ModRecipes.ore_dyes, (Object)OreDictionary.getOreName((int)oreID)) & 0xF;
                        if (!ArrayUtils.contains((Object[])ModRecipes.ore_dyes, (Object)OreDictionary.getOreName((int)oreID)) || sheep.func_70896_n() == fleeceColour || sheep.func_70892_o()) continue;
                        sheep.func_70891_b(fleeceColour);
                        if (event.entityPlayer.field_71075_bZ.field_75098_d) break;
                        --stack.field_77994_a;
                        break;
                    }
                }
            }
        }
        if (target instanceof EntityCow && stack != null && ConfigSounds.horseEatCowMilk) {
            if (target instanceof EntityMooshroom && stack.func_77973_b() == Items.field_151054_z) {
                world.func_72908_a(target.field_70165_t, target.field_70163_u, target.field_70161_v, "minecraft_1.21:entity.mooshroom.milk", 1.0f, 0.9f + (float)(world.field_73012_v.nextInt(3) - 1) * 0.1f);
            } else if (stack.func_77973_b() == Items.field_151133_ar) {
                world.func_72908_a(target.field_70165_t, target.field_70163_u, target.field_70161_v, "minecraft_1.21:entity.cow.milk", 1.0f, 1.0f);
            }
            return;
        }
        if (ConfigSounds.paintingItemFramePlacing && target instanceof EntityItemFrame) {
            EntityItemFrame itemframe = (EntityItemFrame)target;
            if (stack != null && itemframe.func_82335_i() == null) {
                world.func_72908_a(target.field_70165_t, target.field_70163_u, target.field_70161_v, "minecraft_1.21:entity.item_frame.add_item", 1.0f, 1.0f);
            } else if (itemframe.func_82335_i() != null) {
                world.func_72908_a(target.field_70165_t, target.field_70163_u, target.field_70161_v, "minecraft_1.21:entity.item_frame.rotate_item", 1.0f, 1.0f);
            }
            return;
        }
        if (ConfigSounds.leashSounds && target instanceof EntityLeashKnot) {
            world.func_72908_a(target.field_70165_t + 0.5, target.field_70163_u + 0.5, target.field_70161_v + 0.5, "minecraft_1.21:entity.leash_knot.break", 1.0f, 1.0f);
        }
    }

    private void setAnimalInLove(EntityAnimal animal, EntityPlayer player, ItemStack stack) {
        if (!animal.func_70880_s()) {
            animal.func_146082_f(player);
            if (!player.field_71075_bZ.field_75098_d && --stack.field_77994_a <= 0) {
                player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, null);
            }
        }
    }

    private void feedBaby(EntityAnimal animal, EntityPlayer player, ItemStack stack) {
        int currentAge = animal.func_70874_b();
        int age = (int)((float)(-currentAge) * 0.1f);
        animal.func_70873_a(currentAge + age);
        player.func_71038_i();
        Random itemRand = animal.field_70170_p.field_73012_v;
        for (int i = 0; i < 3; ++i) {
            double d0 = itemRand.nextGaussian() * 0.02;
            double d1 = itemRand.nextGaussian() * 0.02;
            double d2 = itemRand.nextGaussian() * 0.02;
            animal.field_70170_p.func_72869_a("happyVillager", animal.field_70165_t + (double)itemRand.nextFloat() * 0.5, animal.field_70163_u + 0.5 + (double)itemRand.nextFloat() * 0.5, animal.field_70161_v + (double)itemRand.nextFloat() * 0.5, d0, d1, d2);
        }
        if (!player.field_71075_bZ.field_75098_d && --stack.field_77994_a <= 0) {
            player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, null);
        }
    }

    private boolean isFoodItem(EntityAnimal animal, ItemStack food) {
        if (animal.func_70877_b(food)) {
            return true;
        }
        if (animal instanceof EntityPig && food.func_77973_b() == ModItems.BEETROOT.get() && ConfigBlocksItems.enableBeetroot) {
            return true;
        }
        return animal instanceof EntityChicken && food.func_77973_b() == ModItems.BEETROOT_SEEDS.get() && ConfigBlocksItems.enableBeetroot;
    }

    private float applyArmorCalculations(EntityLivingBase entity, DamageSource p_70655_1_, float p_70655_2_) {
        if (!p_70655_1_.func_76363_c()) {
            int i = 25 - entity.func_70658_aO();
            float f1 = p_70655_2_ * (float)i;
            p_70655_2_ = f1 / 25.0f;
        }
        return p_70655_2_;
    }

    private float applyPotionDamageCalculations(EntityLivingBase entity, DamageSource p_70672_1_, float p_70672_2_) {
        float f1;
        int j;
        int i;
        if (p_70672_1_.func_151517_h()) {
            return p_70672_2_;
        }
        if (entity.func_70644_a(Potion.field_76429_m) && p_70672_1_ != DamageSource.field_76380_i) {
            i = (entity.func_70660_b(Potion.field_76429_m).func_76458_c() + 1) * 5;
            j = 25 - i;
            f1 = p_70672_2_ * (float)j;
            p_70672_2_ = f1 / 25.0f;
        }
        if (p_70672_2_ <= 0.0f) {
            return 0.0f;
        }
        i = EnchantmentHelper.func_77508_a((ItemStack[])entity.func_70035_c(), (DamageSource)p_70672_1_);
        if (i > 20) {
            i = 20;
        }
        if (i > 0) {
            j = 25 - i;
            f1 = p_70672_2_ * (float)j;
            p_70672_2_ = f1 / 25.0f;
        }
        return p_70672_2_;
    }

    @SubscribeEvent
    public void entityStruckByLightning(EntityStruckByLightningEvent event) {
        Entity entity;
        if (ConfigEntities.enableVillagerTurnsIntoWitch && (entity = event.entity) instanceof EntityVillager) {
            EntityVillager villager = (EntityVillager)entity;
            if (!villager.field_70170_p.field_72995_K) {
                EntityWitch witch = new EntityWitch(villager.field_70170_p);
                witch.func_82149_j((Entity)villager);
                witch.func_110161_a(null);
                villager.field_70170_p.func_72838_d((Entity)witch);
                villager.func_70106_y();
            }
        } else if (ConfigEntities.enableBrownMooshroom && event.entity.field_70173_aa > 40 && event.entity.getClass() == EntityMooshroom.class) {
            EntityMooshroom mooshroom = (EntityMooshroom)event.entity;
            if (!mooshroom.field_70170_p.field_72995_K) {
                EntityBrownMooshroom brownmooshroom = new EntityBrownMooshroom(mooshroom.field_70170_p);
                brownmooshroom.func_82149_j((Entity)mooshroom);
                brownmooshroom.func_110161_a(null);
                mooshroom.field_70170_p.func_72838_d((Entity)brownmooshroom);
                brownmooshroom.func_85030_a("minecraft_1.21:entity.mooshroom.convert", 1.0f, 1.0f);
                mooshroom.func_70106_y();
            }
        } else if (ConfigEntities.enableBrownMooshroom && event.entity.field_70173_aa > 40 && event.entity.getClass() == EntityBrownMooshroom.class) {
            EntityBrownMooshroom brownmooshroom = (EntityBrownMooshroom)event.entity;
            if (!brownmooshroom.field_70170_p.field_72995_K) {
                EntityMooshroom mooshroom = new EntityMooshroom(brownmooshroom.field_70170_p);
                mooshroom.func_82149_j((Entity)brownmooshroom);
                mooshroom.func_110161_a(null);
                brownmooshroom.field_70170_p.func_72838_d((Entity)mooshroom);
                mooshroom.func_85030_a("minecraft_1.21:entity.mooshroom.convert", 1.0f, 1.0f);
                brownmooshroom.func_70106_y();
            }
        }
    }

    @SubscribeEvent
    public void livingHurtEvent(LivingHurtEvent event) {
        block25: {
            int time;
            EntityLivingBase target;
            block26: {
                boolean inkSound;
                EntityLivingBase targetEntity = event.entityLiving;
                if (targetEntity == null) {
                    return;
                }
                if (ConfigFunctions.enableHayBaleFalls && targetEntity.field_70170_p.func_147439_a(MathHelper.func_76128_c((double)targetEntity.field_70165_t), MathHelper.func_76128_c((double)(targetEntity.field_70163_u - (double)0.2f - (double)targetEntity.field_70129_M)), MathHelper.func_76128_c((double)targetEntity.field_70161_v)) == Blocks.field_150407_cf && event.source == DamageSource.field_76379_h) {
                    event.ammount *= (float)ConfigFunctions.hayBaleReducePercent / 100.0f;
                }
                if (ConfigSounds.combatSounds && event.source.field_76373_n.equals("player")) {
                    EntityPlayer playerSource = (EntityPlayer)event.source.func_76346_g();
                    World world = playerSource.field_70170_p;
                    double x = targetEntity.field_70165_t;
                    double y = targetEntity.field_70163_u;
                    double z = targetEntity.field_70161_v;
                    if (targetEntity.func_70075_an() && !targetEntity.func_85031_j((Entity)playerSource)) {
                        float attackDamage = (float)playerSource.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111126_e();
                        float enchantmentDamage = 0.0f;
                        enchantmentDamage = EnchantmentHelper.func_77512_a((EntityLivingBase)playerSource, (EntityLivingBase)targetEntity);
                        if (attackDamage > 0.0f || enchantmentDamage > 0.0f) {
                            boolean targetTakesDamage;
                            boolean isStrongAttack;
                            boolean bl = isStrongAttack = playerSource.func_70694_bm() != null && event.ammount >= ConfigSounds.combatSoundStrongThreshold;
                            if (playerSource.func_70051_ag()) {
                                world.func_72908_a(x, y, z, "minecraft_1.21:entity.player.attack.knockback", 1.0f, 1.0f);
                            }
                            boolean isCriticalHit = targetEntity instanceof EntityLivingBase && playerSource.field_70143_R > 0.0f && !playerSource.field_70122_E && !playerSource.func_70617_f_() && !playerSource.func_70090_H() && !playerSource.func_70644_a(Potion.field_76440_q) && playerSource.field_70154_o == null;
                            boolean bl2 = targetTakesDamage = !targetEntity.func_85032_ar() && event.ammount > 0.0f;
                            if (targetTakesDamage) {
                                if (isCriticalHit) {
                                    world.func_72908_a(x, y, z, "minecraft_1.21:entity.player.attack.crit", 1.0f, 1.0f);
                                }
                                if (!isCriticalHit) {
                                    if (isStrongAttack) {
                                        world.func_72908_a(x, y, z, "minecraft_1.21:entity.player.attack.strong", 1.0f, 1.0f);
                                    } else {
                                        world.func_72908_a(x, y, z, "minecraft_1.21:entity.player.attack.weak", 1.0f, 1.0f);
                                    }
                                }
                            } else {
                                world.func_72908_a(x, y, z, "minecraft_1.21:entity.player.attack.nodamage", 1.0f, 1.0f);
                            }
                        }
                    }
                }
                if (ConfigBlocksItems.enableTotemUndying) {
                    this.handleTotemCheck(targetEntity, event);
                }
                if (!EntitySquid.class.equals(targetEntity.getClass())) break block25;
                World w = targetEntity.field_70170_p;
                Random r = w.field_73012_v;
                boolean bl = inkSound = ConfigEntities.enableSquidInk || ConfigTweaks.squidsBlindPlayers;
                if (!inkSound || !(r.nextDouble() < 0.15) || !(w instanceof WorldServer)) break block25;
                WorldServer serverWorld = (WorldServer)w;
                if (!targetEntity.func_70090_H()) break block25;
                AxisAlignedBB eBox = targetEntity.field_70121_D;
                double cx = eBox.field_72336_d - 0.5 * (eBox.field_72336_d - eBox.field_72340_a);
                double cy = eBox.field_72337_e - 0.5 * (eBox.field_72337_e - eBox.field_72338_b);
                double cz = eBox.field_72334_f - 0.5 * (eBox.field_72334_f - eBox.field_72339_c);
                AxisAlignedBB box = AxisAlignedBB.func_72330_a((double)-1.5, (double)-1.5, (double)-1.5, (double)1.5, (double)1.5, (double)1.5).func_72317_d(cx, cy, cz);
                List around = w.func_72872_a(EntityLivingBase.class, box);
                if (around.isEmpty() || (target = (EntityLivingBase)around.get(r.nextInt(around.size()))) == null || target == targetEntity) break block25;
                if (ConfigEntities.enableSquidInk) {
                    serverWorld.func_147487_a("largesmoke", cx, cy, cz, 5, 0.0, 0.0, 0.0, 0.08);
                }
                if (ConfigMixins.newMobSounds) {
                    float pitch = (r.nextFloat() - r.nextFloat()) * 0.2f + (target.func_70631_g_() ? 1.5f : 1.0f);
                    w.func_72956_a((Entity)target, "minecraft_1.21:entity.squid.squirt", 0.4f, pitch);
                }
                if (!target.func_70090_H() || !ConfigTweaks.squidsBlindPlayers) break block25;
                PotionEffect activeEff = target.func_70660_b(Potion.field_76440_q);
                time = 20 + r.nextInt(300);
                if (activeEff == null) break block26;
                if (activeEff.func_76458_c() > 0) break block25;
                time += activeEff.func_76459_b();
            }
            target.func_70690_d(new PotionEffect(Potion.field_76440_q.field_76415_H, time));
        }
        if (event.source instanceof EntityDamageSource) {
            if (ConfigWorld.enableDmgIndicator) {
                EntityDamageSource src;
                Entity attacker;
                int amount = MathHelper.func_76141_d((float)(Math.min(event.entityLiving.func_110143_aJ(), event.ammount) / 2.0f));
                amount = (int)this.applyArmorCalculations(event.entityLiving, event.source, amount);
                amount = (int)this.applyPotionDamageCalculations(event.entityLiving, event.source, amount);
                if ((amount = Math.min(amount, 25)) > 0 && (attacker = (src = (EntityDamageSource)event.source).func_76364_f()) instanceof EntityPlayer) {
                    EntityPlayer player = (EntityPlayer)attacker;
                    if (!(attacker instanceof FakePlayer)) {
                        Vec3 look = player.func_70040_Z();
                        look.func_72442_b(1.5707964f);
                        for (int i = 0; i < amount; ++i) {
                            double x = event.entityLiving.field_70165_t - 0.35 * look.field_72450_a / 2.0 * look.field_72450_a + (double)(i / 3);
                            double y = event.entityLiving.field_70163_u + (double)event.entityLiving.field_70131_O * 0.75;
                            double z = event.entityLiving.field_70161_v - 0.35 * look.field_72449_c / 2.0 * look.field_72449_c + (double)(i / 3);
                            EtFuturum.networkWrapper.sendToAllAround((IMessage)new BlackHeartParticlesMessage(x, y, z), new NetworkRegistry.TargetPoint(player.field_70170_p.field_73011_w.field_76574_g, x, y, z, 64.0));
                        }
                    }
                }
            }
            if (ConfigSounds.thornsSounds && event.source.func_76355_l().equals("thorns")) {
                event.entity.field_70170_p.func_72956_a(event.entity, "minecraft_1.21:enchant.thorns.hit", 1.0f, 1.0f);
            }
        }
    }

    public void handleTotemCheck(EntityLivingBase entity, LivingHurtEvent event) {
        if (entity.func_110143_aJ() > (float)Math.round(event.ammount)) {
            return;
        }
        if (entity.func_70694_bm() == null || entity.func_70694_bm().func_77973_b() != ModItems.TOTEM_OF_UNDYING.get()) {
            return;
        }
        if (entity instanceof EntityLiving || entity instanceof EntityPlayer) {
            entity.field_70170_p.func_72908_a(entity.field_70165_t + 0.5, entity.field_70163_u + 0.5, entity.field_70161_v + 0.5, "minecraft_1.21:item.totem.use", 1.0f, entity.field_70170_p.field_73012_v.nextFloat() * 0.1f + 0.9f);
            entity.func_70674_bp();
            float healpercent = (float)ConfigFunctions.totemHealPercent / 100.0f;
            float sethp = entity.func_110138_aP() * healpercent;
            entity.func_70606_j(Math.max(sethp, 0.5f));
            event.ammount = 0.0f;
            entity.func_70690_d(new PotionEffect(Potion.field_76428_l.field_76415_H, 900, 1));
            entity.func_70690_d(new PotionEffect(Potion.field_76426_n.field_76415_H, 800, 1));
            entity.func_70690_d(new PotionEffect(Potion.field_76444_x.field_76415_H, 100, 1));
            if (entity instanceof EntityLiving) {
                entity.func_70062_b(0, null);
            }
            if (entity instanceof EntityPlayer) {
                ((EntityPlayer)entity).func_145747_a((IChatComponent)new ChatComponentText(StatCollector.func_74838_a((String)"util.totemBreak")));
                ((EntityPlayer)entity).func_71028_bD();
            }
        }
    }

    @SubscribeEvent
    public void onDrops(BlockEvent.HarvestDropsEvent event) {
        if (event.block == Blocks.field_150334_T) {
            if (ModBlocks.SMOOTH_STONE.isEnabled() && event.blockMetadata == 8) {
                event.drops.clear();
                event.drops.add(ModBlocks.SMOOTH_STONE.newItemStack(1));
            } else if (ModBlocks.SMOOTH_SANDSTONE.isEnabled() && event.blockMetadata == 9) {
                event.drops.clear();
                event.drops.add(ModBlocks.SMOOTH_SANDSTONE.newItemStack(1));
            } else if (ModBlocks.SMOOTH_QUARTZ.isEnabled() && event.blockMetadata == 15) {
                event.drops.clear();
                event.drops.add(ModBlocks.SMOOTH_QUARTZ.newItemStack(1));
            }
        }
    }

    @SubscribeEvent
    public void loadWorldEvent(WorldEvent.Load event) {
        event.world.func_72954_a((IWorldAccess)new EtFuturumWorldListener(event.world));
        if (ConfigMixins.enableDoWeatherCycle) {
            DoWeatherCycle.registerGamerule(event.world);
        }
        if (ConfigMixins.enablePlayersSleepingPecentageGamerule) {
            PlayersSleepingPercentage.registerGamerule(event.world);
        }
        if (ConfigMixins.enableRandomTickSpeed) {
            RandomTickSpeed.registerGamerule(event.world);
        }
    }

    @SubscribeEvent
    public void onItemToss(ItemTossEvent event) {
        droppedEntityItems.put((Object)event.entityItem, (Object)event.player);
        if (ConfigMixins.avoidDroppingItemsWhenClosing && event.player instanceof EntityPlayerMP && playersClosedContainers.contains(event.player) && event.player.field_71071_by.func_70441_a(event.entityItem.func_92059_d())) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onTickEnd(TickEvent.ServerTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            playersClosedContainers.clear();
        }
    }

    @SubscribeEvent
    public void postPlayerTick(TickEvent.PlayerTickEvent e) {
        if (e.phase == TickEvent.Phase.END) {
            if (ConfigFunctions.enableAttackedAtYawFix && !e.player.field_70170_p.field_72995_K && e.player instanceof EntityPlayerMP) {
                if (!this.lastAttackedAtYaw.containsKey(e.player)) {
                    this.lastAttackedAtYaw.put(e.player, new MutableFloat(e.player.field_70739_aP));
                }
                if (Math.abs(this.lastAttackedAtYaw.get(e.player).floatValue() - e.player.field_70739_aP) > 0.05f) {
                    EtFuturum.networkWrapper.sendTo((IMessage)new AttackYawMessage(e.player.field_70739_aP), (EntityPlayerMP)e.player);
                    this.lastAttackedAtYaw.get(e.player).setValue(e.player.field_70739_aP);
                }
            }
            if (ConfigMixins.enableElytra) {
                boolean isElytraFlying = ((IElytraPlayer)e.player).etfu$isElytraFlying();
                if (e.player instanceof EntityPlayerMP && isElytraFlying) {
                    ((EntityPlayerMP)e.player).field_71135_a.field_147365_f = 0;
                }
                if (isElytraFlying != ((IElytraPlayer)e.player).etfu$lastElytraFlying()) {
                    float f1;
                    float f = 0.6f;
                    float f2 = f1 = isElytraFlying ? 0.6f : 1.8f;
                    if (f != e.player.field_70130_N || f1 != e.player.field_70131_O) {
                        float f22 = e.player.field_70130_N;
                        e.player.field_70130_N = f;
                        e.player.field_70131_O = f1;
                        e.player.field_70121_D.func_72324_b(e.player.field_70121_D.field_72340_a, e.player.field_70121_D.field_72338_b, e.player.field_70121_D.field_72339_c, e.player.field_70121_D.field_72340_a + (double)e.player.field_70130_N, e.player.field_70121_D.field_72338_b + (double)e.player.field_70131_O, e.player.field_70121_D.field_72339_c + (double)e.player.field_70130_N);
                        if (e.player.field_70130_N > f22 && !e.player.field_70170_p.field_72995_K) {
                            e.player.func_70091_d((double)(f22 - e.player.field_70130_N), 0.0, (double)(f22 - e.player.field_70130_N));
                        }
                    }
                    ((IElytraPlayer)e.player).etfu$setLastElytraFlying(isElytraFlying);
                }
            }
        }
    }

    @SubscribeEvent
    public void onExplosion(ExplosionEvent kaboom) {
        EntityCreeper creeper;
        Collection collection;
        Entity entity;
        if (ConfigBlocksItems.enableLingeringPotions && !kaboom.world.field_72995_K && (entity = kaboom.explosion.field_77283_e) instanceof EntityCreeper && !(collection = (creeper = (EntityCreeper)entity).func_70651_bq()).isEmpty()) {
            ItemStack potion = new ItemStack(ModItems.LINGERING_POTION.get());
            NBTTagCompound compound1 = new NBTTagCompound();
            NBTTagList potionList = new NBTTagList();
            for (PotionEffect potioneffect : collection) {
                NBTTagCompound compound2 = new NBTTagCompound();
                potioneffect.func_82719_a(compound2);
                potionList.func_74742_a((NBTBase)compound2);
            }
            compound1.func_74782_a("CustomPotionEffects", (NBTBase)potionList);
            potion.func_77982_d(compound1);
            EntityLingeringEffect entityareaeffectcloud = new EntityLingeringEffect(kaboom.world, potion, (EntityLivingBase)creeper);
            entityareaeffectcloud.func_70107_b(creeper.field_70165_t, creeper.field_70163_u, creeper.field_70161_v);
            entityareaeffectcloud.setColorOverride(PotionHelper.func_77911_a((Collection)collection));
            kaboom.world.func_72838_d((Entity)entityareaeffectcloud);
        }
    }

    @SubscribeEvent
    public void onPreWorldTick(TickEvent.WorldTickEvent e) {
        if (e.phase == TickEvent.Phase.START && e.side == Side.SERVER) {
            if (ModBlocks.CONCRETE_POWDER.isEnabled() && ModBlocks.CONCRETE.isEnabled()) {
                this.doConcreteTracking();
            }
            if (ConfigMixins.enableDoWeatherCycle) {
                DoWeatherCycle.INSTANCE.isWorldTickInProgress = true;
                DoWeatherCycle.INSTANCE.isCommandInProgress = false;
            }
        }
    }

    @SubscribeEvent
    public void onPostWorldTick(TickEvent.WorldTickEvent e) {
        Object object;
        if (ConfigMixins.enableElytra && e.phase == TickEvent.Phase.END && (object = e.world) instanceof WorldServer) {
            WorldServer ws = (WorldServer)object;
            for (EntityTrackerEntry ete : ws.func_73039_n().field_72793_b) {
                Entity entity;
                if (ete == null || !((entity = ete.field_73132_a) instanceof IElytraPlayer)) continue;
                IElytraPlayer elb = (IElytraPlayer)entity;
                boolean flying = elb.etfu$isElytraFlying();
                if (!flying && ((IElytraEntityTrackerEntry)ete).etfu$getWasSendingVelUpdates()) {
                    ete.field_73143_t = false;
                    continue;
                }
                if (!flying) continue;
                if (!ete.field_73143_t) {
                    ((IElytraEntityTrackerEntry)ete).etfu$setWasSendingVelUpdates(true);
                }
                ete.field_73143_t = true;
            }
        }
        if (ConfigMixins.enableDoWeatherCycle && e.phase == TickEvent.Phase.END && e.side == Side.SERVER) {
            DoWeatherCycle.INSTANCE.isWorldTickInProgress = false;
        }
    }

    private void doConcreteTracking() {
        Iterator<EntityFallingBlock> iterator = fallingConcreteBlocks.iterator();
        while (iterator.hasNext()) {
            EntityFallingBlock block = iterator.next();
            if (!block.field_70128_L) {
                int i = MathHelper.func_76128_c((double)block.field_70165_t);
                int j = MathHelper.func_76128_c((double)block.field_70163_u);
                int k = MathHelper.func_76128_c((double)block.field_70161_v);
                for (int jOff = 0; jOff <= (block.field_70181_x < -1.0 ? 1 : 0); ++jOff) {
                    if (block.field_70170_p.func_147439_a(i, j - jOff, k).func_149688_o() != Material.field_151586_h) continue;
                    block.field_70170_p.func_147465_d(i, j - jOff, k, ModBlocks.CONCRETE.get(), block.field_145814_a, 3);
                    block.func_70106_y();
                    iterator.remove();
                }
                continue;
            }
            iterator.remove();
        }
    }

    @SubscribeEvent
    public void fuelBurnTime(FuelBurnTimeEvent e) {
        if (e.fuel == null || e.fuel.func_77973_b() == null || Item.field_150901_e.func_148750_c((Object)e.fuel.func_77973_b()) == null) {
            return;
        }
        this.initFurnaceModifiers();
        if (this.noBurnItems.contains(e.fuel)) {
            e.burnTime = 0;
            e.setResult(Event.Result.DENY);
            return;
        }
        Integer time = this.burnTimeRemappings.get(e.fuel);
        if (time != null) {
            e.burnTime = time;
            e.setResult(Event.Result.ALLOW);
        }
    }

    private void initFurnaceModifiers() {
        if (!this.initNoBurnItems.getAndSet(true)) {
            this.noBurnItems.add(ModBlocks.WOOD_PLANKS.newItemStack(1, 0));
            this.noBurnItems.add(ModBlocks.WOOD_PLANKS.newItemStack(1, 1));
            this.noBurnItems.add(ModBlocks.WOOD_FENCE.newItemStack(1, 0));
            this.noBurnItems.add(ModBlocks.WOOD_FENCE.newItemStack(1, 1));
            this.noBurnItems.add(ModBlocks.WOOD_SLAB.newItemStack(1, 0));
            this.noBurnItems.add(ModBlocks.WOOD_SLAB.newItemStack(1, 1));
            this.noBurnItems.add(ModBlocks.WOOD_SLAB.newItemStack(1, 8));
            this.noBurnItems.add(ModBlocks.WOOD_SLAB.newItemStack(1, 9));
            this.noBurnItems.add(ModBlocks.DOUBLE_WOOD_SLAB.newItemStack(1, 0));
            this.noBurnItems.add(ModBlocks.DOUBLE_WOOD_SLAB.newItemStack(1, 1));
            this.noBurnItems.add(ModBlocks.DOUBLE_WOOD_SLAB.newItemStack(1, 8));
            this.noBurnItems.add(ModBlocks.DOUBLE_WOOD_SLAB.newItemStack(1, 9));
            this.noBurnItems.add(ModBlocks.CRIMSON_STEM.newItemStack(1, Short.MAX_VALUE));
            this.noBurnItems.add(ModBlocks.WARPED_STEM.newItemStack(1, Short.MAX_VALUE));
            this.noBurnItems.add(ModBlocks.CRIMSON_STAIRS.newItemStack(1, Short.MAX_VALUE));
            this.noBurnItems.add(ModBlocks.WARPED_STAIRS.newItemStack(1, Short.MAX_VALUE));
            this.noBurnItems.add(ModBlocks.CRIMSON_FENCE_GATE.newItemStack(1, Short.MAX_VALUE));
            this.noBurnItems.add(ModBlocks.WARPED_FENCE_GATE.newItemStack(1, Short.MAX_VALUE));
            this.noBurnItems.add(ModBlocks.CRIMSON_BUTTON.newItemStack(1, Short.MAX_VALUE));
            this.noBurnItems.add(ModBlocks.WARPED_BUTTON.newItemStack(1, Short.MAX_VALUE));
            this.noBurnItems.add(ModBlocks.CRIMSON_PRESSURE_PLATE.newItemStack(1, Short.MAX_VALUE));
            this.noBurnItems.add(ModBlocks.WARPED_PRESSURE_PLATE.newItemStack(1, Short.MAX_VALUE));
            this.noBurnItems.add(ModBlocks.CRIMSON_DOOR.newItemStack(1, Short.MAX_VALUE));
            this.noBurnItems.add(ModBlocks.WARPED_DOOR.newItemStack(1, Short.MAX_VALUE));
            this.noBurnItems.add(ModBlocks.CRIMSON_TRAPDOOR.newItemStack(1, Short.MAX_VALUE));
            this.noBurnItems.add(ModBlocks.WARPED_TRAPDOOR.newItemStack(1, Short.MAX_VALUE));
            this.noBurnItems.add(ModBlocks.CRIMSON_SIGN.newItemStack(1, Short.MAX_VALUE));
            this.noBurnItems.add(ModBlocks.WARPED_SIGN.newItemStack(1, Short.MAX_VALUE));
            for (ModBlocks bed : ModBlocks.BEDS) {
                if (!bed.isEnabled()) continue;
                this.noBurnItems.add(bed.newItemStack());
            }
        }
        if (!this.initBurnTimeRemappings.getAndSet(true)) {
            this.burnTimeRemappings.put(ModItems.BAMBOO.newItemStack(1, Short.MAX_VALUE), 50);
        }
    }

    @SubscribeEvent
    public void onWorldLoad(WorldEvent.Load e) {
        if (ConfigMixins.enableElytra) {
            e.world.func_82736_K().func_82769_a("disableElytraMovementCheck", "false");
        }
    }

    static MovingObjectPosition getMovingObjectPositionFromPlayer(World worldIn, EntityPlayer playerIn, boolean useLiquids) {
        float f = 1.0f;
        float f1 = playerIn.field_70127_C + (playerIn.field_70125_A - playerIn.field_70127_C) * f;
        float f2 = playerIn.field_70126_B + (playerIn.field_70177_z - playerIn.field_70126_B) * f;
        double d0 = playerIn.field_70169_q + (playerIn.field_70165_t - playerIn.field_70169_q) * (double)f;
        double d1 = playerIn.field_70167_r + (playerIn.field_70163_u - playerIn.field_70167_r) * (double)f + (double)(worldIn.field_72995_K ? playerIn.func_70047_e() - playerIn.getDefaultEyeHeight() : playerIn.func_70047_e());
        double d2 = playerIn.field_70166_s + (playerIn.field_70161_v - playerIn.field_70166_s) * (double)f;
        Vec3 vec3 = Vec3.func_72443_a((double)d0, (double)d1, (double)d2);
        float f3 = MathHelper.func_76134_b((float)(-f2 * ((float)Math.PI / 180) - (float)Math.PI));
        float f4 = MathHelper.func_76126_a((float)(-f2 * ((float)Math.PI / 180) - (float)Math.PI));
        float f5 = -MathHelper.func_76134_b((float)(-f1 * ((float)Math.PI / 180)));
        float f6 = MathHelper.func_76126_a((float)(-f1 * ((float)Math.PI / 180)));
        float f7 = f4 * f5;
        float f8 = f3 * f5;
        double d3 = 5.0;
        if (playerIn instanceof EntityPlayerMP) {
            d3 = ((EntityPlayerMP)playerIn).field_71134_c.getBlockReachDistance();
        }
        Vec3 vec31 = vec3.func_72441_c((double)f7 * d3, (double)f6 * d3, (double)f8 * d3);
        return worldIn.func_147447_a(vec3, vec31, useLiquids, !useLiquids, false);
    }
}

