/*
 * Decompiled with CFR 0.152.
 */
package ganymedes01.etfuturum.blocks;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import ganymedes01.etfuturum.EtFuturum;
import ganymedes01.etfuturum.blocks.BaseBlock;
import ganymedes01.etfuturum.client.sound.ModSounds;
import ganymedes01.etfuturum.lib.RenderIDs;
import java.util.ArrayList;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemShears;
import net.minecraft.item.ItemStack;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.IShearable;

public class BlockWeepingVines
extends BaseBlock
implements IShearable {
    private IIcon topIcon;

    public BlockWeepingVines() {
        super(Material.field_151585_k);
        this.setBlockSound(ModSounds.soundWeepingVines);
        this.setNames("weeping_vines");
        this.func_149647_a(EtFuturum.creativeTabBlocks);
        this.func_149675_a(true);
    }

    public void func_149674_a(World world, int x, int y, int z, Random rand) {
        super.func_149674_a(world, x, y, z, rand);
        if (rand.nextFloat() <= 0.1f && world.func_72805_g(x, y, z) == 0 && world.func_147439_a(x, y - 1, z).func_149688_o() == Material.field_151579_a) {
            for (int i = 1; i <= 25 && world.func_147439_a(x, y + i, z) == this; ++i) {
                if (i != 25) continue;
                return;
            }
            world.func_147465_d(x, y - 1, z, (Block)this, 0, 2);
        }
    }

    public boolean isLadder(IBlockAccess world, int x, int y, int z, EntityLivingBase entity) {
        return true;
    }

    public int quantityDropped(int meta, int fortune, Random random) {
        if ((this.harvesters.get() == null || ((EntityPlayer)this.harvesters.get()).func_70694_bm() != null && !(((EntityPlayer)this.harvesters.get()).func_70694_bm().func_77973_b() instanceof ItemShears)) && random.nextFloat() < 0.33f + (float)fortune * 0.22f) {
            return 1;
        }
        return 0;
    }

    public int func_149745_a(Random random) {
        return this.quantityDropped(0, 0, random);
    }

    public boolean func_149742_c(World world, int x, int y, int z) {
        return world.func_147439_a(x, y + 1, z).func_149662_c() || world.func_147439_a(x, y + 1, z) == this;
    }

    public boolean func_149718_j(World world, int x, int y, int z) {
        return this.func_149742_c(world, x, y, z);
    }

    public void func_149695_a(World worldIn, int x, int y, int z, Block neighbor) {
        super.func_149695_a(worldIn, x, y, z, neighbor);
        if (!this.func_149718_j(worldIn, x, y, z)) {
            this.setVineToAir(worldIn, x, y, z);
        }
    }

    public void setVineToAir(World world, int x, int y, int z) {
        if (!world.field_72995_K) {
            this.func_149697_b(world, x, y, z, 0, 0);
            world.func_147468_f(x, y, z);
        }
    }

    public void func_149719_a(IBlockAccess world, int x, int y, int z) {
        if (world.func_147439_a(x, y - 1, z) == this) {
            this.func_149676_a(0.1f, 0.0f, 0.1f, 0.9f, 1.0f, 0.9f);
        } else {
            this.func_149676_a(0.25f, 0.6f, 0.25f, 0.75f, 1.0f, 0.75f);
        }
    }

    public AxisAlignedBB func_149633_g(World world, int x, int y, int z) {
        this.func_149719_a((IBlockAccess)world, x, y, z);
        return super.func_149633_g(world, x, y, z);
    }

    public AxisAlignedBB func_149668_a(World worldIn, int x, int y, int z) {
        return null;
    }

    public boolean func_149662_c() {
        return false;
    }

    public boolean func_149686_d() {
        return false;
    }

    public int func_149645_b() {
        return RenderIDs.EXTENDED_CROSSED_SQUARES;
    }

    public boolean isShearable(ItemStack item, IBlockAccess world, int x, int y, int z) {
        return true;
    }

    public ArrayList<ItemStack> onSheared(ItemStack item, IBlockAccess world, int x, int y, int z, int fortune) {
        ArrayList<ItemStack> ret = new ArrayList<ItemStack>();
        ret.add(new ItemStack((Block)this, 1, world.func_72805_g(x, y, z)));
        return ret;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister reg) {
        this.field_149761_L = reg.func_94245_a(this.func_149641_N() + "_plant");
        this.topIcon = reg.func_94245_a(this.func_149641_N());
    }

    public IIcon func_149673_e(IBlockAccess world, int x, int y, int z, int meta) {
        if (world.func_147439_a(x, y - 1, z) != this) {
            return this.topIcon;
        }
        return this.field_149761_L;
    }
}

