/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevescarts;

import com.google.common.io.ByteArrayDataInput;
import com.google.common.io.ByteStreams;
import cpw.mods.fml.client.FMLClientHandler;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.network.FMLNetworkEvent;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.network.internal.FMLProxyPacket;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.ContainerPlayer;
import net.minecraft.network.NetHandlerPlayServer;
import net.minecraft.world.World;
import vswe.stevescarts.Blocks.BlockCartAssembler;
import vswe.stevescarts.Blocks.ModBlocks;
import vswe.stevescarts.Carts.MinecartModular;
import vswe.stevescarts.Containers.ContainerBase;
import vswe.stevescarts.Containers.ContainerMinecart;
import vswe.stevescarts.Modules.ModuleBase;
import vswe.stevescarts.StevesCarts;
import vswe.stevescarts.TileEntities.TileEntityBase;

public class PacketHandler {
    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void onClientPacket(FMLNetworkEvent.ClientCustomPacketEvent event) {
        EntityClientPlayerMP player = FMLClientHandler.instance().getClient().field_71439_g;
        int idForCrash = -1;
        try {
            byte[] bytes = event.packet.payload().array();
            ByteArrayDataInput reader = ByteStreams.newDataInput((byte[])bytes);
            byte id = reader.readByte();
            idForCrash = id;
            if (id == -1) {
                int x = reader.readInt();
                int y = reader.readInt();
                int z = reader.readInt();
                int len = bytes.length - 13;
                byte[] data = new byte[len];
                for (int i = 0; i < len; ++i) {
                    data[i] = reader.readByte();
                }
                World world = player.field_70170_p;
                ((BlockCartAssembler)ModBlocks.CART_ASSEMBLER.getBlock()).updateMultiBlock(world, x, y, z);
            } else {
                int entityid = reader.readInt();
                int len = bytes.length - 5;
                byte[] data = new byte[len];
                for (int i = 0; i < len; ++i) {
                    data[i] = reader.readByte();
                }
                World world = player.field_70170_p;
                MinecartModular cart = this.getCart(entityid, world);
                if (cart != null) {
                    this.receivePacketAtCart(cart, id, data, (EntityPlayer)player);
                }
            }
        }
        catch (Exception ex) {
            System.out.println("The client failed to process a packet with " + (idForCrash == -1 ? "unknown id" : "id " + idForCrash));
        }
    }

    @SubscribeEvent
    public void onServerPacket(FMLNetworkEvent.ServerCustomPacketEvent event) {
        EntityPlayerMP player = ((NetHandlerPlayServer)event.handler).field_147369_b;
        int idForCrash = -1;
        try {
            byte[] bytes = event.packet.payload().array();
            ByteArrayDataInput reader = ByteStreams.newDataInput((byte[])bytes);
            byte id = reader.readByte();
            idForCrash = id;
            World world = player.field_70170_p;
            if (player.field_71070_bA instanceof ContainerPlayer) {
                int entityid = reader.readInt();
                int len = bytes.length - 5;
                byte[] data = new byte[len];
                for (int i = 0; i < len; ++i) {
                    data[i] = reader.readByte();
                }
                MinecartModular cart = this.getCart(entityid, world);
                if (cart != null) {
                    this.receivePacketAtCart(cart, id, data, (EntityPlayer)player);
                }
            } else {
                ContainerBase conBase;
                TileEntityBase base;
                int len = bytes.length - 1;
                byte[] data = new byte[len];
                for (int i = 0; i < len; ++i) {
                    data[i] = reader.readByte();
                }
                Container con = player.field_71070_bA;
                if (con instanceof ContainerMinecart) {
                    ContainerMinecart conMC = (ContainerMinecart)con;
                    MinecartModular cart = conMC.cart;
                    this.receivePacketAtCart(cart, id, data, (EntityPlayer)player);
                } else if (con instanceof ContainerBase && (base = (conBase = (ContainerBase)con).getTileEntity()) != null) {
                    base.receivePacket(id, data, (EntityPlayer)player);
                }
            }
        }
        catch (Exception ex) {
            System.out.println("The server failed to process a packet with " + (idForCrash == -1 ? "unknown id" : "id " + idForCrash));
        }
    }

    private void receivePacketAtCart(MinecartModular cart, int id, byte[] data, EntityPlayer player) {
        for (ModuleBase module : cart.getModules()) {
            if (id < module.getPacketStart() || id >= module.getPacketStart() + module.totalNumberOfPackets()) continue;
            module.delegateReceivedPacket(id - module.getPacketStart(), data, player);
            break;
        }
    }

    private MinecartModular getCart(int ID, World world) {
        for (Object e : world.field_72996_f) {
            if (!(e instanceof Entity) || ((Entity)e).func_145782_y() != ID || !(e instanceof MinecartModular)) continue;
            return (MinecartModular)((Object)e);
        }
        return null;
    }

    public static void sendPacket(int id, byte[] extraData) {
        ByteArrayOutputStream bs = new ByteArrayOutputStream();
        DataOutputStream ds = new DataOutputStream(bs);
        try {
            ds.writeByte((byte)id);
            for (byte b : extraData) {
                ds.writeByte(b);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        StevesCarts.packetHandler.sendToServer(PacketHandler.createPacket(bs.toByteArray()));
    }

    private static FMLProxyPacket createPacket(byte[] bytes) {
        ByteBuf buf = Unpooled.copiedBuffer((byte[])bytes);
        return new FMLProxyPacket(buf, "SC2");
    }

    public static void sendPacket(MinecartModular cart, int id, byte[] extraData) {
        ByteArrayOutputStream bs = new ByteArrayOutputStream();
        DataOutputStream ds = new DataOutputStream(bs);
        try {
            ds.writeByte((byte)id);
            ds.writeInt(cart.func_145782_y());
            for (byte b : extraData) {
                ds.writeByte(b);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        StevesCarts.packetHandler.sendToServer(PacketHandler.createPacket(bs.toByteArray()));
    }

    public static void sendPacketToPlayer(int id, byte[] data, EntityPlayer player, MinecartModular cart) {
        ByteArrayOutputStream bs = new ByteArrayOutputStream();
        DataOutputStream ds = new DataOutputStream(bs);
        try {
            ds.writeByte((byte)id);
            ds.writeInt(cart.func_145782_y());
            for (byte b : data) {
                ds.writeByte(b);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        StevesCarts.packetHandler.sendTo(PacketHandler.createPacket(bs.toByteArray()), (EntityPlayerMP)player);
    }

    public static void sendBlockInfoToClients(World world, byte[] data, int x, int y, int z) {
        ByteArrayOutputStream bs = new ByteArrayOutputStream();
        DataOutputStream ds = new DataOutputStream(bs);
        try {
            ds.writeByte(-1);
            ds.writeInt(x);
            ds.writeInt(y);
            ds.writeInt(z);
            for (byte b : data) {
                ds.writeByte(b);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        StevesCarts.packetHandler.sendToAllAround(PacketHandler.createPacket(bs.toByteArray()), new NetworkRegistry.TargetPoint(world.field_73011_w.field_76574_g, (double)x, (double)y, (double)z, 64.0));
    }
}

