/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.shadow.io.nettyopis.handler.codec.http.websocketx;

import mcp.mobius.shadow.io.nettyopis.channel.Channel;
import mcp.mobius.shadow.io.nettyopis.channel.ChannelFuture;
import mcp.mobius.shadow.io.nettyopis.channel.ChannelPromise;
import mcp.mobius.shadow.io.nettyopis.handler.codec.http.DefaultHttpResponse;
import mcp.mobius.shadow.io.nettyopis.handler.codec.http.HttpRequest;
import mcp.mobius.shadow.io.nettyopis.handler.codec.http.HttpResponseStatus;
import mcp.mobius.shadow.io.nettyopis.handler.codec.http.HttpVersion;
import mcp.mobius.shadow.io.nettyopis.handler.codec.http.websocketx.WebSocketServerHandshaker;
import mcp.mobius.shadow.io.nettyopis.handler.codec.http.websocketx.WebSocketServerHandshaker00;
import mcp.mobius.shadow.io.nettyopis.handler.codec.http.websocketx.WebSocketServerHandshaker07;
import mcp.mobius.shadow.io.nettyopis.handler.codec.http.websocketx.WebSocketServerHandshaker08;
import mcp.mobius.shadow.io.nettyopis.handler.codec.http.websocketx.WebSocketServerHandshaker13;
import mcp.mobius.shadow.io.nettyopis.handler.codec.http.websocketx.WebSocketVersion;

public class WebSocketServerHandshakerFactory {
    private final String webSocketURL;
    private final String subprotocols;
    private final boolean allowExtensions;
    private final int maxFramePayloadLength;

    public WebSocketServerHandshakerFactory(String webSocketURL, String subprotocols, boolean allowExtensions) {
        this(webSocketURL, subprotocols, allowExtensions, 65536);
    }

    public WebSocketServerHandshakerFactory(String webSocketURL, String subprotocols, boolean allowExtensions, int maxFramePayloadLength) {
        this.webSocketURL = webSocketURL;
        this.subprotocols = subprotocols;
        this.allowExtensions = allowExtensions;
        this.maxFramePayloadLength = maxFramePayloadLength;
    }

    public WebSocketServerHandshaker newHandshaker(HttpRequest req) {
        String version = req.headers().get("Sec-WebSocket-Version");
        if (version != null) {
            if (version.equals(WebSocketVersion.V13.toHttpHeaderValue())) {
                return new WebSocketServerHandshaker13(this.webSocketURL, this.subprotocols, this.allowExtensions, this.maxFramePayloadLength);
            }
            if (version.equals(WebSocketVersion.V08.toHttpHeaderValue())) {
                return new WebSocketServerHandshaker08(this.webSocketURL, this.subprotocols, this.allowExtensions, this.maxFramePayloadLength);
            }
            if (version.equals(WebSocketVersion.V07.toHttpHeaderValue())) {
                return new WebSocketServerHandshaker07(this.webSocketURL, this.subprotocols, this.allowExtensions, this.maxFramePayloadLength);
            }
            return null;
        }
        return new WebSocketServerHandshaker00(this.webSocketURL, this.subprotocols, this.maxFramePayloadLength);
    }

    @Deprecated
    public static void sendUnsupportedWebSocketVersionResponse(Channel channel) {
        WebSocketServerHandshakerFactory.sendUnsupportedVersionResponse(channel);
    }

    public static ChannelFuture sendUnsupportedVersionResponse(Channel channel) {
        return WebSocketServerHandshakerFactory.sendUnsupportedVersionResponse(channel, channel.newPromise());
    }

    public static ChannelFuture sendUnsupportedVersionResponse(Channel channel, ChannelPromise promise) {
        DefaultHttpResponse res = new DefaultHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.UPGRADE_REQUIRED);
        res.headers().set("Sec-WebSocket-Version", (Object)WebSocketVersion.V13.toHttpHeaderValue());
        return channel.write(res, promise);
    }
}

