/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizons.modularui.common.widget.textfield;

import com.gtnewhorizons.modularui.api.GlStateManager;
import com.gtnewhorizons.modularui.api.drawable.TextRenderer;
import com.gtnewhorizons.modularui.api.math.Color;
import com.gtnewhorizons.modularui.common.widget.textfield.TextFieldHandler;
import com.gtnewhorizons.modularui.config.Config;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.awt.Point;
import java.awt.geom.Point2D;
import java.util.Collections;
import java.util.List;
import net.minecraft.client.renderer.Tessellator;
import org.apache.commons.lang3.tuple.Pair;
import org.lwjgl.opengl.GL11;

public class TextFieldRenderer
extends TextRenderer {
    protected final TextFieldHandler handler;
    protected int markedColor = 3109544;
    protected boolean renderCursor = false;

    public TextFieldRenderer(TextFieldHandler handler) {
        this.handler = handler;
    }

    public void toggleCursor() {
        this.renderCursor = !this.renderCursor;
    }

    public void setCursor(boolean active) {
        this.renderCursor = active;
    }

    public void setMarkedColor(int markedColor) {
        this.markedColor = markedColor;
    }

    @Override
    protected void drawMeasuredLines(List<Pair<String, Float>> measuredLines) {
        this.drawCursors(measuredLines);
        super.drawMeasuredLines(measuredLines);
    }

    @Override
    public List<String> wrapLine(String line) {
        return Collections.singletonList(line);
    }

    protected void drawCursors(List<Pair<String, Float>> measuredLines) {
        if (!this.simulate) {
            Point2D.Float start;
            if (this.handler.hasTextMarked()) {
                start = this.getPosOf(measuredLines, this.handler.getStartCursor());
                Point2D.Float end = this.getPosOf(measuredLines, this.handler.getEndCursor());
                if (start.y == end.y) {
                    this.drawMarked(start.y, start.x, end.x);
                } else {
                    int min = this.handler.getStartCursor().y;
                    int max = this.handler.getEndCursor().y;
                    Pair<String, Float> line = measuredLines.get(min);
                    int startX = this.getStartX(((Float)line.getValue()).floatValue());
                    this.drawMarked(start.y, start.x, (float)startX + ((Float)line.getValue()).floatValue());
                    start.y += this.getFontHeight();
                    if (max - min > 1) {
                        for (int i = min + 1; i < max; ++i) {
                            line = measuredLines.get(i);
                            startX = this.getStartX(((Float)line.getValue()).floatValue());
                            this.drawMarked(start.y, startX, (float)startX + ((Float)line.getValue()).floatValue());
                            start.y += this.getFontHeight();
                        }
                    }
                    line = measuredLines.get(max);
                    startX = this.getStartX(((Float)line.getValue()).floatValue());
                    this.drawMarked(start.y, startX, end.x);
                }
            }
            start = this.getPosOf(measuredLines, this.handler.getMainCursor());
            if (this.renderCursor) {
                this.drawCursor(start.x, start.y);
            }
        }
    }

    public Point getCursorPos(List<String> lines, int x, int y) {
        if (lines.isEmpty()) {
            return new Point();
        }
        List<Pair<String, Float>> measuredLines = this.measureLines(lines);
        int index = (int)((float)(y -= this.getStartY(measuredLines.size()) + this.y) / this.getFontHeight());
        if (index < 0) {
            return new Point();
        }
        if (index >= measuredLines.size()) {
            return new Point(((String)measuredLines.get(measuredLines.size() - 1).getKey()).length(), measuredLines.size() - 1);
        }
        Pair<String, Float> line = measuredLines.get(index);
        x -= this.getStartX(((Float)line.getValue()).floatValue()) + this.x;
        if (((Float)line.getValue()).floatValue() <= 0.0f) {
            return new Point(0, index);
        }
        if (((Float)line.getValue()).floatValue() < (float)x) {
            return new Point(((String)line.getKey()).length(), index);
        }
        float currentX = 0.0f;
        for (int i = 0; i < ((String)line.getKey()).length(); ++i) {
            char c = ((String)line.getKey()).charAt(i);
            if (!((currentX += (float)TextFieldRenderer.getFontRenderer().func_78263_a(c) * this.scale) >= (float)x)) continue;
            return new Point(i, index);
        }
        return new Point();
    }

    public Point2D.Float getPosOf(List<Pair<String, Float>> measuredLines, Point cursorPos) {
        if (measuredLines.isEmpty()) {
            return new Point2D.Float(this.getStartX(0.0f), this.getStartY(1));
        }
        Pair<String, Float> line = measuredLines.get(cursorPos.y);
        String sub = ((String)line.getKey()).substring(0, Math.min(((String)line.getKey()).length(), cursorPos.x));
        return new Point2D.Float((float)this.getStartX(((Float)line.getRight()).floatValue()) + (float)TextFieldRenderer.getFontRenderer().func_78256_a(sub) * this.scale, (float)this.getStartY(measuredLines.size()) + (float)cursorPos.y * this.getFontHeight());
    }

    @SideOnly(value=Side.CLIENT)
    public void drawMarked(float y0, float x0, float x1) {
        float y1 = (y0 -= 1.0f) + this.getFontHeight();
        float red = Color.getRedF(this.markedColor);
        float green = Color.getGreenF(this.markedColor);
        float blue = Color.getBlueF(this.markedColor);
        float alpha = Color.getAlphaF(this.markedColor);
        if (alpha == 0.0f) {
            alpha = 1.0f;
        }
        Tessellator tessellator = Tessellator.field_78398_a;
        GL11.glEnable((int)16384);
        GL11.glEnable((int)2903);
        GlStateManager.color(red, green, blue, alpha);
        GlStateManager.disableTexture2D();
        tessellator.func_78382_b();
        tessellator.func_78377_a((double)x0, (double)y1, 0.0);
        tessellator.func_78377_a((double)x1, (double)y1, 0.0);
        tessellator.func_78377_a((double)x1, (double)y0, 0.0);
        tessellator.func_78377_a((double)x0, (double)y0, 0.0);
        tessellator.func_78381_a();
        GlStateManager.disableColorLogic();
        GlStateManager.enableTexture2D();
        GlStateManager.color(1.0f, 1.0f, 1.0f, 1.0f);
    }

    @SideOnly(value=Side.CLIENT)
    private void drawCursor(float x0, float y0) {
        float y1;
        float x1;
        switch (Config.textCursor) {
            case "vertical": {
                x0 = (x0 - 0.8f) / this.scale;
                y0 = (y0 - 1.0f) / this.scale;
                x1 = x0 + 0.6f;
                y1 = y0 + 9.0f;
                break;
            }
            default: {
                y0 = (y0 + 7.5f) / this.scale;
                x1 = (x0 /= this.scale) + 7.0f;
                y1 = y0 + 1.0f;
            }
        }
        float red = Color.getRedF(this.color);
        float green = Color.getGreenF(this.color);
        float blue = Color.getBlueF(this.color);
        float alpha = Color.getAlphaF(this.color);
        if (alpha == 0.0f) {
            alpha = 1.0f;
        }
        Tessellator tessellator = Tessellator.field_78398_a;
        GlStateManager.disableBlend();
        GlStateManager.pushMatrix();
        GlStateManager.scale(this.scale, this.scale, 0.0f);
        GlStateManager.color(red, green, blue, alpha);
        GlStateManager.disableTexture2D();
        tessellator.func_78382_b();
        tessellator.func_78377_a((double)x0, (double)y1, 0.0);
        tessellator.func_78377_a((double)x1, (double)y1, 0.0);
        tessellator.func_78377_a((double)x1, (double)y0, 0.0);
        tessellator.func_78377_a((double)x0, (double)y0, 0.0);
        tessellator.func_78381_a();
        GlStateManager.color(1.0f, 1.0f, 1.0f, 1.0f);
        GlStateManager.enableTexture2D();
        GlStateManager.popMatrix();
        GlStateManager.enableBlend();
    }
}

