/*
 * Decompiled with CFR 0.152.
 */
package com.github.dcysteine.neicustomdiagram.util;

import com.github.dcysteine.neicustomdiagram.main.config.ConfigOptions;
import com.google.common.base.Strings;
import java.util.Stack;
import net.minecraft.util.EnumChatFormatting;

public class NbtUtil {
    private NbtUtil() {
    }

    public static String prettyPrintNbt(String nbt) {
        return new NbtPrettyPrinter().prettyPrint(nbt);
    }

    private static class NbtPrettyPrinter {
        private static final EnumChatFormatting BRACE_COLOUR = EnumChatFormatting.DARK_AQUA;
        private static final EnumChatFormatting BRACKET_COLOUR = EnumChatFormatting.DARK_GREEN;
        private static final EnumChatFormatting COLON_COLOUR = EnumChatFormatting.DARK_BLUE;
        private static final EnumChatFormatting QUOTE_COLOUR = EnumChatFormatting.DARK_RED;
        private static final EnumChatFormatting KEY_COLOUR = EnumChatFormatting.DARK_PURPLE;
        private static final EnumChatFormatting VALUE_COLOUR = EnumChatFormatting.BLACK;
        private static final EnumChatFormatting LIST_COLOUR = EnumChatFormatting.DARK_GRAY;
        private static final EnumChatFormatting RESET = EnumChatFormatting.RESET;
        private int indent = 0;
        private Stack<EnumChatFormatting> newlineFormatting = new Stack();
        private boolean isNewLine = true;
        private StringBuilder builder;

        private NbtPrettyPrinter() {
        }

        public String prettyPrint(String nbt) {
            this.builder = new StringBuilder();
            char[] chars = nbt.toCharArray();
            block9: for (int i = 0; i < chars.length; ++i) {
                char c = chars[i];
                switch (c) {
                    case ':': {
                        this.applyIndent();
                        this.setFormatting(COLON_COLOUR);
                        this.builder.append(c);
                        if (!ConfigOptions.NBT_VIEWER_NEWLINE_VALUES.get().booleanValue() || chars[i + 1] == '[' || chars[i + 1] == '{') {
                            this.builder.append(' ');
                        } else {
                            ++this.indent;
                            this.newLine();
                            this.applyIndent();
                            --this.indent;
                        }
                        this.setFormatting(VALUE_COLOUR);
                        continue block9;
                    }
                    case '\"': {
                        this.applyIndent();
                        this.setFormatting(RESET);
                        this.setFormatting(QUOTE_COLOUR);
                        this.builder.append(c);
                        this.setFormatting(VALUE_COLOUR);
                        continue block9;
                    }
                    case ',': {
                        this.newLine();
                        continue block9;
                    }
                    case '[': {
                        this.newlineFormatting.push(LIST_COLOUR);
                        this.applyIndent();
                        this.setFormatting(BRACKET_COLOUR);
                        this.builder.append(c);
                        ++this.indent;
                        this.newLine();
                        continue block9;
                    }
                    case '{': {
                        this.newlineFormatting.push(KEY_COLOUR);
                        this.applyIndent();
                        this.setFormatting(BRACE_COLOUR);
                        this.builder.append(c);
                        ++this.indent;
                        this.newLine();
                        continue block9;
                    }
                    case ']': {
                        this.newlineFormatting.pop();
                        --this.indent;
                        this.newLine();
                        this.applyIndent();
                        this.setFormatting(BRACKET_COLOUR);
                        this.builder.append(c);
                        this.newLine();
                        continue block9;
                    }
                    case '}': {
                        this.newlineFormatting.pop();
                        --this.indent;
                        this.newLine();
                        this.applyIndent();
                        this.setFormatting(BRACE_COLOUR);
                        this.builder.append(c);
                        this.newLine();
                        continue block9;
                    }
                    default: {
                        this.applyIndent();
                        this.builder.append(c);
                    }
                }
            }
            return this.builder.toString();
        }

        private void newLine() {
            if (this.isNewLine) {
                return;
            }
            this.builder.append('\n');
            if (!this.newlineFormatting.empty()) {
                this.setFormatting(this.newlineFormatting.peek());
            }
            this.isNewLine = true;
        }

        private void applyIndent() {
            if (!this.isNewLine) {
                return;
            }
            this.builder.append(Strings.repeat((String)"  ", (int)this.indent));
            this.isNewLine = false;
        }

        private void setFormatting(EnumChatFormatting formatting) {
            this.builder.append(formatting);
        }
    }
}

