/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.blocks.aesthetics.lantern;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import mods.railcraft.common.blocks.aesthetics.brick.BrickVariant;
import mods.railcraft.common.blocks.aesthetics.brick.EnumBrick;
import mods.railcraft.common.blocks.aesthetics.lantern.BlockLantern;
import mods.railcraft.common.blocks.aesthetics.lantern.LanternInfo;
import mods.railcraft.common.core.RailcraftConfig;
import mods.railcraft.common.modules.ModuleManager;
import mods.railcraft.common.plugins.forge.CraftingPlugin;
import mods.railcraft.common.util.inventory.InvTools;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraftforge.common.util.ForgeDirection;

public enum EnumLanternStone implements LanternInfo
{
    ABYSSAL,
    BLEACHEDBONE,
    BLOODSTAINED,
    FROSTBOUND,
    INFERNAL,
    NETHER,
    QUARRIED,
    SANDY,
    SANDSTONE,
    STONE;

    public static final EnumLanternStone[] VALUES;
    public static final Map<String, EnumLanternStone> NAMES;
    public static final List<EnumLanternStone> creativeList;
    private ItemStack source;

    public static void initialize() {
        EnumLanternStone.ABYSSAL.source = EnumBrick.ABYSSAL.get(BrickVariant.BLOCK, 1);
        EnumLanternStone.BLEACHEDBONE.source = EnumBrick.BLEACHEDBONE.get(BrickVariant.BLOCK, 1);
        EnumLanternStone.BLOODSTAINED.source = EnumBrick.BLOODSTAINED.get(BrickVariant.BLOCK, 1);
        EnumLanternStone.FROSTBOUND.source = EnumBrick.FROSTBOUND.get(BrickVariant.BLOCK, 1);
        EnumLanternStone.INFERNAL.source = EnumBrick.INFERNAL.get(BrickVariant.BLOCK, 1);
        EnumLanternStone.NETHER.source = EnumBrick.NETHER.get(BrickVariant.BLOCK, 1);
        EnumLanternStone.QUARRIED.source = EnumBrick.QUARRIED.get(BrickVariant.BLOCK, 1);
        EnumLanternStone.SANDY.source = EnumBrick.SANDY.get(BrickVariant.BLOCK, 1);
        EnumLanternStone.SANDSTONE.source = new ItemStack((Block)Blocks.field_150333_U, 1, 1);
        EnumLanternStone.STONE.source = new ItemStack((Block)Blocks.field_150333_U, 1, 0);
        for (EnumLanternStone lamp : VALUES) {
            NAMES.put(lamp.name(), lamp);
            if (lamp.isEnabled() && lamp.source != null) {
                CraftingPlugin.addShapedRecipe(lamp.getItem(1), " S ", " T ", " S ", Character.valueOf('S'), lamp.getSource(), Character.valueOf('T'), new ItemStack(Blocks.field_150478_aa));
            }
            creativeList.add(lamp);
        }
    }

    public static EnumLanternStone fromOrdinal(int id) {
        if (id < 0 || id >= VALUES.length) {
            return VALUES[0];
        }
        return VALUES[id];
    }

    public static EnumLanternStone fromName(String name) {
        EnumLanternStone lamp = NAMES.get(name);
        if (lamp != null) {
            return lamp;
        }
        return ABYSSAL;
    }

    @Override
    public IIcon getTexture(int side) {
        return InvTools.getBlockFromStack(this.source).func_149691_a(ForgeDirection.UP.ordinal(), this.source.func_77960_j());
    }

    @Override
    public Block getBlock() {
        return BlockLantern.getBlockStone();
    }

    @Override
    public ItemStack getSource() {
        if (this.source == null) {
            return null;
        }
        return this.source.func_77946_l();
    }

    @Override
    public ItemStack getItem() {
        return this.getItem(1);
    }

    @Override
    public ItemStack getItem(int qty) {
        Block block = this.getBlock();
        if (block == null) {
            return null;
        }
        return new ItemStack(block, qty, this.ordinal());
    }

    @Override
    public String getTag() {
        return "railcraft.lantern.stone." + this.name().replace("_", ".").toLowerCase(Locale.ENGLISH);
    }

    @Override
    public boolean isEnabled() {
        return ModuleManager.isModuleLoaded(ModuleManager.Module.STRUCTURES) && RailcraftConfig.isSubBlockEnabled(this.getTag()) && this.getBlock() != null;
    }

    static {
        VALUES = EnumLanternStone.values();
        NAMES = new HashMap<String, EnumLanternStone>();
        creativeList = new ArrayList<EnumLanternStone>();
    }
}

