/*
 * Decompiled with CFR 0.152.
 */
package de.katzenpapst.amunra.client.gui;

import de.katzenpapst.amunra.AmunRa;
import de.katzenpapst.amunra.client.gui.GuiARCelestialSelection;
import de.katzenpapst.amunra.crafting.RecipeHelper;
import de.katzenpapst.amunra.helper.AstronomyHelper;
import de.katzenpapst.amunra.helper.ShuttleTeleportHelper;
import de.katzenpapst.amunra.mothership.Mothership;
import de.katzenpapst.amunra.network.packet.PacketSimpleAR;
import de.katzenpapst.amunra.vec.BoxInt2D;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import micdoodle8.mods.galacticraft.api.galaxies.CelestialBody;
import micdoodle8.mods.galacticraft.api.galaxies.IChildBody;
import micdoodle8.mods.galacticraft.api.galaxies.Satellite;
import micdoodle8.mods.galacticraft.api.recipe.SpaceStationRecipe;
import micdoodle8.mods.galacticraft.core.client.gui.screen.GuiCelestialSelection;
import micdoodle8.mods.galacticraft.core.util.ColorUtil;
import micdoodle8.mods.galacticraft.core.util.GCCoreUtil;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import org.lwjgl.opengl.GL11;

public class GuiShuttleSelection
extends GuiARCelestialSelection {
    protected boolean createMothershipButtonDisabled = false;
    protected BoxInt2D exitBtnArea = new BoxInt2D();
    protected BoxInt2D buildMsBtnArea = new BoxInt2D();

    public GuiShuttleSelection(GuiCelestialSelection.MapMode mapMode, List<CelestialBody> possibleBodies) {
        super(mapMode, possibleBodies);
    }

    protected CelestialBody getParent(CelestialBody body) {
        if (body instanceof IChildBody) {
            IChildBody child = (IChildBody)body;
            return child.getParentPlanet();
        }
        if (body instanceof Mothership) {
            Mothership ship = (Mothership)body;
            return ship.getParent();
        }
        return body;
    }

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();
        CelestialBody currentPlayerBody = ShuttleTeleportHelper.getCelestialBodyForDimensionID(this.field_146297_k.field_71439_g.field_71093_bK);
        if (currentPlayerBody != null) {
            this.selectAndZoom(currentPlayerBody);
        }
    }

    @Override
    public void drawButtons(int mousePosX, int mousePosY) {
        this.possibleBodies = this.shuttlePossibleBodies;
        super.drawButtons(mousePosX, mousePosY);
        if (this.selectionState != GuiCelestialSelection.EnumSelectionState.PROFILE && this.selectedBody != null && this.canCreateMothership(this.selectedBody)) {
            this.drawMothershipButton(mousePosX, mousePosY);
        }
        GL11.glColor4f((float)0.0f, (float)1.0f, (float)0.1f, (float)1.0f);
        this.field_146297_k.field_71446_o.func_110577_a(GuiCelestialSelection.guiMain0);
        int exitWidth = this.field_146294_l - GuiCelestialSelection.BORDER_WIDTH - GuiCelestialSelection.BORDER_EDGE_WIDTH - 74;
        int exitHeight = this.field_146295_m - GuiCelestialSelection.BORDER_WIDTH - GuiCelestialSelection.BORDER_EDGE_WIDTH - 11;
        this.exitBtnArea.setPositionSize(exitWidth, exitHeight, 74, 11);
        this.drawTexturedModalRect(this.exitBtnArea.minX, this.exitBtnArea.minY, this.exitBtnArea.getWidth(), this.exitBtnArea.getHeight(), 0, 392, 148, 22, true, true);
        String str = GCCoreUtil.translate((String)"gui.message.cancel.name").toUpperCase();
        this.field_146289_q.func_78276_b(str, this.exitBtnArea.minX + (this.exitBtnArea.getWidth() - this.field_146289_q.func_78256_a(str)) / 2, this.exitBtnArea.minY + 2, -1);
    }

    protected void func_73869_a(char typedChar, int keyCode) {
        super.func_73869_a(typedChar, keyCode);
    }

    protected boolean canCreateSpaceStation(CelestialBody atBody) {
        return false;
    }

    protected boolean canCreateMothership(CelestialBody atBody) {
        if (this.numPlayersMotherships < 0 || this.playerParent == null) {
            return false;
        }
        return (AmunRa.config.maxNumMotherships == -1 || this.numPlayersMotherships < AmunRa.config.maxNumMotherships) && this.playerParent == this.selectedBody && Mothership.canBeOrbited(atBody);
    }

    protected void drawItemForRecipe(ItemStack item, int amount, int requiredAmount, int xPos, int yPos, int mousePosX, int mousePosY) {
        RenderHelper.func_74520_c();
        GuiScreen.field_146296_j.func_82406_b(this.field_146289_q, this.field_146297_k.field_71446_o, item, xPos, yPos);
        RenderHelper.func_74518_a();
        GL11.glEnable((int)3042);
        if (this.isMouseWithin(mousePosX, mousePosY, xPos, yPos, 16, 16)) {
            this.showTooltip(item.func_82833_r(), mousePosX, mousePosY);
        }
        String str = "" + amount + "/" + requiredAmount;
        boolean valid = amount >= requiredAmount;
        int color = valid | this.field_146297_k.field_71439_g.field_71075_bZ.field_75098_d ? -16711936 : -65536;
        this.smallFontRenderer.drawString(str, xPos + 8 - this.smallFontRenderer.getStringWidth(str) / 2, yPos + 16, color);
    }

    protected void drawMothershipButton(int mousePosX, int mousePosY) {
        boolean offset = false;
        GL11.glColor4f((float)0.0f, (float)0.6f, (float)1.0f, (float)1.0f);
        this.field_146297_k.field_71446_o.func_110577_a(GuiCelestialSelection.guiMain1);
        int canCreateLength = Math.max(0, this.drawSplitString(GCCoreUtil.translate((String)"gui.message.canCreateMothership.name"), 0, 0, 91, 0, true, true) - 2);
        int canCreateOffset = canCreateLength * this.smallFontRenderer.FONT_HEIGHT;
        this.drawTexturedModalRect(this.field_146294_l - GuiCelestialSelection.BORDER_WIDTH - GuiCelestialSelection.BORDER_EDGE_WIDTH - 95, 0 + GuiCelestialSelection.BORDER_WIDTH + GuiCelestialSelection.BORDER_EDGE_WIDTH + 134, 93, 4, 159, 102, 93, 4, false, false);
        for (int barY = 0; barY < canCreateLength; ++barY) {
            this.drawTexturedModalRect(this.field_146294_l - GuiCelestialSelection.BORDER_WIDTH - GuiCelestialSelection.BORDER_EDGE_WIDTH - 95, 0 + GuiCelestialSelection.BORDER_WIDTH + GuiCelestialSelection.BORDER_EDGE_WIDTH + 138 + barY * this.smallFontRenderer.FONT_HEIGHT, 93, this.smallFontRenderer.FONT_HEIGHT, 159, 106, 93, this.smallFontRenderer.FONT_HEIGHT, false, false);
        }
        this.drawTexturedModalRect(this.field_146294_l - GuiCelestialSelection.BORDER_WIDTH - GuiCelestialSelection.BORDER_EDGE_WIDTH - 95, 0 + GuiCelestialSelection.BORDER_WIDTH + GuiCelestialSelection.BORDER_EDGE_WIDTH + 138 + canCreateOffset, 93, 43, 159, 106, 93, 43, false, false);
        this.drawTexturedModalRect(this.field_146294_l - GuiCelestialSelection.BORDER_WIDTH - GuiCelestialSelection.BORDER_EDGE_WIDTH - 79, 0 + GuiCelestialSelection.BORDER_WIDTH + GuiCelestialSelection.BORDER_EDGE_WIDTH + 129, 61, 4, 0, 170, 61, 4, false, false);
        int xPos = 0;
        int yPos = 0 + GuiCelestialSelection.BORDER_WIDTH + GuiCelestialSelection.BORDER_EDGE_WIDTH + 154 + canCreateOffset;
        SpaceStationRecipe recipe = RecipeHelper.mothershipRecipe;
        if (recipe != null) {
            GL11.glColor4f((float)0.0f, (float)1.0f, (float)0.1f, (float)1.0f);
            boolean validInputMaterials = true;
            int i = 0;
            for (Map.Entry e : recipe.getInput().entrySet()) {
                Object next = e.getKey();
                xPos = (int)((double)(this.field_146294_l - GuiCelestialSelection.BORDER_WIDTH - GuiCelestialSelection.BORDER_EDGE_WIDTH - 95) + (double)(i * 93) / (double)recipe.getInput().size() + 5.0);
                int requiredAmount = (Integer)e.getValue();
                if (next instanceof ItemStack) {
                    int amount = this.getAmountInInventory((ItemStack)next);
                    this.drawItemForRecipe(((ItemStack)next).func_77946_l(), amount, requiredAmount, xPos, yPos, mousePosX, mousePosY);
                    validInputMaterials = amount >= requiredAmount && validInputMaterials;
                } else if (next instanceof ArrayList) {
                    ArrayList items = (ArrayList)next;
                    int amount = 0;
                    for (ItemStack stack : items) {
                        amount += this.getAmountInInventory(stack);
                    }
                    ItemStack stack = ((ItemStack)items.get(this.ticksSinceMenuOpen / 20 % items.size())).func_77946_l();
                    this.drawItemForRecipe(stack, amount, requiredAmount, xPos, yPos, mousePosX, mousePosY);
                    validInputMaterials = amount >= requiredAmount && validInputMaterials;
                }
                ++i;
            }
            if ((validInputMaterials || this.field_146297_k.field_71439_g.field_71075_bZ.field_75098_d) && !this.createMothershipButtonDisabled) {
                GL11.glColor4f((float)0.0f, (float)1.0f, (float)0.1f, (float)1.0f);
            } else {
                GL11.glColor4f((float)1.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            }
            this.field_146297_k.field_71446_o.func_110577_a(GuiCelestialSelection.guiMain1);
            this.buildMsBtnArea.setPositionSize(this.field_146294_l - GuiCelestialSelection.BORDER_WIDTH - GuiCelestialSelection.BORDER_EDGE_WIDTH - 95, 0 + GuiCelestialSelection.BORDER_WIDTH + GuiCelestialSelection.BORDER_EDGE_WIDTH + 182 + canCreateOffset, 93, 12);
            if (this.mapMode != GuiCelestialSelection.MapMode.VIEW && this.buildMsBtnArea.isWithin(mousePosX, mousePosY)) {
                this.drawTexturedModalRect(this.buildMsBtnArea.minX, this.buildMsBtnArea.minY, this.buildMsBtnArea.getWidth(), this.buildMsBtnArea.getHeight(), 0, 174, 93, 12, false, false);
            }
            this.drawTexturedModalRect(this.buildMsBtnArea.minX, this.buildMsBtnArea.minY, this.buildMsBtnArea.getWidth(), this.buildMsBtnArea.getHeight(), 0, 174, 93, 12, false, false);
            int color = (int)((Math.sin((double)this.ticksSinceMenuOpen / 5.0) * 0.5 + 0.5) * 255.0);
            this.drawSplitString(GCCoreUtil.translate((String)"gui.message.canCreateMothership.name"), this.field_146294_l - GuiCelestialSelection.BORDER_WIDTH - GuiCelestialSelection.BORDER_EDGE_WIDTH - 48, 0 + GuiCelestialSelection.BORDER_WIDTH + GuiCelestialSelection.BORDER_EDGE_WIDTH + 137, 91, ColorUtil.to32BitColor((int)255, (int)color, (int)255, (int)color), true, false);
            if (this.mapMode != GuiCelestialSelection.MapMode.VIEW) {
                this.drawSplitString(GCCoreUtil.translate((String)"gui.message.createSS.name").toUpperCase(), this.field_146294_l - GuiCelestialSelection.BORDER_WIDTH - GuiCelestialSelection.BORDER_EDGE_WIDTH - 48, 0 + GuiCelestialSelection.BORDER_WIDTH + GuiCelestialSelection.BORDER_EDGE_WIDTH + 185 + canCreateOffset, 91, -1, false, false);
            }
        } else {
            this.drawSplitString(GCCoreUtil.translate((String)"gui.message.cannotCreateSpaceStation.name"), this.field_146294_l - GuiCelestialSelection.BORDER_WIDTH - GuiCelestialSelection.BORDER_EDGE_WIDTH - 48, 0 + GuiCelestialSelection.BORDER_WIDTH + GuiCelestialSelection.BORDER_EDGE_WIDTH + 138, 91, -1, true, false);
        }
    }

    protected boolean teleportToSelectedBody() {
        this.possibleBodies = this.shuttlePossibleBodies;
        if (this.selectedBody != null && this.selectedBody.getReachable() && this.possibleBodies != null && this.possibleBodies.contains(this.selectedBody)) {
            try {
                Integer dimensionID = null;
                if (this.selectedBody instanceof Satellite) {
                    if (this.spaceStationMap == null) {
                        AmunRa.LOGGER.error("Please report as a BUG: spaceStationIDs was null.");
                        return false;
                    }
                    Satellite selectedSatellite = (Satellite)this.selectedBody;
                    Integer mapping = ((GuiCelestialSelection.StationDataGUI)((Map)this.spaceStationMap.get(this.getSatelliteParentID(selectedSatellite))).get(this.selectedStationOwner)).getStationDimensionID();
                    if (mapping == null) {
                        AmunRa.LOGGER.error("Problem matching player name in space station check: {}", new Object[]{this.selectedStationOwner});
                        return false;
                    }
                    int spacestationID = mapping;
                    dimensionID = spacestationID;
                } else {
                    dimensionID = this.selectedBody.getDimensionID();
                }
                AmunRa.packetPipeline.sendToServer(new PacketSimpleAR(PacketSimpleAR.EnumSimplePacket.S_TELEPORT_SHUTTLE, dimensionID));
                this.field_146297_k.func_147108_a(null);
                return true;
            }
            catch (Exception e) {
                AmunRa.LOGGER.warn("Failed to teleport to selected body", (Throwable)e);
            }
        }
        return false;
    }

    @Override
    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) {
        boolean clickHandled = false;
        if (this.mapMode != GuiCelestialSelection.MapMode.VIEW) {
            SpaceStationRecipe recipe;
            if (this.exitBtnArea.isWithin(mouseX, mouseY)) {
                this.cancelLaunch();
                clickHandled = true;
            } else if (this.buildMsBtnArea.isWithin(mouseX, mouseY) && this.selectedBody != null && (recipe = RecipeHelper.mothershipRecipe) != null && this.canCreateMothership(this.selectedBody) && !this.createMothershipButtonDisabled) {
                if (recipe.matches((EntityPlayer)this.field_146297_k.field_71439_g, false) || this.field_146297_k.field_71439_g.field_71075_bZ.field_75098_d) {
                    this.createMothershipButtonDisabled = true;
                    AmunRa.packetPipeline.sendToServer(new PacketSimpleAR(PacketSimpleAR.EnumSimplePacket.S_CREATE_MOTHERSHIP, AstronomyHelper.getOrbitableBodyName(this.selectedBody)));
                }
                clickHandled = true;
            }
        }
        if (!clickHandled) {
            super.func_73864_a(mouseX, mouseY, mouseButton);
        }
    }

    protected void cancelLaunch() {
        AmunRa.packetPipeline.sendToServer(new PacketSimpleAR(PacketSimpleAR.EnumSimplePacket.S_CANCEL_SHUTTLE, new Object[0]));
    }

    @Override
    public void mothershipCreationFailed() {
        this.createMothershipButtonDisabled = false;
    }

    @Override
    public void newMothershipCreated(Mothership ship) {
        super.newMothershipCreated(ship);
        if (ship.isPlayerOwner((EntityPlayer)this.field_146297_k.field_71439_g)) {
            this.selectAndZoom(ship);
        }
        this.createMothershipButtonDisabled = false;
    }
}

